/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.unit;

import com.scudata.common.Logger;
import com.scudata.common.UUID;
import com.scudata.dm.Context;
import com.scudata.dm.JobSpaceManager;
import com.scudata.server.ConnectionProxyManager;
import com.scudata.server.IProxy;
import com.scudata.server.unit.StatementProxy;
import com.scudata.server.unit.UnitServer;
import com.scudata.util.DatabaseUtil;
import java.util.List;

public class ConnectionProxy
extends IProxy {
    String _$6;
    Context _$5 = new Context();
    boolean _$4 = false;

    public ConnectionProxy(ConnectionProxyManager cpm, int id) {
        super(cpm, id);
        List<String> connectedDsNames = null;
        UnitServer us = UnitServer.instance;
        if (us != null && us.getRaqsoftConfig() != null) {
            connectedDsNames = us.getRaqsoftConfig().getAutoConnectList();
        }
        DatabaseUtil.connectAutoDBs(this._$5, connectedDsNames);
        this._$6 = UUID.randomUUID().toString();
        this._$5.setJobSpace(JobSpaceManager.getSpace(this._$6));
        this.access();
        Logger.debug(this + " connected.");
    }

    public String getSpaceId() {
        return this._$6;
    }

    public StatementProxy getStatementProxy(int id) throws Exception {
        StatementProxy sp = (StatementProxy)this.getProxy(id);
        if (sp == null) {
            throw new Exception("Statement " + id + " is not exist or out of time!");
        }
        return sp;
    }

    public Context getContext() {
        return this._$5;
    }

    public boolean isClosed() {
        return this._$4;
    }

    public void close() {
        JobSpaceManager.closeSpace(this._$6);
        DatabaseUtil.closeAutoDBs(this._$5);
        this._$4 = true;
        Logger.debug(this + " closed.");
    }

    public String toString() {
        return "Connection " + this.getId();
    }
}

