/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.server.unit;

import com.esproc.jdbc.JDBCUtil;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.parallel.Request;
import com.scudata.parallel.Response;
import com.scudata.parallel.TaskManager;
import com.scudata.server.ConnectionProxyManager;
import com.scudata.server.unit.ConnectionProxy;
import com.scudata.server.unit.StatementProxy;
import com.scudata.server.unit.UnitServer;
import java.util.ArrayList;
import java.util.Map;

public class JdbcManager {
    private static ConnectionProxy _$1(int connId) throws Exception {
        ConnectionProxyManager cpm = ConnectionProxyManager.getInstance();
        return (ConnectionProxy)cpm.getConnectionProxy(connId);
    }

    public static Response execute(Request req) {
        ConnectionProxyManager cpm = ConnectionProxyManager.getInstance();
        Response res = new Response();
        try {
            switch (req.getAction()) {
                case 70001: {
                    int connId = UnitServer.nextId();
                    ConnectionProxy connProxy = new ConnectionProxy(cpm, connId);
                    cpm.addProxy(connProxy);
                    res.setResult(connId);
                    break;
                }
                case 70005: {
                    int connId = (Integer)req.getAttr("getTables connId");
                    String tableName = (String)req.getAttr("tableNamePattern");
                    Table table = JDBCUtil.getTables(tableName);
                    res.setResult(table);
                    break;
                }
                case 70006: {
                    int connId = (Integer)req.getAttr("getTableColumns connId");
                    String tableName = (String)req.getAttr("tableNamePattern");
                    String columnName = (String)req.getAttr("columnNamePattern");
                    ConnectionProxy connProxy = JdbcManager._$1(connId);
                    Table table = JDBCUtil.getColumns(tableName, columnName, connProxy.getContext());
                    res.setResult(table);
                    break;
                }
                case 70007: {
                    int connId = (Integer)req.getAttr("getProcedures connId");
                    String tableName = (String)req.getAttr("procedureNamePattern");
                    Table table = JDBCUtil.getProcedures(tableName);
                    res.setResult(table);
                    break;
                }
                case 70008: {
                    int connId = (Integer)req.getAttr("getProcedureColumns connId");
                    String tableName = (String)req.getAttr("procedureNamePattern");
                    String columnName = (String)req.getAttr("procedureColumnNamePattern");
                    ConnectionProxy connProxy = JdbcManager._$1(connId);
                    Table table = JDBCUtil.getProcedureColumns(tableName, columnName);
                    res.setResult(table);
                    break;
                }
                case 70009: {
                    int connId = (Integer)req.getAttr("getProcedureColumns connId");
                    String tableName = (String)req.getAttr("splPath");
                    ConnectionProxy connProxy = JdbcManager._$1(connId);
                    Table table = JDBCUtil.getSplParams(tableName);
                    res.setResult(table);
                    break;
                }
                case 70002: {
                    int connId = (Integer)req.getAttr("prepare connId");
                    String dfx = (String)req.getAttr("prepare cmd");
                    Object[] args = (Object[])req.getAttr("prepare args");
                    Map envParams = (Map)req.getAttr("prepare env");
                    ArrayList<Object> argList = new ArrayList<Object>();
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            argList.add(args[i]);
                        }
                    }
                    ConnectionProxy connProxy = JdbcManager._$1(connId);
                    int stateId = UnitServer.nextId();
                    StatementProxy sp = new StatementProxy(connProxy, stateId, dfx, argList, envParams);
                    connProxy.addProxy(sp);
                    TaskManager.addTask(sp);
                    res.setResult(stateId);
                    break;
                }
                case 70003: {
                    int connId = (Integer)req.getAttr("execute connId");
                    int stateId = (Integer)req.getAttr("execute stateId");
                    ConnectionProxy connProxy = JdbcManager._$1(connId);
                    StatementProxy sp = connProxy.getStatementProxy(stateId);
                    Sequence resultIds = sp.execute();
                    res.setResult(resultIds);
                    break;
                }
                case 70004: {
                    int connId = (Integer)req.getAttr("execute connId");
                    int stateId = (Integer)req.getAttr("execute stateId");
                    ConnectionProxy connProxy = JdbcManager._$1(connId);
                    StatementProxy sp = connProxy.getStatementProxy(stateId);
                    res.setResult(sp.cancel());
                    break;
                }
                case 70011: {
                    int connId = (Integer)req.getAttr("execute connId");
                    int stateId = (Integer)req.getAttr("execute stateId");
                    ConnectionProxy connProxy = JdbcManager._$1(connId);
                    StatementProxy sp = connProxy.getStatementProxy(stateId);
                    sp.destroy();
                    res.setResult(Boolean.TRUE);
                    break;
                }
                case 70012: {
                    int connId = (Integer)req.getAttr("execute connId");
                    ConnectionProxy connProxy = JdbcManager._$1(connId);
                    connProxy.destroy();
                    res.setResult(Boolean.TRUE);
                }
            }
        }
        catch (Exception x) {
            res.setException(x);
        }
        return res;
    }
}

