/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.thread;

import com.scudata.array.IArray;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.thread.Job;

class CalcJob
extends Job {
    private Sequence src;
    private int start;
    private int end;
    private Expression exp;
    private Context ctx;
    private Sequence result;

    public CalcJob(Sequence src, int start, int end, Expression exp, Context ctx, Sequence result) {
        this.src = src;
        this.start = start;
        this.end = end;
        this.exp = exp;
        this.ctx = ctx;
        this.result = result;
    }

    @Override
    public void run() {
        int end = this.end;
        Expression exp = this.exp;
        Context ctx = this.ctx;
        IArray resultMems = this.result.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(this.src);
        stack.push(current);
        try {
            int i = this.start;
            while (i < end) {
                current.setCurrent(i);
                resultMems.set(i, exp.calculate(ctx));
                ++i;
            }
        }
        finally {
            stack.pop();
        }
    }
}

