/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.thread;

import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BFileWriter;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.Sequence;
import com.scudata.dm.cursor.ICursor;
import com.scudata.dm.op.IGroupsResult;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.Job;
import com.scudata.util.CursorUtil;
import java.io.IOException;
import java.util.TreeMap;

public class GroupxJob
extends Job {
    private ICursor cursor;
    private Expression gexp;
    private Expression[] exps;
    private String[] names;
    private Expression[] calcExps;
    private String[] calcNames;
    private Context ctx;
    private int fetchCount;
    private int capacity;
    private TreeMap<Object, BFileWriter> fileMap;

    public GroupxJob(ICursor cursor, Expression gexp, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, Context ctx, int fetchCount, TreeMap<Object, BFileWriter> fileMap) {
        this.cursor = cursor;
        this.gexp = gexp;
        this.exps = exps;
        this.names = names;
        this.calcExps = calcExps;
        this.calcNames = calcNames;
        this.ctx = ctx;
        this.fileMap = fileMap;
        this.fetchCount = fetchCount > ICursor.FETCHCOUNT ? fetchCount : ICursor.FETCHCOUNT;
    }

    public GroupxJob(ICursor cursor, Expression[] exps, String[] names, Expression[] calcExps, String[] calcNames, Context ctx, int capacity, int fetchCount, TreeMap<Object, BFileWriter> fileMap) {
        this.cursor = cursor;
        this.exps = exps;
        this.names = names;
        this.calcExps = calcExps;
        this.calcNames = calcNames;
        this.ctx = ctx;
        this.fileMap = fileMap;
        this.capacity = capacity;
        this.fetchCount = fetchCount > ICursor.FETCHCOUNT ? fetchCount : ICursor.FETCHCOUNT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void groupx_g() {
        MessageManager mm = EngineMessage.get();
        String msg = mm.getMessage("engine.createTmpFile");
        ICursor cursor = this.cursor;
        Expression gexp = this.gexp;
        Expression[] exps = this.exps;
        String[] names = this.names;
        Expression[] calcExps = this.calcExps;
        String[] calcNames = this.calcNames;
        Context ctx = this.ctx;
        int fetchCount = this.fetchCount;
        TreeMap<Object, BFileWriter> fileMap = this.fileMap;
        DataStruct ds = cursor.getDataStruct();
        try {
            Sequence seq;
            while ((seq = cursor.fetch(fetchCount)) != null && seq.length() != 0) {
                Sequence groups = seq.group(gexp, null, ctx);
                int gcount = groups.length();
                int i = 1;
                while (i <= gcount) {
                    Sequence group = (Sequence)groups.getMem(i);
                    Object gval = group.calc(1, gexp, ctx);
                    IGroupsResult gresult = IGroupsResult.instance(exps, names, calcExps, calcNames, ds, null, ctx);
                    gresult.push(group, ctx);
                    group = gresult.getTempResult();
                    BFileWriter writer = null;
                    Object object = fileMap;
                    synchronized (object) {
                        writer = fileMap.get(gval);
                        if (writer == null) {
                            FileObject fo = FileObject.createTempFileObject();
                            Logger.info(String.valueOf(msg) + fo.getFileName());
                            writer = new BFileWriter(fo, null);
                            writer.prepareWrite(gresult.getResultDataStruct(), false);
                            fileMap.put(gval, writer);
                        }
                    }
                    object = writer;
                    synchronized (object) {
                        writer.write(group);
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void groupx_n() {
        MessageManager mm = EngineMessage.get();
        String msg = mm.getMessage("engine.createTmpFile");
        ICursor cursor = this.cursor;
        Expression[] exps = this.exps;
        String[] names = this.names;
        Expression[] calcExps = this.calcExps;
        String[] calcNames = this.calcNames;
        Context ctx = this.ctx;
        int capacity = this.capacity;
        int fetchCount = this.fetchCount;
        TreeMap<Object, BFileWriter> fileMap = this.fileMap;
        DataStruct ds = cursor.getDataStruct();
        try {
            Sequence seq;
            while ((seq = cursor.fetch(fetchCount)) != null && seq.length() != 0) {
                IGroupsResult gresult = IGroupsResult.instance(exps, names, calcExps, calcNames, ds, null, ctx);
                gresult.push(seq, ctx);
                seq = gresult.getTempResult();
                Sequence groups = CursorUtil.group_n(seq, capacity);
                int gcount = groups.length();
                int i = 1;
                while (i <= gcount) {
                    Sequence group = (Sequence)groups.getMem(i);
                    if (group.length() != 0) {
                        BaseRecord r = (BaseRecord)group.getMem(1);
                        int index = ((Number)r.getNormalFieldValue(0)).intValue() / capacity + 1;
                        Integer gval = new Integer(index);
                        BFileWriter writer = null;
                        Object object = fileMap;
                        synchronized (object) {
                            writer = fileMap.get(gval);
                            if (writer == null) {
                                FileObject fo = FileObject.createTempFileObject();
                                Logger.info(String.valueOf(msg) + fo.getFileName());
                                writer = new BFileWriter(fo, null);
                                writer.prepareWrite(gresult.getResultDataStruct(), false);
                                fileMap.put(gval, writer);
                            }
                        }
                        object = writer;
                        synchronized (object) {
                            writer.write(group);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new RQException(e);
        }
    }

    @Override
    public void run() {
        if (this.gexp == null) {
            this.groupx_n();
        } else {
            this.groupx_g();
        }
    }
}

