/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.thread;

import com.scudata.dm.ListBase1;
import com.scudata.dm.Sequence;
import com.scudata.dm.comparator.BaseComparator;
import com.scudata.expression.fn.gather.ICount;
import com.scudata.thread.Job;
import com.scudata.util.HashUtil;

public class HashIdJob
extends Job {
    private Sequence src;
    private int start;
    private int end;
    private String opt;
    private Sequence result;

    public HashIdJob(Sequence src, int start, int end, String opt) {
        this.src = src;
        this.start = start;
        this.end = end;
        this.opt = opt;
    }

    @Override
    public void run() {
        Sequence src = this.src;
        int start = this.start;
        int end = this.end;
        int len = end - start;
        this.result = new Sequence(len);
        if (len == 0) {
            return;
        }
        HashUtil hashUtil = new HashUtil(len / 2);
        Sequence out = this.result;
        if (this.opt != null && this.opt.indexOf(110) != -1) {
            ICount.ICountPositionSet set = new ICount.ICountPositionSet();
            int i = start;
            while (i < end) {
                Object item = src.getMem(i);
                if (item instanceof Number && set.add(((Number)item).intValue())) {
                    out.add(item);
                }
                ++i;
            }
        } else if (this.opt != null && this.opt.indexOf(98) != -1) {
            ICount.ICountBitSet set = new ICount.ICountBitSet();
            int i = start;
            while (i < end) {
                Object item = src.getMem(i);
                if (item instanceof Number && set.add(((Number)item).intValue())) {
                    out.add(item);
                }
                ++i;
            }
        } else {
            int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
            ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
            int i = start;
            while (i < end) {
                Object item = src.getMem(i);
                int hash = hashUtil.hashCode(item);
                if (groups[hash] == null) {
                    groups[hash] = new ListBase1(INIT_GROUPSIZE);
                    groups[hash].add(item);
                    out.add(item);
                } else {
                    int index = groups[hash].binarySearch(item);
                    if (index < 1) {
                        groups[hash].add(-index, item);
                        out.add(item);
                    }
                }
                ++i;
            }
        }
        if (this.opt == null || this.opt.indexOf(117) == -1) {
            BaseComparator comparator = new BaseComparator();
            out.getMems().sort(comparator);
        }
    }

    public void getResult(Sequence table) {
        table.getMems().addAll(this.result.getMems());
    }
}

