/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.thread;

import com.scudata.array.DateArray;
import com.scudata.array.StringArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.thread.BitsJob;
import com.scudata.thread.CalcJob;
import com.scudata.thread.DateSortJob;
import com.scudata.thread.DeriveJob;
import com.scudata.thread.DoubleSortJob;
import com.scudata.thread.HashIdJob;
import com.scudata.thread.IntSortJob;
import com.scudata.thread.JobThread;
import com.scudata.thread.LongSortJob;
import com.scudata.thread.NewJob;
import com.scudata.thread.NewsJob;
import com.scudata.thread.RunJob;
import com.scudata.thread.SelectJob;
import com.scudata.thread.SortJob;
import com.scudata.thread.StringSortJob;
import com.scudata.thread.ThreadPool;
import com.scudata.util.CursorUtil;
import com.scudata.util.Variant;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.Date;

public final class MultithreadUtil {
    public static int SINGLE_PROSS_COUNT = 20480;
    private static final int INSERTIONSORT_THRESHOLD = 9;

    public static int getSingleThreadProssCount() {
        return SINGLE_PROSS_COUNT;
    }

    public static void setSingleThreadProssCount(int count) {
        SINGLE_PROSS_COUNT = count;
    }

    private static int getParallelNum() {
        return Env.getParallelNum();
    }

    public static void sort(Object[] vals) {
        MultithreadUtil.sort(vals, 0, vals.length);
    }

    public static void sort(Object[] vals, int fromIndex, int toIndex) {
        MultithreadUtil.rangeCheck(vals.length, fromIndex, toIndex);
        Object[] aux = MultithreadUtil.cloneSubarray(vals, fromIndex, toIndex);
        MultithreadUtil.mergeSort(aux, vals, fromIndex, toIndex, -fromIndex, Env.getParallelNum());
    }

    public static void sort(Object[] vals, Comparator<Object> c) {
        MultithreadUtil.sort(vals, 0, vals.length, c);
    }

    public static void sort(Object[] vals, int fromIndex, int toIndex, Comparator<Object> c) {
        MultithreadUtil.rangeCheck(vals.length, fromIndex, toIndex);
        Object[] aux = MultithreadUtil.cloneSubarray(vals, fromIndex, toIndex);
        MultithreadUtil.mergeSort(aux, vals, fromIndex, toIndex, -fromIndex, c, Env.getParallelNum());
    }

    static void mergeSort(Object[] src, Object[] dest, int low, int high, int off, Comparator<Object> c, int threadCount) {
        int length = high - low;
        if (length <= SINGLE_PROSS_COUNT || threadCount < 2) {
            MultithreadUtil.mergeSort(src, dest, low, high, off, c);
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        SortJob job1 = new SortJob(dest, src, low, mid, -off, c, threadCount / 2);
        SortJob job2 = new SortJob(dest, src, mid, high, -off, c, threadCount / 2);
        new JobThread(job2).start();
        job1.run();
        job2.join();
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, int off, Comparator<Object> c) {
        int length = high - low;
        if (length < 9) {
            int i;
            int j = i = low + 1;
            while (i < high) {
                Object tmp = dest[i];
                while (j > low && c.compare(dest[j - 1], tmp) > 0) {
                    dest[j] = dest[j - 1];
                    --j;
                }
                dest[j] = tmp;
                j = ++i;
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        MultithreadUtil.mergeSort(dest, src, low, mid, -off, c);
        MultithreadUtil.mergeSort(dest, src, mid, high, -off, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    static void mergeSort(Object[] src, Object[] dest, int low, int high, int off, int threadCount) {
        int length = high - low;
        if (length <= SINGLE_PROSS_COUNT || threadCount < 2) {
            MultithreadUtil.mergeSort(src, dest, low, high, off);
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        SortJob job1 = new SortJob(dest, src, low, mid, -off, threadCount / 2);
        SortJob job2 = new SortJob(dest, src, mid, high, -off, threadCount / 2);
        new JobThread(job2).start();
        job1.run();
        job2.join();
        if (Variant.compare(src[mid - 1], src[mid], true) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && Variant.compare(src[p], src[q], true) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 9) {
            int i;
            int j = i = low + 1;
            while (i < high) {
                Object tmp = dest[i];
                while (j > low && Variant.compare(dest[j - 1], tmp, true) > 0) {
                    dest[j] = dest[j - 1];
                    --j;
                }
                dest[j] = tmp;
                j = ++i;
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        MultithreadUtil.mergeSort(dest, src, low, mid, -off);
        MultithreadUtil.mergeSort(dest, src, mid, high, -off);
        if (Variant.compare(src[mid - 1], src[mid], true) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && Variant.compare(src[p], src[q], true) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static Object[] cloneSubarray(Object[] vals, int from, int to) {
        int n = to - from;
        Object result = Array.newInstance(vals.getClass().getComponentType(), n);
        System.arraycopy(vals, from, result, 0, n);
        return (Object[])result;
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    public static Sequence calc(Sequence src, Expression exp, Context ctx) {
        if (exp == null) {
            return src;
        }
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len < 2 || parallelNum < 2) {
            return src.calc(exp, ctx);
        }
        if (parallelNum > len) {
            parallelNum = len;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / parallelNum;
        CalcJob[] jobs = new CalcJob[parallelNum];
        int mod = len % parallelNum;
        int start = 1;
        Sequence result = new Sequence(new Object[len]);
        int i = 0;
        while (i < parallelNum) {
            int end = i + 1 == parallelNum ? len + 1 : (i < mod ? start + singleCount + 1 : start + singleCount);
            Context tmpCtx = ctx.newComputeContext();
            Expression tmpExp = exp.newExpression(tmpCtx);
            jobs[i] = new CalcJob(src, start, end, tmpExp, tmpCtx, result);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        i = 0;
        while (i < parallelNum) {
            jobs[i].join();
            ++i;
        }
        return result;
    }

    public static void run(Sequence src, Expression exp, Context ctx) {
        if (exp == null) {
            return;
        }
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len < 2 || parallelNum < 2) {
            src.run(exp, ctx);
            return;
        }
        if (parallelNum > len) {
            parallelNum = len;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / parallelNum;
        RunJob[] jobs = new RunJob[parallelNum];
        int mod = len % parallelNum;
        int start = 1;
        int i = 0;
        while (i < parallelNum) {
            int end = i + 1 == parallelNum ? len + 1 : (i < mod ? start + singleCount + 1 : start + singleCount);
            Context tmpCtx = ctx.newComputeContext();
            Expression tmpExp = exp.newExpression(tmpCtx);
            jobs[i] = new RunJob(src, start, end, tmpExp, tmpCtx);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        i = 0;
        while (i < parallelNum) {
            jobs[i].join();
            ++i;
        }
    }

    public static void run(Sequence src, Expression[] assignExps, Expression[] exps, Context ctx) {
        if (exps == null || exps.length == 0) {
            return;
        }
        int colCount = exps.length;
        if (assignExps == null) {
            assignExps = new Expression[colCount];
        } else if (assignExps.length != colCount) {
            MessageManager mm = EngineMessage.get();
            throw new RQException("run" + mm.getMessage("function.invalidParam"));
        }
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len <= SINGLE_PROSS_COUNT || parallelNum < 2) {
            src.run(assignExps, exps, ctx);
            return;
        }
        int threadCount = (len - 1) / SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        RunJob[] jobs = new RunJob[threadCount];
        int start = 1;
        int i = 0;
        while (i < threadCount) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression[] tempAssignExps = new Expression[colCount];
            Expression[] tmpExps = new Expression[colCount];
            int k = 0;
            while (k < colCount) {
                tmpExps[k] = exps[k].newExpression(tmpCtx);
                if (assignExps[k] != null) {
                    tempAssignExps[k] = assignExps[k].newExpression(tmpCtx);
                }
                ++k;
            }
            jobs[i] = new RunJob(src, start, end, tempAssignExps, tmpExps, tmpCtx);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        i = 0;
        while (i < threadCount) {
            jobs[i].join();
            ++i;
        }
    }

    public static Object select(Sequence src, Expression exp, Context ctx) {
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len <= SINGLE_PROSS_COUNT || parallelNum < 2) {
            return src.select(exp, null, ctx);
        }
        int threadCount = (len - 1) / SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        SelectJob[] jobs = new SelectJob[threadCount];
        int start = 1;
        int i = 0;
        while (i < threadCount) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression tmpExp = exp.newExpression(tmpCtx);
            jobs[i] = new SelectJob(src, start, end, tmpExp, tmpCtx);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        Sequence result = new Sequence();
        int i2 = 0;
        while (i2 < threadCount) {
            jobs[i2].join();
            jobs[i2].getResult(result);
            ++i2;
        }
        return result;
    }

    public static Object select(Sequence src, Expression[] fltExps, Object[] vals, String opt, Context ctx) {
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len <= SINGLE_PROSS_COUNT || parallelNum < 2) {
            return src.select(fltExps, vals, null, ctx);
        }
        int threadCount = (len - 1) / SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        SelectJob[] jobs = new SelectJob[threadCount];
        int expCount = fltExps.length;
        int start = 1;
        int i = 0;
        while (i < threadCount) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression[] tmpExps = new Expression[expCount];
            int k = 0;
            while (k < expCount) {
                tmpExps[k] = fltExps[k].newExpression(tmpCtx);
                ++k;
            }
            jobs[i] = new SelectJob(src, start, end, tmpExps, vals, tmpCtx);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        Sequence result = new Sequence();
        int i2 = 0;
        while (i2 < threadCount) {
            jobs[i2].join();
            jobs[i2].getResult(result);
            ++i2;
        }
        return result;
    }

    public static Table newTable(Sequence src, DataStruct ds, Expression[] exps, String opt, Context ctx) {
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len <= SINGLE_PROSS_COUNT || parallelNum < 2) {
            return src.newTable(ds, exps, opt, ctx);
        }
        int threadCount = (len - 1) / SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        NewJob[] jobs = new NewJob[threadCount];
        int expCount = exps.length;
        int start = 1;
        int i = 0;
        while (i < threadCount) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression[] tmpExps = new Expression[expCount];
            int k = 0;
            while (k < expCount) {
                tmpExps[k] = exps[k].newExpression(tmpCtx);
                ++k;
            }
            jobs[i] = new NewJob(src, start, end, ds, tmpExps, opt, tmpCtx);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        Table result = new Table(ds, len);
        int i2 = 0;
        while (i2 < threadCount) {
            jobs[i2].join();
            jobs[i2].getResult(result);
            ++i2;
        }
        return result;
    }

    public static Table newTables(Sequence src, Expression gexp, Expression[] exps, DataStruct ds, String opt, Context ctx) {
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len <= SINGLE_PROSS_COUNT || parallelNum < 2) {
            return src.newTables(gexp, exps, ds, opt, ctx);
        }
        int threadCount = (len - 1) / SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        NewsJob[] jobs = new NewsJob[threadCount];
        int expCount = exps.length;
        int start = 1;
        int i = 0;
        while (i < threadCount) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression tmpGExp = gexp.newExpression(tmpCtx);
            Expression[] tmpExps = new Expression[expCount];
            int k = 0;
            while (k < expCount) {
                tmpExps[k] = exps[k].newExpression(tmpCtx);
                ++k;
            }
            jobs[i] = new NewsJob(src, start, end, tmpGExp, tmpExps, ds, opt, tmpCtx);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        int totalLen = 0;
        int i2 = 0;
        while (i2 < threadCount) {
            jobs[i2].join();
            Table curResult = jobs[i2].getResult();
            totalLen += curResult.length();
            ++i2;
        }
        Table result = new Table(ds, totalLen);
        int i3 = 0;
        while (i3 < threadCount) {
            Table curResult = jobs[i3].getResult();
            result.getMems().addAll(curResult.getMems());
            ++i3;
        }
        return result;
    }

    public static Table derive(Sequence src, String[] names, Expression[] exps, String opt, Context ctx) {
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len <= SINGLE_PROSS_COUNT || parallelNum < 2) {
            opt = opt.replace('m', ' ');
            return src.derive(names, exps, opt, ctx);
        }
        DataStruct srcDs = src.dataStruct();
        if (srcDs == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        int colCount = names.length;
        int i = 0;
        while (i < colCount) {
            if (names[i] == null || names[i].length() == 0) {
                if (exps[i] == null) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException("new" + mm.getMessage("function.invalidParam"));
                }
                names[i] = exps[i].getIdentifierName();
            } else if (exps[i] == null) {
                exps[i] = Expression.NULL;
            }
            ++i;
        }
        String[] srcNames = srcDs.getFieldNames();
        int srcColCount = srcNames.length;
        String[] totalNames = new String[srcColCount + colCount];
        System.arraycopy(srcNames, 0, totalNames, 0, srcColCount);
        System.arraycopy(names, 0, totalNames, srcColCount, colCount);
        DataStruct newDs = srcDs.create(totalNames);
        int threadCount = (len - 1) / SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        DeriveJob[] jobs = new DeriveJob[threadCount];
        int expCount = exps.length;
        int start = 1;
        int i2 = 0;
        while (i2 < threadCount) {
            int end = i2 + 1 == threadCount ? len + 1 : start + singleCount;
            Context tmpCtx = ctx.newComputeContext();
            Expression[] tmpExps = new Expression[expCount];
            int k = 0;
            while (k < expCount) {
                tmpExps[k] = exps[k].newExpression(tmpCtx);
                ++k;
            }
            jobs[i2] = new DeriveJob(src, start, end, newDs, tmpExps, opt, tmpCtx);
            pool.submit(jobs[i2]);
            start = end;
            ++i2;
        }
        Table result = new Table(newDs, len);
        int i3 = 0;
        while (i3 < threadCount) {
            jobs[i3].join();
            jobs[i3].getResult(result);
            ++i3;
        }
        return result;
    }

    public static void sort(int[] vals, int fromIndex, int toIndex) {
        MultithreadUtil.rangeCheck(vals.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        int[] aux = new int[n];
        System.arraycopy(vals, fromIndex, aux, 0, n);
        MultithreadUtil.mergeSort(aux, vals, fromIndex, toIndex, -fromIndex, Env.getParallelNum());
    }

    static void mergeSort(int[] src, int[] dest, int low, int high, int off, int threadCount) {
        int length = high - low;
        if (length <= SINGLE_PROSS_COUNT || threadCount < 2) {
            MultithreadUtil.mergeSort(src, dest, low, high, off);
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        IntSortJob job1 = new IntSortJob(dest, src, low, mid, -off, threadCount / 2);
        IntSortJob job2 = new IntSortJob(dest, src, mid, high, -off, threadCount / 2);
        new JobThread(job2).start();
        job1.run();
        job2.join();
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void mergeSort(int[] src, int[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 9) {
            int i;
            int j = i = low + 1;
            while (i < high) {
                int tmp = dest[i];
                while (j > low && dest[j - 1] > tmp) {
                    dest[j] = dest[j - 1];
                    --j;
                }
                dest[j] = tmp;
                j = ++i;
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        MultithreadUtil.mergeSort(dest, src, low, mid, -off);
        MultithreadUtil.mergeSort(dest, src, mid, high, -off);
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
            ++i;
        }
    }

    public static void sort(long[] vals, int fromIndex, int toIndex) {
        MultithreadUtil.rangeCheck(vals.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        long[] aux = new long[n];
        System.arraycopy(vals, fromIndex, aux, 0, n);
        MultithreadUtil.mergeSort(aux, vals, fromIndex, toIndex, -fromIndex, Env.getParallelNum());
    }

    static void mergeSort(long[] src, long[] dest, int low, int high, int off, int threadCount) {
        int length = high - low;
        if (length <= SINGLE_PROSS_COUNT || threadCount < 2) {
            MultithreadUtil.mergeSort(src, dest, low, high, off);
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        LongSortJob job1 = new LongSortJob(dest, src, low, mid, -off, threadCount / 2);
        LongSortJob job2 = new LongSortJob(dest, src, mid, high, -off, threadCount / 2);
        new JobThread(job2).start();
        job1.run();
        job2.join();
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void mergeSort(long[] src, long[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 9) {
            int i;
            int j = i = low + 1;
            while (i < high) {
                long tmp = dest[i];
                while (j > low && dest[j - 1] > tmp) {
                    dest[j] = dest[j - 1];
                    --j;
                }
                dest[j] = tmp;
                j = ++i;
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        MultithreadUtil.mergeSort(dest, src, low, mid, -off);
        MultithreadUtil.mergeSort(dest, src, mid, high, -off);
        if (src[mid - 1] <= src[mid]) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && src[p] <= src[q] ? src[p++] : src[q++];
            ++i;
        }
    }

    public static void sort(double[] vals, int fromIndex, int toIndex) {
        MultithreadUtil.rangeCheck(vals.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        double[] aux = new double[n];
        System.arraycopy(vals, fromIndex, aux, 0, n);
        MultithreadUtil.mergeSort(aux, vals, fromIndex, toIndex, -fromIndex, Env.getParallelNum());
    }

    static void mergeSort(double[] src, double[] dest, int low, int high, int off, int threadCount) {
        int length = high - low;
        if (length <= SINGLE_PROSS_COUNT || threadCount < 2) {
            MultithreadUtil.mergeSort(src, dest, low, high, off);
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        DoubleSortJob job1 = new DoubleSortJob(dest, src, low, mid, -off, threadCount / 2);
        DoubleSortJob job2 = new DoubleSortJob(dest, src, mid, high, -off, threadCount / 2);
        new JobThread(job2).start();
        job1.run();
        job2.join();
        if (Double.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && Double.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void mergeSort(double[] src, double[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 9) {
            int i;
            int j = i = low + 1;
            while (i < high) {
                double tmp = dest[i];
                while (j > low && Double.compare(dest[j - 1], tmp) > 0) {
                    dest[j] = dest[j - 1];
                    --j;
                }
                dest[j] = tmp;
                j = ++i;
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        MultithreadUtil.mergeSort(dest, src, low, mid, -off);
        MultithreadUtil.mergeSort(dest, src, mid, high, -off);
        if (Double.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && Double.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    public static void sort(String[] vals, int fromIndex, int toIndex) {
        MultithreadUtil.rangeCheck(vals.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        String[] aux = new String[n];
        System.arraycopy(vals, fromIndex, aux, 0, n);
        MultithreadUtil.mergeSort(aux, vals, fromIndex, toIndex, -fromIndex, Env.getParallelNum());
    }

    static void mergeSort(String[] src, String[] dest, int low, int high, int off, int threadCount) {
        int length = high - low;
        if (length <= SINGLE_PROSS_COUNT || threadCount < 2) {
            MultithreadUtil.mergeSort(src, dest, low, high, off);
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        StringSortJob job1 = new StringSortJob(dest, src, low, mid, -off, threadCount / 2);
        StringSortJob job2 = new StringSortJob(dest, src, mid, high, -off, threadCount / 2);
        new JobThread(job2).start();
        job1.run();
        job2.join();
        if (StringArray.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && StringArray.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void mergeSort(String[] src, String[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 9) {
            int i;
            int j = i = low + 1;
            while (i < high) {
                String tmp = dest[i];
                while (j > low && StringArray.compare(dest[j - 1], tmp) > 0) {
                    dest[j] = dest[j - 1];
                    --j;
                }
                dest[j] = tmp;
                j = ++i;
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        MultithreadUtil.mergeSort(dest, src, low, mid, -off);
        MultithreadUtil.mergeSort(dest, src, mid, high, -off);
        if (StringArray.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && StringArray.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    public static void sort(Date[] vals, int fromIndex, int toIndex) {
        MultithreadUtil.rangeCheck(vals.length, fromIndex, toIndex);
        int n = toIndex - fromIndex;
        Date[] aux = new Date[n];
        System.arraycopy(vals, fromIndex, aux, 0, n);
        MultithreadUtil.mergeSort(aux, vals, fromIndex, toIndex, -fromIndex, Env.getParallelNum());
    }

    static void mergeSort(Date[] src, Date[] dest, int low, int high, int off, int threadCount) {
        int length = high - low;
        if (length <= SINGLE_PROSS_COUNT || threadCount < 2) {
            MultithreadUtil.mergeSort(src, dest, low, high, off);
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        DateSortJob job1 = new DateSortJob(dest, src, low, mid, -off, threadCount / 2);
        DateSortJob job2 = new DateSortJob(dest, src, mid, high, -off, threadCount / 2);
        new JobThread(job2).start();
        job1.run();
        job2.join();
        if (DateArray.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && DateArray.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    private static void mergeSort(Date[] src, Date[] dest, int low, int high, int off) {
        int length = high - low;
        if (length < 9) {
            int i;
            int j = i = low + 1;
            while (i < high) {
                Date tmp = dest[i];
                while (j > low && DateArray.compare(dest[j - 1], tmp) > 0) {
                    dest[j] = dest[j - 1];
                    --j;
                }
                dest[j] = tmp;
                j = ++i;
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >> 1;
        MultithreadUtil.mergeSort(dest, src, low, mid, -off);
        MultithreadUtil.mergeSort(dest, src, mid, high, -off);
        if (DateArray.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int i = destLow;
        int p = low;
        int q = mid;
        while (i < destHigh) {
            dest[i] = q >= high || p < mid && DateArray.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
            ++i;
        }
    }

    public static Sequence hashId(Sequence src, String opt) {
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len <= SINGLE_PROSS_COUNT || parallelNum < 2) {
            opt = opt.replace('m', ' ');
            return CursorUtil.hashId(src, opt);
        }
        int threadCount = (len - 1) / SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        HashIdJob[] jobs = new HashIdJob[threadCount];
        int start = 1;
        int i = 0;
        while (i < threadCount) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            jobs[i] = new HashIdJob(src, start, end, opt);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        Sequence result = new Sequence(len);
        int i2 = 0;
        while (i2 < threadCount) {
            jobs[i2].join();
            jobs[i2].getResult(result);
            ++i2;
        }
        opt = opt.replace('m', ' ');
        return CursorUtil.hashId(result, opt);
    }

    public static Sequence bits(Sequence src, String opt) {
        opt = opt.replace('m', ' ');
        int len = src.length();
        int parallelNum = MultithreadUtil.getParallelNum();
        if (len <= SINGLE_PROSS_COUNT || parallelNum < 2) {
            return src.bits(opt);
        }
        int threadCount = (len - 1) / SINGLE_PROSS_COUNT + 1;
        if (threadCount > parallelNum) {
            threadCount = parallelNum;
        }
        ThreadPool pool = ThreadPool.instance();
        int singleCount = len / threadCount;
        singleCount -= singleCount % 64;
        BitsJob[] jobs = new BitsJob[threadCount];
        int start = 1;
        int i = 0;
        while (i < threadCount) {
            int end = i + 1 == threadCount ? len + 1 : start + singleCount;
            jobs[i] = new BitsJob(src, start, end, opt);
            pool.submit(jobs[i]);
            start = end;
            ++i;
        }
        jobs[0].join();
        Sequence result = jobs[0].getResult();
        int i2 = 1;
        while (i2 < threadCount) {
            jobs[i2].join();
            result.append(jobs[i2].getResult());
            ++i2;
        }
        return result;
    }
}

