/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.thread;

import com.scudata.array.IArray;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.thread.Job;
import com.scudata.util.Variant;

class SelectJob
extends Job {
    private Sequence src;
    private int start;
    private int end;
    private Expression exp;
    private Expression[] fltExps;
    private Object[] vals;
    private Context ctx;
    private Sequence result;

    public SelectJob(Sequence src, int start, int end, Expression exp, Context ctx) {
        this.src = src;
        this.start = start;
        this.end = end;
        this.exp = exp;
        this.ctx = ctx;
    }

    public SelectJob(Sequence src, int start, int end, Expression[] fltExps, Object[] vals, Context ctx) {
        this.src = src;
        this.start = start;
        this.end = end;
        this.fltExps = fltExps;
        this.vals = vals;
        this.ctx = ctx;
    }

    @Override
    public void run() {
        if (this.fltExps == null) {
            this.run1();
        } else {
            this.run2();
        }
    }

    private void run1() {
        Sequence result;
        Sequence src = this.src;
        int end = this.end;
        Expression exp = this.exp;
        Context ctx = this.ctx;
        this.result = result = new Sequence();
        IArray mems = src.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(src);
        stack.push(current);
        try {
            int i = this.start;
            while (i < end) {
                current.setCurrent(i);
                Object obj = exp.calculate(ctx);
                if (Variant.isTrue(obj)) {
                    result.add(mems.get(i));
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
    }

    private void run2() {
        Sequence result;
        Sequence src = this.src;
        int end = this.end;
        Expression[] fltExps = this.fltExps;
        Object[] vals = this.vals;
        Context ctx = this.ctx;
        int colCount = fltExps.length;
        this.result = result = new Sequence();
        IArray mems = src.getMems();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(src);
        stack.push(current);
        try {
            int i = this.start;
            while (i < end) {
                block6: {
                    current.setCurrent(i);
                    int c = 0;
                    while (c < colCount) {
                        Object flt = fltExps[c].calculate(ctx);
                        if (Variant.isEquals(flt, vals[c])) {
                            ++c;
                            continue;
                        }
                        break block6;
                    }
                    result.add(mems.get(i));
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
    }

    public void getResult(Sequence seq) {
        seq.addAll(this.result);
    }
}

