/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.cellset.datamodel.CellSet;
import com.scudata.cellset.datamodel.PgmCellSet;
import com.scudata.cellset.datamodel.PgmNormalCell;
import com.scudata.common.ByteArrayInputRecord;
import com.scudata.common.ByteArrayOutputRecord;
import com.scudata.common.ByteMap;
import com.scudata.common.DES;
import com.scudata.common.Escape;
import com.scudata.common.IOUtils;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.Context;
import com.scudata.dm.KeyWord;
import com.scudata.dm.LineImporter;
import com.scudata.dm.Param;
import com.scudata.dm.ParamList;
import com.scudata.dm.Sequence;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.util.Variant;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class CellSetUtil {
    private static final byte Type_PgmCellSet = 1;
    private static final String KEY = "rqqrrqqr";
    private static final byte ENCRYPTED = 1;

    public static byte[] encrypt(byte[] bytes) throws Exception {
        DES des = new DES(KEY);
        return des.encrypt(bytes);
    }

    public static byte[] decrypt(byte[] bytes) throws Exception {
        DES des = new DES(KEY);
        return des.decrypt(bytes);
    }

    public static void writePgmCellSet(String fileName, PgmCellSet cs, String fnEncrypt, String fnDecrypt) throws Exception {
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(fileName));
            CellSetUtil.writePgmCellSet(bos, cs, fnEncrypt, fnDecrypt);
        }
    }

    public static void writePgmCellSet(OutputStream out, PgmCellSet cs, String fnEncrypt, String fnDecrypt) throws Exception {
        int dotIndex = fnEncrypt.lastIndexOf(46);
        if (dotIndex == -1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(String.valueOf(fnEncrypt) + mm.getMessage("invoke.methodNotExist"));
        }
        String className = fnEncrypt.substring(0, dotIndex);
        String methodName = fnEncrypt.substring(dotIndex + 1);
        Class<?> classObj = Class.forName(className);
        Method method = classObj.getDeclaredMethod(methodName, byte[].class);
        out.write(82);
        out.write(81);
        out.write(81);
        out.write(82);
        out.write(1);
        out.write(5);
        ByteArrayOutputRecord bo = new ByteArrayOutputRecord();
        String psw = cs.getPasswordHash();
        bo.writeString(psw);
        int privilege = cs.getNullPasswordPrivilege();
        bo.writeInt(privilege);
        bo.writeString(fnDecrypt);
        byte[] pswBytes = bo.toByteArray();
        pswBytes = CellSetUtil.encrypt(pswBytes);
        IOUtils.writeInt(out, pswBytes.length);
        out.write(pswBytes);
        ByteMap map = cs.getCustomPropMap();
        if (map == null || map.size() == 0) {
            IOUtils.writeInt(out, 0);
        } else {
            byte[] mapBytes = map.serialize();
            IOUtils.writeInt(out, mapBytes.length);
            out.write(mapBytes);
        }
        byte[] csBytes = cs.serialize();
        csBytes = (byte[])method.invoke(null, new Object[]{csBytes});
        out.write(1);
        IOUtils.writeInt(out, csBytes.length);
        out.write(csBytes);
        out.write(82);
        out.write(81);
        out.write(81);
        out.write(82);
        out.flush();
    }

    public static void writePgmCellSet(OutputStream out, PgmCellSet cs) throws Exception {
        out.write(82);
        out.write(81);
        out.write(81);
        out.write(82);
        out.write(1);
        out.write(4);
        ByteArrayOutputRecord bo = new ByteArrayOutputRecord();
        String psw = cs.getPasswordHash();
        bo.writeString(psw);
        int privilege = cs.getNullPasswordPrivilege();
        bo.writeInt(privilege);
        byte[] pswBytes = bo.toByteArray();
        pswBytes = CellSetUtil.encrypt(pswBytes);
        IOUtils.writeInt(out, pswBytes.length);
        out.write(pswBytes);
        ByteMap map = cs.getCustomPropMap();
        if (map == null || map.size() == 0) {
            IOUtils.writeInt(out, 0);
        } else {
            byte[] mapBytes = map.serialize();
            IOUtils.writeInt(out, mapBytes.length);
            out.write(mapBytes);
        }
        byte[] csBytes = cs.serialize();
        if (psw == null || psw.length() == 0) {
            out.write(0);
        } else {
            out.write(1);
            csBytes = CellSetUtil.encrypt(csBytes);
        }
        IOUtils.writeInt(out, csBytes.length);
        out.write(csBytes);
        out.write(82);
        out.write(81);
        out.write(81);
        out.write(82);
        out.flush();
    }

    public static boolean isEncrypted(String fileName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            boolean bl = CellSetUtil.isEncrypted(fis);
            return bl;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isEncrypted(InputStream is) {
        block7: {
            block6: {
                block5: {
                    try {
                        int c1 = is.read();
                        int c2 = is.read();
                        int c3 = is.read();
                        int c4 = is.read();
                        if (c1 == 82 && c2 == 81 && c3 == 81 && c4 == 82) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                int type = is.read();
                if (type == 1) break block6;
                return false;
            }
            int ver = is.read();
            if (ver >= 3) break block7;
            return false;
        }
        int pswLen = IOUtils.readInt(is);
        byte[] pswBytes = new byte[pswLen];
        IOUtils.readFully(is, pswBytes);
        pswBytes = CellSetUtil.decrypt(pswBytes);
        ByteArrayInputRecord bi = new ByteArrayInputRecord(pswBytes);
        String psw = bi.readString();
        return psw != null && psw.length() > 0;
    }

    public static boolean isUserEncrypted(InputStream is) {
        block7: {
            block6: {
                block5: {
                    try {
                        int c1 = is.read();
                        int c2 = is.read();
                        int c3 = is.read();
                        int c4 = is.read();
                        if (c1 == 82 && c2 == 81 && c3 == 81 && c4 == 82) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                int type = is.read();
                if (type == 1) break block6;
                return false;
            }
            int ver = is.read();
            if (ver >= 5) break block7;
            return false;
        }
        int pswLen = IOUtils.readInt(is);
        byte[] pswBytes = new byte[pswLen];
        IOUtils.readFully(is, pswBytes);
        pswBytes = CellSetUtil.decrypt(pswBytes);
        ByteArrayInputRecord bi = new ByteArrayInputRecord(pswBytes);
        bi.readString();
        bi.readInt();
        String fnDecrypt = bi.readString();
        return fnDecrypt != null && fnDecrypt.length() > 0;
    }

    public static ByteMap readCsCustomPropMap(String fileName) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            ByteMap byteMap = CellSetUtil.readCsCustomPropMap(fis);
            return byteMap;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static ByteMap readCsCustomPropMap(InputStream is) {
        int mapLen;
        int pswLen;
        block5: {
            try {
                int c1 = is.read();
                int c2 = is.read();
                int c3 = is.read();
                int c4 = is.read();
                if (c1 == 82 && c2 == 81 && c3 == 81 && c4 == 82) break block5;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        int type = is.read();
        int ver = is.read();
        if ((ver > 1 || type != 1) && (pswLen = IOUtils.readInt(is)) > 0) {
            is.skip(pswLen);
        }
        if ((mapLen = IOUtils.readInt(is)) > 0) {
            byte[] mapBytes = new byte[mapLen];
            IOUtils.readFully(is, mapBytes);
            ByteMap map = new ByteMap();
            map.fillRecord(mapBytes);
            return map;
        }
        return null;
    }

    public static void writePgmCellSet(String fileName, PgmCellSet cs) throws Exception {
        try (FilterOutputStream bos = null;){
            bos = new BufferedOutputStream(new FileOutputStream(fileName));
            CellSetUtil.writePgmCellSet(bos, cs);
        }
    }

    public static PgmCellSet readPgmCellSet(String fileName) throws Exception {
        return CellSetUtil.readPgmCellSet(fileName, null);
    }

    public static PgmCellSet readPgmCellSet(String fileName, String psw) throws Exception {
        PgmCellSet pcs;
        try (BufferedInputStream bis = null;){
            bis = new BufferedInputStream(new FileInputStream(fileName));
            pcs = CellSetUtil.readPgmCellSet(bis, psw);
        }
        File file = new File(fileName);
        pcs.setName(file.getPath());
        return pcs;
    }

    public static PgmCellSet readPgmCellSet(InputStream is) throws Exception {
        return CellSetUtil.readPgmCellSet(is, null);
    }

    public static PgmCellSet readPgmCellSet(InputStream is, String psw) throws Exception {
        int mapLen;
        if (is.read() != 82 || is.read() != 81 || is.read() != 81 || is.read() != 82) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        int type = is.read();
        if (type != 1) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("license.fileFormatError"));
        }
        PgmCellSet cs = new PgmCellSet();
        int ver = is.read();
        if (ver == 1) {
            int mapLen2 = IOUtils.readInt(is);
            if (mapLen2 > 0) {
                is.skip(mapLen2);
            }
            int csLen = IOUtils.readInt(is);
            byte[] csBytes = new byte[csLen];
            IOUtils.readFully(is, csBytes);
            is.read();
            is.read();
            is.read();
            is.read();
            cs.fillRecord(csBytes);
            CellSetUtil.changeOldVersionParam(cs);
            return cs;
        }
        int pswLen = IOUtils.readInt(is);
        byte[] pswBytes = new byte[pswLen];
        IOUtils.readFully(is, pswBytes);
        String fnDecrypt = null;
        if (ver > 2) {
            pswBytes = CellSetUtil.decrypt(pswBytes);
            ByteArrayInputRecord bi = new ByteArrayInputRecord(pswBytes);
            bi.readString();
            bi.readInt();
            if (ver > 4) {
                fnDecrypt = bi.readString();
            }
        }
        if ((mapLen = IOUtils.readInt(is)) > 0) {
            is.skip(mapLen);
        }
        int isEncrypted = is.read() & 1;
        int csLen = IOUtils.readInt(is);
        byte[] csBytes = new byte[csLen];
        IOUtils.readFully(is, csBytes);
        is.read();
        is.read();
        is.read();
        is.read();
        if (fnDecrypt != null) {
            int dotIndex = fnDecrypt.lastIndexOf(46);
            if (dotIndex == -1) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(String.valueOf(fnDecrypt) + mm.getMessage("invoke.methodNotExist"));
            }
            String className = fnDecrypt.substring(0, dotIndex);
            String methodName = fnDecrypt.substring(dotIndex + 1);
            Class<?> classObj = Class.forName(className);
            Method method = classObj.getDeclaredMethod(methodName, byte[].class);
            csBytes = (byte[])method.invoke(null, new Object[]{csBytes});
        } else if (isEncrypted == 1) {
            csBytes = CellSetUtil.decrypt(csBytes);
        }
        cs.fillRecord(csBytes);
        cs.setCurrentPassword(psw);
        if (ver < 4) {
            CellSetUtil.changeOldVersionParam(cs);
        }
        return cs;
    }

    private static void changeOldVersionParam(PgmCellSet pcs) {
        ParamList paramList = pcs.getParamList();
        if (paramList == null) {
            return;
        }
        int i = 0;
        int size = paramList.count();
        while (i < size) {
            Param param = paramList.get(i);
            Object value = param.getValue();
            if (value instanceof String) {
                String old = (String)value;
                value = Variant.parse(old);
                param.setValue(value);
                if (value instanceof String) {
                    int match = Sentence.scanQuotation(old, 0);
                    if (match == old.length() - 1) {
                        param.setEditValue(String.valueOf('\'') + (String)value);
                    } else if (old.charAt(0) == '\'') {
                        param.setEditValue(String.valueOf('\'') + old);
                    } else {
                        param.setEditValue(old);
                    }
                } else {
                    param.setEditValue(old);
                }
            }
            ++i;
        }
    }

    public static void putArgStringValue(CellSet cellSet, String[] args) {
        if (args == null) {
            CellSetUtil.putArgValue(cellSet, null);
        } else {
            Object[] vals = new Object[args.length];
            int i = 0;
            while (i < args.length) {
                vals[i] = PgmNormalCell.parseConstValue(args[i]);
                ++i;
            }
            CellSetUtil.putArgValue(cellSet, vals);
        }
    }

    public static void putArgValue(CellSet cellSet, Object[] args) {
        ParamList params = cellSet.getParamList();
        if (params == null || params.count() == 0) {
            return;
        }
        Context context = cellSet.getContext();
        int c = 0;
        int i = 0;
        while (i < params.count()) {
            Param p = params.get(i);
            if (p.getKind() == 0) {
                String paraName = p.getName();
                if (args != null && c < args.length) {
                    context.setParamValue(paraName, args[c], (byte)0);
                    ++c;
                } else {
                    context.setParamValue(paraName, p.getValue(), (byte)0);
                }
            }
            ++i;
        }
    }

    public static Object execute1(String src, Sequence args, Context ctx) {
        if (args != null && args.length() > 0) {
            int i = 1;
            while (i <= args.length()) {
                ctx.setParamValue("arg" + i, args.get(i));
                ++i;
            }
        }
        Expression exp = new Expression(ctx, src);
        return exp.calculate(ctx);
    }

    public static Object execute(String src, Sequence args, Context ctx) {
        PgmCellSet pcs = CellSetUtil.toPgmCellSet(src);
        if (args != null && args.length() > 0) {
            int i = 1;
            while (i <= args.length()) {
                ctx.setParamValue("arg" + i, args.get(i));
                ++i;
            }
        }
        pcs.setContext(ctx);
        pcs.calculateResult();
        if (pcs.hasNextResult()) {
            return pcs.nextResult();
        }
        int colCount = pcs.getColCount();
        int r = pcs.getRowCount();
        while (r > 0) {
            int c = colCount;
            while (c > 0) {
                PgmNormalCell cell = pcs.getPgmNormalCell(r, c);
                if (cell.isCalculableCell() || cell.isCalculableBlock()) {
                    return cell.getValue();
                }
                --c;
            }
            --r;
        }
        return null;
    }

    public static PgmCellSet toPgmCellSet(String[][] expStrs) {
        if (expStrs == null || expStrs.length == 0) {
            return null;
        }
        int rowCount = expStrs.length;
        int colCount = 0;
        int r = 0;
        while (r < rowCount) {
            if (expStrs[r] != null && expStrs[r].length > colCount) {
                colCount = expStrs[r].length;
            }
            ++r;
        }
        if (colCount == 0) {
            return null;
        }
        PgmCellSet pcs = new PgmCellSet(rowCount, colCount);
        int r2 = 1;
        while (r2 <= rowCount) {
            String[] row = expStrs[r2 - 1];
            int count = row != null ? row.length : 0;
            int c = 1;
            while (c <= count) {
                PgmNormalCell cell = pcs.getPgmNormalCell(r2, c);
                cell.setExpString(row[c - 1]);
                ++c;
            }
            ++r2;
        }
        return pcs;
    }

    public static PgmCellSet toPgmCellSet(String src) {
        if (src == null || src.length() == 0) {
            return null;
        }
        char[] buffer = src.toCharArray();
        int len = buffer.length;
        int index = 0;
        ParamList paramList = new ParamList();
        while (index < len && buffer[index] == '#') {
            String paramName;
            String strParam = null;
            int i = ++index;
            while (i < len) {
                if (buffer[i] == '\n') {
                    strParam = buffer[i - 1] == '\r' ? new String(buffer, index, i - index - 1) : new String(buffer, index, i - index);
                    index = i + 1;
                    break;
                }
                ++i;
            }
            if (strParam == null) {
                strParam = new String(buffer, index, len - index);
                index = len;
            }
            int s = strParam.indexOf(61);
            Object paramValue = null;
            if (s != -1) {
                paramName = strParam.substring(0, s);
                paramValue = Variant.parse(strParam.substring(s + 1), false);
            } else {
                paramName = strParam;
            }
            paramList.add(paramName, (byte)0, paramValue);
        }
        int colSeparator = 9;
        ArrayList<String> line = new ArrayList<String>();
        int rowCount = 10;
        int colCount = 1;
        PgmCellSet pcs = new PgmCellSet(rowCount, colCount);
        int curRow = 1;
        if (paramList.count() > 0) {
            pcs.setParamList(paramList);
        }
        while (index != -1) {
            index = LineImporter.readLine(buffer, index, '\t', line);
            int curColCount = line.size();
            if (curColCount > colCount) {
                pcs.addCol(curColCount - colCount);
                colCount = curColCount;
            }
            if (curRow > rowCount) {
                rowCount += 10;
                pcs.addRow(10);
            }
            int f = 0;
            while (f < curColCount) {
                String exp = line.get(f);
                if (exp != null && exp.length() > 0) {
                    PgmNormalCell cell = pcs.getPgmNormalCell(curRow, f + 1);
                    exp = Escape.remove(exp);
                    cell.setExpString(exp);
                }
                ++f;
            }
            ++curRow;
            line.clear();
        }
        pcs.removeRow(curRow, rowCount - curRow + 1);
        CellSetUtil.changeAliasNameToCell(pcs);
        return pcs;
    }

    private static void changeAliasNameToCell(PgmCellSet pcs) {
        int rowCount = pcs.getRowCount();
        int colCount = pcs.getColCount();
        int r = 1;
        while (r <= rowCount) {
            int c = 1;
            while (c <= colCount) {
                String aliasName;
                int end;
                PgmNormalCell cell = pcs.getPgmNormalCell(r, c);
                String expStr = cell.getExpString();
                if (expStr != null && expStr.length() > 1 && expStr.charAt(0) == '@' && (end = expStr.indexOf(58)) != -1 && (aliasName = expStr.substring(1, end).trim()).length() > 0) {
                    if (end + 1 < expStr.length()) {
                        expStr = expStr.substring(end + 1);
                        cell.setExpString(expStr);
                    } else {
                        cell.setExpString(null);
                    }
                    CellSetUtil.changeAliasNameToCell(pcs, aliasName, cell.getCellId());
                }
                ++c;
            }
            ++r;
        }
    }

    private static void changeAliasNameToCell(PgmCellSet pcs, String aliasName, String cellId) {
        int rowCount = pcs.getRowCount();
        int colCount = pcs.getColCount();
        int aliasNameLen = aliasName.length();
        int r = 1;
        while (r <= rowCount) {
            int c = 1;
            while (c <= colCount) {
                PgmNormalCell cell = pcs.getPgmNormalCell(r, c);
                String expStr = cell.getExpString();
                if (expStr != null && expStr.length() > aliasNameLen) {
                    expStr = CellSetUtil.changeAliasNameToCell(expStr, aliasName, cellId);
                    cell.setExpString(expStr);
                }
                ++c;
            }
            ++r;
        }
    }

    private static String changeAliasNameToCell(String expStr, String aliasName, String cellId) {
        int aliasLen = aliasName.length();
        if (expStr == null || expStr.length() < aliasLen) {
            return expStr;
        }
        StringBuffer sb = null;
        int len = expStr.length();
        int i = 0;
        while (i < len) {
            char c = expStr.charAt(i);
            if (c == '\"' || c == '\'') {
                int match = Sentence.scanQuotation(expStr, i);
                if (match == -1) {
                    if (sb == null) break;
                    sb.append(expStr.substring(i));
                    break;
                }
                if (sb != null) {
                    sb.append(expStr.substring(i, match + 1));
                }
                i = match + 1;
                continue;
            }
            if (KeyWord.isSymbol(c) || c == '#') {
                if (sb != null) {
                    sb.append(c);
                }
                ++i;
                continue;
            }
            int end = KeyWord.scanId(expStr, i + 1);
            if (end - i == aliasLen && aliasName.equals(expStr.substring(i, end))) {
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(expStr.substring(0, i));
                }
                sb.append(cellId);
            } else if (sb != null) {
                sb.append(expStr.substring(i, end));
            }
            i = end;
        }
        if (sb == null) {
            return expStr;
        }
        return sb.toString();
    }

    public static String toString(PgmCellSet cs) {
        StringBuffer sb = new StringBuffer(1024);
        ParamList paramList = cs.getParamList();
        int paramCount = paramList == null ? 0 : paramList.count();
        boolean isFirstLine = true;
        int i = 0;
        while (i < paramCount) {
            Param param = paramList.get(i);
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                sb.append('\n');
            }
            sb.append('#');
            sb.append(param.getName());
            sb.append('=');
            sb.append(Variant.toString(param.getValue()));
            ++i;
        }
        int rowCount = cs.getRowCount();
        int colCount = cs.getColCount();
        int r = 1;
        while (r <= rowCount) {
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                sb.append('\n');
            }
            int c = 1;
            while (c <= colCount) {
                String exp;
                if (c > 1) {
                    sb.append('\t');
                }
                if ((exp = cs.getPgmNormalCell(r, c).getExpString()) != null) {
                    exp = Escape.add(exp);
                    sb.append(exp);
                }
                ++c;
            }
            ++r;
        }
        return sb.toString();
    }
}

