/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.array.IArray;
import com.scudata.common.DBConfig;
import com.scudata.common.DBInfo;
import com.scudata.common.DBSession;
import com.scudata.common.DBTypes;
import com.scudata.common.ISessionFactory;
import com.scudata.common.Logger;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.common.SQLParser;
import com.scudata.common.SQLTool;
import com.scudata.common.Sentence;
import com.scudata.common.Types;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.Current;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.ListBase1;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.dm.cursor.ICursor;
import com.scudata.expression.Expression;
import com.scudata.resources.DataSetMessage;
import com.scudata.util.HashUtil;
import com.scudata.util.TranOracle;
import com.scudata.util.TranSybase;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DatabaseUtil {
    public static int TYPE_ORACLE_TIMESTAMP = 1;
    public static int TYPE_ORACLE_DATE = 2;
    public static int TYPE_SYBASE_TIMESTAMP = 3;
    public static byte PROC_MODE_IN = 1;
    public static byte PROC_MODE_OUT = (byte)2;
    public static byte PROC_MODE_INOUT = (byte)3;
    private static Class<?> oracleTIMESTAMP = null;
    private static Class<?> oracleDATE = null;
    private static Class<?> sybaseTIMESTAMP = null;
    private static final byte Col_AutoIncrement = 1;
    private static byte Col_NormalKey = (byte)2;

    private static Table retrieve(String sql, Object[] params, byte[] types, DBSession dbs, String opt, int recordLimit) {
        ResultSet rs = null;
        Statement st = null;
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        boolean isSolid = opt != null && opt.indexOf("s") > -1;
        try {
            boolean cleanFieldName;
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            boolean bb = true;
            if (toCharset != null) {
                boolean bl = bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                int pos = 0;
                int paramIndex = 0;
                while (paramIndex < paramCount) {
                    pos = Sentence.indexOf(sql, "?", pos + 1, 18);
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] != null) {
                        if (args[paramIndex] instanceof Sequence && tranContent) {
                            Sequence l = (Sequence)args[paramIndex];
                            int i = 1;
                            int size = l.length();
                            while (i <= size) {
                                Object o = l.get(i);
                                if (o instanceof String && tranSQL) {
                                    o = new String(((String)o).getBytes(), dbCharset);
                                    l.set(i, o);
                                }
                                ++i;
                            }
                        } else if (args[paramIndex] instanceof String && tranSQL) {
                            args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                        }
                        if (args[paramIndex] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[paramIndex]).toArray();
                            int objCount = objs.length;
                            StringBuffer sb = new StringBuffer(2 * objCount);
                            int iObj = 0;
                            while (iObj < objCount) {
                                sb.append("?,");
                                ++iObj;
                            }
                            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                                sb.deleteCharAt(sb.length() - 1);
                            }
                            if (sb.length() > 1) {
                                sql = String.valueOf(sql.substring(0, pos)) + sb.toString() + sql.substring(pos + 1);
                            }
                            pos += sb.length();
                        }
                    }
                    ++paramIndex;
                }
            }
            if (isSolid && args != null && args.length > 0) {
                isSolid = false;
            }
            try {
                if (isSolid) {
                    st = con.createStatement();
                } else {
                    pst = con.prepareStatement(sql);
                }
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name2, sql)) + " : " + e.getMessage(), e);
            }
            if (args != null && args.length > 0) {
                int pos = 0;
                int iArg = 0;
                while (iArg < args.length) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        if (args[iArg] != null && args[iArg] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[iArg]).toArray();
                            int iObj = 0;
                            while (iObj < objs.length) {
                                SQLTool.setObject(dbType, (PreparedStatement)pst, pos, objs[iObj], type);
                                ++pos;
                                ++iObj;
                            }
                            --pos;
                        } else {
                            SQLTool.setObject(dbType, (PreparedStatement)pst, pos, args[iArg], type);
                        }
                    }
                    catch (Exception e) {
                        String name3 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name3 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", name3, Integer.toString(iArg + 1)));
                    }
                    ++iArg;
                }
            }
            try {
                rs = isSolid ? st.executeQuery(sql) : pst.executeQuery();
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name4 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name4 = info.getName();
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name4, sql)) + " : " + e.getMessage(), e);
            }
            boolean addTable = false;
            if (opt != null && opt.indexOf("f") > -1) {
                addTable = true;
            }
            Table table = DatabaseUtil.populate(rs, dbCharset, tranContent, toCharset, dbType, addTable, null, false, recordLimit, opt);
            boolean bl = cleanFieldName = opt != null && opt.indexOf("c") > -1;
            if (opt != null && opt.indexOf("t") > -1) {
                String[] fields = null;
                ResultSetMetaData rsmd = rs.getMetaData();
                int colCount = rsmd.getColumnCount();
                String tableName = rsmd.getTableName(1);
                if ((tableName = DatabaseUtil.tranName(tableName, tranContent, dbCharset, toCharset, bb, opt)) == null || tableName.trim().length() < 1) {
                    tableName = SQLParser.getClause(sql, 1);
                    tableName = DatabaseUtil.removeTilde(tableName, dbs);
                }
                if (sql.indexOf(" as ") < 0) {
                    fields = new String[colCount];
                    String[][] tableCols = new String[colCount][];
                    if (cleanFieldName) {
                        String colName;
                        ArrayList<String> oldcns = new ArrayList<String>(colCount);
                        ArrayList<String> cns = new ArrayList<String>(colCount);
                        int c = 1;
                        while (c <= colCount) {
                            colName = DatabaseUtil.tranName(rsmd.getColumnLabel(c), tranContent, dbCharset, toCharset, bb, opt);
                            DatabaseUtil.cleanFieldName(colName, oldcns, cns, rsmd.getTableName(c));
                            ++c;
                        }
                        c = 0;
                        while (c < colCount) {
                            fields[c] = colName = (String)cns.get(c);
                            String[] tCol = new String[]{colName};
                            tableCols[c] = tCol;
                            ++c;
                        }
                    } else {
                        int c = 1;
                        while (c <= colCount) {
                            String colName;
                            fields[c - 1] = colName = DatabaseUtil.tranName(rsmd.getColumnLabel(c), tranContent, dbCharset, toCharset, bb, opt);
                            String[] tCol = new String[]{colName};
                            tableCols[c - 1] = tCol;
                            ++c;
                        }
                    }
                } else {
                    String selCols = sql.substring(sql.indexOf("select") + 6, sql.indexOf("from")).trim();
                    String[] cols = selCols.split(",");
                    if (cols != null && cols.length > 0) {
                        int length = cols.length;
                        String[][] tableCols = new String[length][];
                        fields = new String[length];
                        int i = 0;
                        while (i < length) {
                            String col = cols[i];
                            if (col.indexOf(" as ") < 0) {
                                fields[i] = col;
                                String[] tCol = new String[]{col};
                                tableCols[i] = tCol;
                            } else {
                                String[] sets = col.split(" ");
                                fields[i] = sets[sets.length - 1];
                                String[] tCol = new String[]{sets[0]};
                                tableCols[i] = tCol;
                            }
                            ++i;
                        }
                    }
                }
                if (opt != null && opt.indexOf("u") > -1) {
                    DatabaseMetaData dmd = con.getMetaData();
                    try {
                        rs = dmd.getPrimaryKeys(con.getCatalog(), null, tableName);
                        int count = 0;
                        ArrayList<String> nameList = new ArrayList<String>();
                        while (rs.next()) {
                            String keyName = rs.getString("COLUMN_NAME");
                            if (keyName == null || keyName.trim().length() <= 0) continue;
                            nameList.add(keyName);
                            ++count;
                        }
                        if (count > 0) {
                            String[] pks = new String[count];
                            int i = 0;
                            while (i < count) {
                                pks[i] = (String)nameList.get(i);
                                ++i;
                            }
                            table.setPrimary(pks);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            Table table2 = table;
            return table2;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    private static Table retrieveOne(String sql, Object[] params, byte[] types, DBSession dbs, Context ctx, String opt) {
        ResultSet rs = null;
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        try {
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                int pos = 0;
                int paramIndex = 0;
                while (paramIndex < paramCount) {
                    pos = Sentence.indexOf(sql, "?", pos + 1, 18);
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] != null) {
                        if (args[paramIndex] instanceof Sequence && tranContent) {
                            Sequence l = (Sequence)args[paramIndex];
                            int i = 1;
                            int size = l.length();
                            while (i <= size) {
                                Object o = l.get(i);
                                if (o instanceof String && tranSQL) {
                                    o = new String(((String)o).getBytes(), dbCharset);
                                    l.set(i, o);
                                }
                                ++i;
                            }
                        } else if (args[paramIndex] instanceof String && tranSQL) {
                            args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                        }
                        if (args[paramIndex] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[paramIndex]).toArray();
                            int objCount = objs.length;
                            StringBuffer sb = new StringBuffer(2 * objCount);
                            int iObj = 0;
                            while (iObj < objCount) {
                                sb.append("?,");
                                ++iObj;
                            }
                            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                                sb.deleteCharAt(sb.length() - 1);
                            }
                            if (sb.length() > 1) {
                                sql = String.valueOf(sql.substring(0, pos)) + sb.toString() + sql.substring(pos + 1);
                            }
                            pos += sb.length();
                        }
                    }
                    ++paramIndex;
                }
            }
            try {
                pst = con.prepareStatement(sql);
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name2, sql)) + " : " + e.getMessage(), e);
            }
            if (args != null && args.length > 0) {
                int pos = 0;
                int iArg = 0;
                while (iArg < args.length) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        if (args[iArg] != null && args[iArg] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[iArg]).toArray();
                            int iObj = 0;
                            while (iObj < objs.length) {
                                SQLTool.setObject(dbType, (PreparedStatement)pst, pos, objs[iObj], type);
                                ++pos;
                                ++iObj;
                            }
                            --pos;
                        } else {
                            SQLTool.setObject(dbType, (PreparedStatement)pst, pos, args[iArg], type);
                        }
                    }
                    catch (Exception e) {
                        String name3 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name3 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", name3, Integer.toString(iArg + 1)));
                    }
                    ++iArg;
                }
            }
            try {
                rs = pst.executeQuery();
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name4 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name4 = info.getName();
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name4, sql)) + " : " + e.getMessage(), e);
            }
            Table table = DatabaseUtil.populateOne(rs, dbCharset, tranContent, toCharset, dbType, opt);
            return table;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    private static Object runSQL(String sql, Object[] params, byte[] types, DBSession dbs, boolean isupdate, String opt) {
        Statement pst = null;
        Statement st = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        boolean isSolid = opt != null && opt.indexOf("s") > -1;
        int dbType = 0;
        try {
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                int pos = 0;
                int paramIndex = 0;
                while (paramIndex < paramCount) {
                    pos = Sentence.indexOf(sql, "?", pos + 1, 18);
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] != null) {
                        if (args[paramIndex] instanceof Sequence && tranContent) {
                            Sequence l = (Sequence)args[paramIndex];
                            int i = 1;
                            int size = l.length();
                            while (i <= size) {
                                Object o = l.get(i);
                                if (o instanceof String && tranSQL) {
                                    o = new String(((String)o).getBytes(), dbCharset);
                                    l.set(i, o);
                                }
                                ++i;
                            }
                        } else if (args[paramIndex] instanceof String && tranSQL) {
                            args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                        }
                        if (args[paramIndex] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[paramIndex]).toArray();
                            int objCount = objs.length;
                            StringBuffer sb = new StringBuffer(2 * objCount);
                            int iObj = 0;
                            while (iObj < objCount) {
                                sb.append("?,");
                                ++iObj;
                            }
                            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                                sb.deleteCharAt(sb.length() - 1);
                            }
                            if (sb.length() > 1) {
                                sql = String.valueOf(sql.substring(0, pos)) + sb.toString() + sql.substring(pos + 1);
                            }
                            pos += sb.length();
                        }
                    }
                    ++paramIndex;
                }
            }
            if (isSolid && args != null && args.length > 0) {
                isSolid = false;
            }
            try {
                if (isSolid) {
                    st = con.createStatement();
                } else {
                    pst = con.prepareStatement(sql);
                }
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name2, sql)) + " : " + e.getMessage(), e);
            }
            if (args != null && args.length > 0) {
                int pos = 0;
                int iArg = 0;
                while (iArg < args.length) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        if (args[iArg] != null && args[iArg] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[iArg]).toArray();
                            int iObj = 0;
                            while (iObj < objs.length) {
                                SQLTool.setObject(dbType, (PreparedStatement)pst, pos, objs[iObj], type);
                                ++pos;
                                ++iObj;
                            }
                            --pos;
                        } else {
                            SQLTool.setObject(dbType, (PreparedStatement)pst, pos, args[iArg], type);
                        }
                    }
                    catch (SQLException e) {
                        if (dbs.getErrorMode()) {
                            dbs.setError(e);
                        }
                        String name3 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name3 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", name3, Integer.toString(iArg + 1)), e);
                    }
                    catch (Exception e) {
                        String name4 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name4 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", name4, Integer.toString(iArg + 1)), e);
                    }
                    ++iArg;
                }
            }
            Constable result = null;
            try {
                if (isupdate) {
                    int number = 0;
                    number = isSolid ? st.executeUpdate(sql) : pst.executeUpdate();
                    result = new Integer(number);
                } else {
                    String begin;
                    String string = begin = sql == null || sql.length() < 6 ? "" : sql.substring(0, 6);
                    if (begin.equalsIgnoreCase("insert") || begin.equalsIgnoreCase("update") || begin.equalsIgnoreCase("delete")) {
                        int number = 0;
                        number = isSolid ? st.executeUpdate(sql) : pst.executeUpdate();
                        result = new Integer(number);
                    } else {
                        boolean success = false;
                        success = isSolid ? st.execute(sql) : pst.execute();
                        result = Boolean.valueOf(success);
                    }
                }
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name5 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name5 = info.getName();
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name5, sql)) + " : " + e.getMessage(), e);
            }
            Integer n = result;
            return n;
        }
        catch (RQException re) {
            if (dbs.getErrorMode() && dbs.error() != null) {
                return null;
            }
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    private static Boolean runSQL2(PreparedStatement pst, Object[] params, byte[] types, String dbCharset, boolean tranSQL, int dbType, String dsName, DBSession dbs) {
        try {
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                int paramIndex = 0;
                while (paramIndex < paramCount) {
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] != null && args[paramIndex] instanceof String && tranSQL) {
                        args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                    }
                    ++paramIndex;
                }
            }
            if (args != null && args.length > 0) {
                int pos = 0;
                int iArg = 0;
                while (iArg < args.length) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        SQLTool.setObject(dbType, pst, pos, args[iArg], type);
                    }
                    catch (SQLException e) {
                        if (dbs.getErrorMode()) {
                            dbs.setError(e);
                        }
                        MessageManager mm = DataSetMessage.get();
                        throw new RQException(mm.getMessage("error.argIndex", dsName, Integer.toString(iArg + 1)), e);
                    }
                    catch (Exception e) {
                        MessageManager mm = DataSetMessage.get();
                        throw new RQException(mm.getMessage("error.argIndex", dsName, Integer.toString(iArg + 1)), e);
                    }
                    ++iArg;
                }
            }
            Boolean result = Boolean.FALSE;
            try {
                boolean success = pst.execute();
                result = success;
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                MessageManager mm = DataSetMessage.get();
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", dsName, "")) + " : " + e.getMessage(), e);
            }
            return result;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    private static void addBatch(PreparedStatement pst, Object[] params, byte[] types, String dbCharset, boolean tranSQL, int dbType, String dsName, DBSession dbs) {
        try {
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                int paramIndex = 0;
                while (paramIndex < paramCount) {
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] != null && args[paramIndex] instanceof String && tranSQL) {
                        args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                    }
                    ++paramIndex;
                }
            }
            if (args != null && args.length > 0) {
                int pos = 0;
                int iArg = 0;
                while (iArg < args.length) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        SQLTool.setObject(dbType, pst, pos, args[iArg], type);
                    }
                    catch (SQLException e) {
                        if (dbs.getErrorMode()) {
                            dbs.setError(e);
                        }
                        MessageManager mm = DataSetMessage.get();
                        e.printStackTrace();
                        throw new RQException(mm.getMessage("error.argIndex", dsName, Integer.toString(iArg + 1)), e);
                    }
                    catch (Exception e) {
                        MessageManager mm = DataSetMessage.get();
                        e.printStackTrace();
                        throw new RQException(mm.getMessage("error.argIndex", dsName, Integer.toString(iArg + 1)), e);
                    }
                    ++iArg;
                }
            }
            pst.addBatch();
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    private static Table populate(ResultSet rs, String dbCharset, boolean needTranContent, String toCharset, int dbType, boolean addTable, Table table, boolean oneRecord, int recordLimit, String opt) throws Exception {
        boolean cleanFieldName;
        if (rs == null) {
            return null;
        }
        ResultSetMetaData rsmd = null;
        try {
            rsmd = rs.getMetaData();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rsmd == null) {
            return null;
        }
        int colCount = rsmd.getColumnCount();
        if (needTranContent && (toCharset == null || toCharset.trim().length() == 0)) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.toCharset"));
        }
        boolean bb = true;
        if (toCharset != null) {
            bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
        }
        boolean bl = cleanFieldName = opt != null && opt.indexOf("c") > -1;
        if (table == null) {
            int[] colTypes = new int[colCount];
            String[] colNames = new String[colCount];
            if (cleanFieldName) {
                String colName;
                ArrayList<String> oldcns = new ArrayList<String>(colCount);
                ArrayList<String> cns = new ArrayList<String>(colCount);
                int c = 1;
                while (c <= colCount) {
                    try {
                        colName = DatabaseUtil.tranName(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                        DatabaseUtil.cleanFieldName(colName, oldcns, cns, rsmd.getTableName(c));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++c;
                }
                c = 0;
                while (c < colCount) {
                    colNames[c] = colName = (String)cns.get(c);
                    ++c;
                }
            } else {
                int c = 1;
                while (c <= colCount) {
                    try {
                        String colName;
                        colNames[c - 1] = colName = DatabaseUtil.tranName(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++c;
                }
            }
            int c = 1;
            while (c <= colCount) {
                try {
                    if (addTable) {
                        String tn = rsmd.getTableName(c);
                        tn = (tn = DatabaseUtil.tranName(tn, needTranContent, dbCharset, toCharset, bb, opt)) == null ? "" : String.valueOf(tn) + "_";
                        colNames[c - 1] = String.valueOf(tn) + colNames[c - 1];
                    }
                    colTypes[c - 1] = rsmd.getColumnType(c);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++c;
            }
            table = new Table(colNames);
        }
        if (recordLimit == 0) {
            return table;
        }
        boolean nolimit = recordLimit < 0;
        while (rs.next()) {
            BaseRecord record = table.newLast();
            int n = 1;
            while (n <= colCount) {
                int type = 0;
                if (dbType == 1) {
                    type = rsmd.getColumnType(n);
                }
                try {
                    Object obj = DatabaseUtil.tranData(type, dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                    record.set(n - 1, obj);
                }
                catch (Exception e) {
                    if (opt != null && opt.indexOf(114) > -1) {
                        e.printStackTrace();
                    }
                    throw e;
                }
                ++n;
            }
            if (!nolimit && --recordLimit == 0) {
                return table;
            }
            if (!oneRecord) continue;
            return table;
        }
        return table;
    }

    private static Sequence populateGroup(ResultSet rs, String dbCharset, boolean needTranContent, String toCharset, int dbType, Table table, String opt) throws SQLException, UnsupportedEncodingException {
        boolean cleanFieldName;
        if (rs == null) {
            return null;
        }
        if (needTranContent && (toCharset == null || toCharset.trim().length() == 0)) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.toCharset"));
        }
        boolean bb = true;
        if (toCharset != null) {
            bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        boolean bl = cleanFieldName = opt != null && opt.indexOf("c") > -1;
        if (table == null) {
            int[] colTypes = new int[colCount];
            String[] colNames = new String[colCount];
            if (cleanFieldName) {
                String colName;
                ArrayList<String> oldcns = new ArrayList<String>(colCount);
                ArrayList<String> cns = new ArrayList<String>(colCount);
                int c = 1;
                while (c <= colCount) {
                    try {
                        colName = DatabaseUtil.tranName(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                        DatabaseUtil.cleanFieldName(colName, oldcns, cns, rsmd.getTableName(c));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    colTypes[c - 1] = rsmd.getColumnType(c);
                    ++c;
                }
                c = 0;
                while (c < colCount) {
                    colNames[c] = colName = (String)cns.get(c);
                    ++c;
                }
            } else {
                int c = 1;
                while (c <= colCount) {
                    try {
                        colNames[c - 1] = DatabaseUtil.tranName(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    colTypes[c - 1] = rsmd.getColumnType(c);
                    ++c;
                }
            }
            table = new Table(colNames);
        }
        Sequence series = new Sequence();
        while (rs.next()) {
            BaseRecord record = table.newLast();
            series.add(record);
            int n = 1;
            while (n <= colCount) {
                int type = 0;
                if (dbType == 1) {
                    type = rsmd.getColumnType(n);
                }
                try {
                    Object obj = DatabaseUtil.tranData(type, dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                    record.set(n - 1, obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n;
            }
        }
        return series;
    }

    private static Table populateOne(ResultSet rs, String dbCharset, boolean needTranContent, String toCharset, int dbType, String opt) throws SQLException, UnsupportedEncodingException {
        String[] colNames;
        int colCount;
        ResultSetMetaData rsmd;
        boolean bb;
        block16: {
            if (rs == null) {
                return null;
            }
            if (needTranContent && (toCharset == null || toCharset.trim().length() == 0)) {
                MessageManager mm = DataSetMessage.get();
                throw new RQException(mm.getMessage("error.toCharset"));
            }
            bb = true;
            if (toCharset != null) {
                bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
            }
            rsmd = rs.getMetaData();
            colCount = rsmd.getColumnCount();
            int[] colTypes = new int[colCount];
            colNames = new String[colCount];
            boolean cleanFieldName = opt != null && opt.indexOf("c") > -1;
            try {
                if (cleanFieldName) {
                    String colName;
                    ArrayList<String> oldcns = new ArrayList<String>(colCount);
                    ArrayList<String> cns = new ArrayList<String>(colCount);
                    int c = 1;
                    while (c <= colCount) {
                        try {
                            colName = DatabaseUtil.tranName(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                            DatabaseUtil.cleanFieldName(colName, oldcns, cns, rsmd.getTableName(c));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        colTypes[c - 1] = rsmd.getColumnType(c);
                        ++c;
                    }
                    c = 0;
                    while (c < colCount) {
                        colNames[c] = colName = (String)cns.get(c);
                        ++c;
                    }
                    break block16;
                }
                int c = 1;
                while (c <= colCount) {
                    colNames[c - 1] = DatabaseUtil.tranName(rsmd.getColumnLabel(c), needTranContent, dbCharset, toCharset, bb, opt);
                    colTypes[c - 1] = rsmd.getColumnType(c);
                    ++c;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Table table = new Table(colNames);
        if (rs.next()) {
            BaseRecord record = table.newLast();
            int n = 1;
            while (n <= colCount) {
                int type = 0;
                if (dbType == 1) {
                    type = rsmd.getColumnType(n);
                }
                try {
                    Object obj = DatabaseUtil.tranData(type, dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                    record.set(n - 1, obj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++n;
            }
            return table;
        }
        return null;
    }

    public static Object execute(String sql, Object[] params, byte[] types, DBSession dbs, String opt) {
        return DatabaseUtil.runSQL(sql, params, types, dbs, false, opt);
    }

    public static void execute2old(String sql, Object[][] paramsGroup, byte[] types, DBSession dbs, boolean interrupt) {
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        String name = "";
        DBInfo info = dbs.getInfo();
        if (info != null) {
            name = info.getName();
        }
        try {
            try {
                Object session;
                DBConfig dsConfig = null;
                MessageManager mm = DataSetMessage.get();
                if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                    dsConfig = (DBConfig)dbs.getInfo();
                }
                if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                    con = (Connection)session;
                }
                if (con == null || con.isClosed()) {
                    throw new RQException(mm.getMessage("error.conClosed", name));
                }
                if (dsConfig != null) {
                    dbCharset = dsConfig.getDBCharset();
                    tranSQL = dsConfig.getNeedTranSentence();
                    tranContent = dsConfig.getNeedTranContent();
                    if ((tranContent || tranSQL) && dbCharset == null) {
                        throw new RQException(mm.getMessage("error.fromCharset", name));
                    }
                    toCharset = dsConfig.getClientCharset();
                    if ((tranContent || tranSQL) && toCharset == null) {
                        throw new RQException(mm.getMessage("error.toCharset", name));
                    }
                    dbType = dsConfig.getDBType();
                } else {
                    tranContent = false;
                }
                if (tranSQL) {
                    sql = new String(sql.getBytes(), dbCharset);
                }
                try {
                    pst = con.prepareStatement(sql);
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name, sql)) + " : " + e.getMessage(), e);
                }
                int count = paramsGroup.length;
                int i = 0;
                while (i < count) {
                    Object[] params = paramsGroup[i];
                    try {
                        DatabaseUtil.runSQL2((PreparedStatement)pst, params, types, dbCharset, tranSQL, dbType, name, dbs);
                    }
                    catch (Exception e) {
                        if (interrupt) {
                            throw e;
                        }
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (RQException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public static void execute2(String sql, Object[][] paramsGroup, byte[] types, DBSession dbs, boolean interrupt) {
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        String name = "";
        DBInfo info = dbs.getInfo();
        if (info != null) {
            name = info.getName();
        }
        int batchSize = 1000;
        try {
            try {
                Object session;
                DBConfig dsConfig = null;
                MessageManager mm = DataSetMessage.get();
                if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                    dsConfig = (DBConfig)dbs.getInfo();
                }
                if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                    con = (Connection)session;
                }
                if (con == null || con.isClosed()) {
                    throw new RQException(mm.getMessage("error.conClosed", name));
                }
                if (dsConfig != null) {
                    batchSize = dsConfig.getBatchSize();
                    if (batchSize < 1) {
                        batchSize = 1;
                    }
                    dbCharset = dsConfig.getDBCharset();
                    tranSQL = dsConfig.getNeedTranSentence();
                    tranContent = dsConfig.getNeedTranContent();
                    if ((tranContent || tranSQL) && dbCharset == null) {
                        throw new RQException(mm.getMessage("error.fromCharset", name));
                    }
                    toCharset = dsConfig.getClientCharset();
                    if ((tranContent || tranSQL) && toCharset == null) {
                        throw new RQException(mm.getMessage("error.toCharset", name));
                    }
                    dbType = dsConfig.getDBType();
                } else {
                    tranContent = false;
                }
                if (tranSQL) {
                    sql = new String(sql.getBytes(), dbCharset);
                }
                try {
                    pst = con.prepareStatement(sql);
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name, sql)) + " : " + e.getMessage(), e);
                }
                int count = paramsGroup.length;
                int batch = 1;
                int i = 0;
                while (i < count) {
                    Object[] params = paramsGroup[i];
                    if (batchSize <= 1) {
                        try {
                            DatabaseUtil.runSQL2((PreparedStatement)pst, params, types, dbCharset, tranSQL, dbType, name, dbs);
                        }
                        catch (Exception e) {
                            if (interrupt) {
                                throw e;
                            }
                            e.printStackTrace();
                        }
                    } else if (batch >= batchSize || i == count - 1) {
                        try {
                            DatabaseUtil.addBatch((PreparedStatement)pst, params, types, dbCharset, tranSQL, dbType, name, dbs);
                            pst.executeBatch();
                            pst.clearBatch();
                        }
                        catch (SQLException e) {
                            if (dbs.getErrorMode()) {
                                dbs.setError(e);
                            } else {
                                if (interrupt) {
                                    throw e;
                                }
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            if (interrupt) {
                                throw e;
                            }
                            e.printStackTrace();
                        }
                        batch = 1;
                    } else {
                        try {
                            DatabaseUtil.addBatch((PreparedStatement)pst, params, types, dbCharset, tranSQL, dbType, name, dbs);
                        }
                        catch (Exception e) {
                            if (interrupt) {
                                throw e;
                            }
                            e.printStackTrace();
                        }
                        ++batch;
                    }
                    ++i;
                }
            }
            catch (RQException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    private static void executeBatch(String sql, Object[][] paramsGroup, byte[] types, DBSession dbs, Connection con, String dbCharset, boolean tranSQL, int dbType, String dbn, int batchSize, boolean interrupt) {
        PreparedStatement pst = null;
        MessageManager mm = DataSetMessage.get();
        try {
            try {
                try {
                    pst = con.prepareStatement(sql);
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    throw new RQException(String.valueOf(mm.getMessage("error.sqlException", dbn, sql)) + " : " + e.getMessage(), e);
                }
                int count = paramsGroup.length;
                int batch = 1;
                int i = 0;
                while (i < count) {
                    Object[] params = paramsGroup[i];
                    if (batchSize <= 1) {
                        try {
                            DatabaseUtil.runSQL2(pst, params, types, dbCharset, tranSQL, dbType, dbn, dbs);
                        }
                        catch (Exception e) {
                            if (interrupt) {
                                throw e;
                            }
                            e.printStackTrace();
                        }
                    } else if (batch >= batchSize || i == count - 1) {
                        try {
                            DatabaseUtil.addBatch(pst, params, types, dbCharset, tranSQL, dbType, dbn, dbs);
                            pst.executeBatch();
                            pst.clearBatch();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                            if (dbs.getErrorMode()) {
                                dbs.setError(e);
                            } else {
                                if (interrupt) {
                                    throw e;
                                }
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            if (interrupt) {
                                throw e;
                            }
                            e.printStackTrace();
                        }
                        batch = 1;
                    } else {
                        try {
                            DatabaseUtil.addBatch(pst, params, types, dbCharset, tranSQL, dbType, dbn, dbs);
                        }
                        catch (Exception e) {
                            if (interrupt) {
                                throw e;
                            }
                            e.printStackTrace();
                        }
                        ++batch;
                    }
                    ++i;
                }
            }
            catch (RQException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    private static void executeBatch(PreparedStatement pst, Object[][] paramsGroup, byte[] types, DBSession dbs, String dbCharset, boolean tranSQL, int dbType, String name, boolean interrupt) {
        block13: {
            try {
                int count = paramsGroup.length;
                int i = 0;
                while (i < count) {
                    Object[] params = paramsGroup[i];
                    try {
                        DatabaseUtil.addBatch(pst, params, types, dbCharset, tranSQL, dbType, name, dbs);
                    }
                    catch (Exception e) {
                        if (interrupt) {
                            throw e;
                        }
                        e.printStackTrace();
                    }
                    ++i;
                }
                try {
                    pst.executeBatch();
                    pst.clearBatch();
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                        break block13;
                    }
                    if (interrupt) {
                        throw e;
                    }
                    e.printStackTrace();
                }
                catch (Exception e) {
                    if (interrupt) {
                        throw e;
                    }
                    e.printStackTrace();
                }
            }
            catch (RQException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public static Sequence query(String sql, Object[] params, byte[] types, DBSession dbs, String opt) {
        Table tbl = DatabaseUtil.retrieve(sql, params, types, dbs, opt, -1);
        if (tbl != null && tbl.dataStruct().getFieldCount() == 1 && opt != null && opt.indexOf(105) != -1) {
            return tbl.fieldValues(0);
        }
        return tbl;
    }

    public static Sequence query(String sql, Object[] params, byte[] types, DBSession dbs, String opt, Context ctx) {
        return DatabaseUtil.query(sql, params, types, dbs, opt, -1, ctx);
    }

    public static Sequence query(String sql, Object[] params, byte[] types, DBSession dbs, String opt, int recordLimit, Context ctx) {
        Table tbl = DatabaseUtil.retrieve(sql, params, types, dbs, opt, recordLimit);
        if (tbl != null && tbl.dataStruct().getFieldCount() == 1 && opt != null && opt.indexOf(105) != -1) {
            return tbl.fieldValues(0);
        }
        return tbl;
    }

    public static Sequence queryGroup(String sql, Object[][] params, byte[] types, DBSession dbs, Context ctx, String opt) throws RQException {
        if (params == null || params.length < 1) {
            return DatabaseUtil.query(sql, null, types, dbs, null);
        }
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        try {
            Object[] modeParams;
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = (modeParams = params[0]) == null ? 0 : modeParams.length;
            byte[] argTypes = null;
            if (paramCount > 0) {
                argTypes = new byte[paramCount];
                int paramIndex = 0;
                while (paramIndex < paramCount) {
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    ++paramIndex;
                }
            }
            try {
                pst = con.prepareStatement(sql);
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name2, sql)) + " : " + e.getMessage(), e);
            }
            Sequence resultSeries = new Sequence();
            Object[] args = new Object[paramCount];
            Table table = null;
            int i = 0;
            int iCount = params.length;
            while (i < iCount) {
                block58: {
                    Object[] thisParams = params[i];
                    if (paramCount > 0) {
                        int paramIndex = 0;
                        while (paramIndex < paramCount) {
                            args[paramIndex] = thisParams[paramIndex];
                            if (args[paramIndex] != null && args[paramIndex] instanceof String && tranSQL) {
                                args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                            }
                            ++paramIndex;
                        }
                    }
                    if (args != null && args.length > 0) {
                        int iArg = 0;
                        while (iArg < args.length) {
                            try {
                                byte type = argTypes[iArg];
                                SQLTool.setObject(dbType, (PreparedStatement)pst, iArg + 1, args[iArg], type);
                            }
                            catch (Exception e) {
                                String name3 = "";
                                DBInfo info = dbs.getInfo();
                                if (info != null) {
                                    name3 = info.getName();
                                }
                                throw new RQException(mm.getMessage("error.argIndex", name3, Integer.toString(iArg + 1)));
                            }
                            ++iArg;
                        }
                    }
                    ResultSet rs = null;
                    if (tranContent && (toCharset == null || toCharset.trim().length() == 0)) {
                        throw new RQException(mm.getMessage("error.toCharset"));
                    }
                    boolean bb = true;
                    if (toCharset != null) {
                        bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
                    }
                    try {
                        try {
                            rs = pst.executeQuery();
                            if (table == null) {
                                boolean cleanFieldName;
                                ResultSetMetaData rsmd = rs.getMetaData();
                                int colCount = rsmd.getColumnCount();
                                int[] colTypes = new int[colCount];
                                String[] colNames = new String[colCount];
                                boolean bl = cleanFieldName = opt != null && opt.indexOf("c") > -1;
                                if (cleanFieldName) {
                                    String colName;
                                    ArrayList<String> oldcns = new ArrayList<String>(colCount);
                                    ArrayList<String> cns = new ArrayList<String>(colCount);
                                    int c = 1;
                                    while (c <= colCount) {
                                        try {
                                            colName = DatabaseUtil.tranName(rsmd.getColumnLabel(c), tranContent, dbCharset, toCharset, bb, opt);
                                            DatabaseUtil.cleanFieldName(colName, oldcns, cns, rsmd.getTableName(c));
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        colTypes[c - 1] = rsmd.getColumnType(c);
                                        ++c;
                                    }
                                    c = 0;
                                    while (c < colCount) {
                                        colNames[c] = colName = (String)cns.get(c);
                                        ++c;
                                    }
                                } else {
                                    int c = 1;
                                    while (c <= colCount) {
                                        colNames[c - 1] = DatabaseUtil.tranName(rsmd.getColumnLabel(c), tranContent, dbCharset, toCharset, bb, opt);
                                        colTypes[c - 1] = rsmd.getColumnType(c);
                                        ++c;
                                    }
                                }
                                table = new Table(colNames);
                            }
                            resultSeries.add(DatabaseUtil.populateGroup(rs, dbCharset, tranContent, toCharset, dbType, table, opt));
                        }
                        catch (SQLException e) {
                            if (!dbs.getErrorMode()) {
                                String name4 = "";
                                DBInfo info = dbs.getInfo();
                                if (info != null) {
                                    name4 = info.getName();
                                }
                                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name4, sql)) + " : " + e.getMessage(), e);
                            }
                            dbs.setError(e);
                            if (rs != null) {
                                rs.close();
                            }
                            break block58;
                        }
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable;
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                ++i;
            }
            Sequence sequence = resultSeries;
            return sequence;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public static Table query(String tableName, String[] fields, String[] keyNames, Object[][] keyValues, DBSession dbs, Context ctx) {
        String sql = "select ";
        int size = fields.length;
        String fieldAll = null;
        String field = null;
        int i = 0;
        while (i < size) {
            field = DatabaseUtil.addTilde(fields[i], dbs);
            if (field != null && field.trim().length() > 0) {
                fieldAll = fieldAll == null ? field : String.valueOf(fieldAll) + ", " + field;
            }
            ++i;
        }
        if (fieldAll == null || fieldAll.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidField"));
        }
        size = keyNames.length;
        int colCount = keyValues.length;
        String conditions = null;
        String key = "";
        Object v = null;
        ArrayList<Object> params = new ArrayList<Object>();
        int n = 0;
        while (n < colCount) {
            Object[] rValues = keyValues[n];
            String condition = null;
            int i2 = 0;
            while (i2 < size) {
                key = keyNames[i2];
                if (key != null && key.trim().length() > 0) {
                    v = null;
                    if (i2 < rValues.length) {
                        v = rValues[i2];
                    }
                    if (condition == null) {
                        condition = "(" + key + " = ?)";
                        params.add(v);
                    } else {
                        condition = String.valueOf(condition) + " and (" + key + " = ?)";
                        params.add(v);
                    }
                }
                ++i2;
            }
            if (condition != null && condition.trim().length() > 0) {
                conditions = conditions == null ? "(" + condition + ")" : String.valueOf(conditions) + " or (" + condition + ")";
            }
            ++n;
        }
        if (conditions == null || conditions.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidCondition"));
        }
        sql = String.valueOf(sql) + fieldAll + " from " + DatabaseUtil.addTilde(tableName, dbs) + " where " + conditions;
        return DatabaseUtil.retrieve(sql, params.toArray(), null, dbs, null, -1);
    }

    public static Sequence query(String tableName, String[] fields, String[] keyNames, Object[] keyValues, DBSession dbs, Context ctx, String opt) {
        String sql = "select ";
        int size = fields.length;
        String fieldAll = null;
        String field = null;
        int i = 0;
        while (i < size) {
            field = DatabaseUtil.addTilde(fields[i], dbs);
            if (field != null && field.trim().length() > 0) {
                fieldAll = fieldAll == null ? field : String.valueOf(fieldAll) + ", " + field;
            }
            ++i;
        }
        if (fieldAll == null || fieldAll.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidField"));
        }
        size = keyNames.length;
        String key = "";
        Object v = null;
        String condition = null;
        ArrayList<Object> params = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < size) {
            key = keyNames[i2];
            if (key != null && key.trim().length() > 0) {
                v = null;
                if (i2 < keyValues.length) {
                    v = keyValues[i2];
                }
                if (condition == null) {
                    condition = "(" + key + " = ?)";
                    params.add(v);
                } else {
                    condition = String.valueOf(condition) + " and (" + key + " = ?)";
                    params.add(v);
                }
            }
            ++i2;
        }
        if (condition == null || condition.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidCondition"));
        }
        Table tbl = DatabaseUtil.retrieveOne(sql = String.valueOf(sql) + fieldAll + " from " + DatabaseUtil.addTilde(tableName, dbs) + " where " + condition, params.toArray(), null, dbs, ctx, opt);
        if (tbl != null && tbl.dataStruct().getFieldCount() == 1 && opt != null && opt.indexOf(105) != -1) {
            return tbl.fieldValues(0);
        }
        return tbl;
    }

    public static Sequence query(String tableName, String[] keyNames, Object[] keyValues, DBSession dbs, Context ctx, String opt) {
        String[] fields = new String[]{"*"};
        return DatabaseUtil.query(tableName, fields, keyNames, keyValues, dbs, ctx, opt);
    }

    public static Table query(String tableName, String[] keyNames, Object[][] keyValues, DBSession dbs, Context ctx) {
        String[] fields = new String[]{"*"};
        return DatabaseUtil.query(tableName, fields, keyNames, keyValues, dbs, ctx);
    }

    public static void update(String tableName, Object[] keyValues, String[] fields, Object[] values, DBSession dbs) {
        DatabaseUtil.update(tableName, keyValues, fields, values, null, dbs);
    }

    public static Object update(String tableName, Object[] keyValues, String[] fields, Object[] values, String opt, DBSession dbs) {
        MessageManager mm;
        if (tableName == null || tableName.trim().length() < 1) {
            MessageManager mm2 = DataSetMessage.get();
            throw new RQException(mm2.getMessage("error.invalidTable"));
        }
        if (fields == null || fields.length < 1) {
            MessageManager mm3 = DataSetMessage.get();
            throw new RQException(mm3.getMessage("error.invalidField"));
        }
        if (values == null || values.length < 1) {
            MessageManager mm4 = DataSetMessage.get();
            throw new RQException(mm4.getMessage("error.invalidFieldValue"));
        }
        Connection con = null;
        String[] keyNames = null;
        try {
            Object session;
            mm = DataSetMessage.get();
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                String dbName = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    dbName = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", dbName));
            }
            keyNames = DatabaseUtil.getKeyNames(con, tableName);
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e);
        }
        if (keyNames == null) {
            return null;
        }
        if (keyNames == null || keyNames.length < 1) {
            mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidKey"));
        }
        if (keyValues == null || keyValues.length < 1) {
            mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidKeyValue"));
        }
        int type = 0;
        if (opt != null) {
            if (opt.toLowerCase().indexOf(117) > -1) {
                type = 1;
            } else if (opt.toLowerCase().indexOf(105) > -1) {
                type = 2;
            }
        }
        int size = keyNames.length;
        String condition = null;
        String key = "";
        Object v = null;
        ArrayList<Object> params = new ArrayList<Object>();
        int i = 0;
        while (i < size) {
            key = keyNames[i];
            if (key != null && key.trim().length() > 0) {
                v = null;
                if (i < keyValues.length) {
                    v = keyValues[i];
                }
                if (condition == null) {
                    condition = "(" + key + " = ?)";
                    params.add(v);
                } else {
                    condition = String.valueOf(condition) + " and (" + key + " = ?)";
                    params.add(v);
                }
            }
            ++i;
        }
        if (condition == null || condition.trim().length() < 1) {
            MessageManager mm5 = DataSetMessage.get();
            throw new RQException(mm5.getMessage("error.invalidCondition"));
        }
        String sql = "";
        int n = 0;
        if (type == 0) {
            sql = "select count(*) from " + DatabaseUtil.addTilde(tableName, dbs) + " where " + condition;
            Table se = DatabaseUtil.retrieve(sql, params.toArray(), null, dbs, null, -1);
            n = ((Number)((BaseRecord)se.get(1)).getFieldValue(0)).intValue();
            type = n > 0 ? 1 : 2;
        }
        ArrayList<Object> allParams = new ArrayList<Object>();
        if (type == 1) {
            size = fields.length;
            String sets = null;
            String field = "";
            Object fv = null;
            int i2 = 0;
            while (i2 < size) {
                field = fields[i2];
                if (field != null && field.trim().length() > 0) {
                    fv = null;
                    if (i2 < values.length) {
                        fv = values[i2];
                    }
                    if (sets == null) {
                        sets = field + " = ?";
                        allParams.add(fv);
                    } else {
                        sets = String.valueOf(sets) + ", " + field + " = ?";
                        allParams.add(fv);
                    }
                }
                ++i2;
            }
            allParams.addAll(params);
            if (sets == null || sets.trim().length() < 1) {
                MessageManager mm6 = DataSetMessage.get();
                throw new RQException(mm6.getMessage("error.invalidFieldValue"));
            }
            sql = "update " + DatabaseUtil.addTilde(tableName, dbs) + " set " + sets + " where " + condition;
        } else {
            String fieldAll = null;
            String sets = null;
            String field = "";
            Object fv = null;
            size = keyNames.length;
            int i3 = 0;
            while (i3 < size) {
                field = keyNames[i3];
                if (field != null && field.trim().length() > 0) {
                    fv = null;
                    if (i3 < keyValues.length) {
                        fv = keyValues[i3];
                    }
                    if (sets == null) {
                        fieldAll = "(" + field;
                        sets = "( ?";
                        allParams.add(fv);
                    } else {
                        fieldAll = String.valueOf(fieldAll) + "," + field;
                        sets = String.valueOf(sets) + ", ?";
                        allParams.add(fv);
                    }
                }
                ++i3;
            }
            size = fields.length;
            i3 = 0;
            while (i3 < size) {
                field = fields[i3];
                if (field != null) {
                    boolean exist = false;
                    int j = 0;
                    while (j < keyNames.length) {
                        if (field.equalsIgnoreCase(keyNames[j])) {
                            exist = true;
                            break;
                        }
                        ++j;
                    }
                    if (!exist && field.trim().length() > 0) {
                        fv = null;
                        if (i3 < values.length) {
                            fv = values[i3];
                        }
                        if (sets == null) {
                            fieldAll = "(" + field;
                            sets = "( ?";
                            allParams.add(fv);
                        } else {
                            fieldAll = String.valueOf(fieldAll) + "," + field;
                            sets = String.valueOf(sets) + ", ?";
                            allParams.add(fv);
                        }
                    }
                }
                ++i3;
            }
            if (sets == null || sets.trim().length() < 1) {
                MessageManager mm7 = DataSetMessage.get();
                throw new RQException(mm7.getMessage("error.invalidFieldValue"));
            }
            sets = String.valueOf(sets) + " )";
            if (fieldAll == null || fieldAll.trim().length() < 1) {
                MessageManager mm8 = DataSetMessage.get();
                throw new RQException(mm8.getMessage("error.invalidFieldValue"));
            }
            fieldAll = String.valueOf(fieldAll) + " )";
            sql = "insert into " + DatabaseUtil.addTilde(tableName, dbs) + " " + fieldAll + " values " + sets;
        }
        if (dbs != null) {
            return DatabaseUtil.runSQL(sql, allParams.toArray(), null, dbs, true, opt);
        }
        String dbName = "";
        MessageManager mm9 = DataSetMessage.get();
        throw new RQException(mm9.getMessage("error.conClosed", dbName));
    }

    public static Object tranData(int type, int dbType, ResultSet rs, int index, boolean needTranContent, String dbCharset, String toCharset, boolean bb, boolean typeErrIgn) throws Exception {
        return DatabaseUtil.tranData(type, dbType, rs, index, needTranContent, dbCharset, toCharset, bb, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Object tranData(int type, int dbType, ResultSet rs, int index, boolean needTranContent, String dbCharset, String toCharset, boolean bb, String opt) throws Exception {
        block48: {
            if (dbType == 1 && DatabaseUtil.oracleTIMESTAMP == null) {
                try {
                    DatabaseUtil.oracleTIMESTAMP = Class.forName("oracle.sql.TIMESTAMP");
                    DatabaseUtil.oracleDATE = Class.forName("oracle.sql.DATE");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (dbType == 3 && DatabaseUtil.sybaseTIMESTAMP == null) {
                try {
                    DatabaseUtil.sybaseTIMESTAMP = Class.forName("com.sybase.jdbc2.tds.SybTimestamp");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            obj = null;
            if (type == -1) {
                rd = rs.getCharacterStream(index);
                obj = "";
                sb = new StringBuffer();
                try {
                    while ((c = rd.read()) != -1) {
                        sb.append((char)c);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                obj = new String(sb.toString());
            } else {
                obj = type == 91 ? rs.getTimestamp(index) : rs.getObject(index);
            }
            if (obj == null) {
                return null;
            }
            if (obj instanceof String || obj instanceof Date) {
                return obj;
            }
            if (obj instanceof Number) {
                if (obj instanceof BigDecimal) {
                    if (opt != null && opt.indexOf(100) > -1) {
                        return ((Number)obj).doubleValue();
                    }
                    return obj;
                }
                if (obj instanceof Integer | obj instanceof Long || obj instanceof Double) {
                    return obj;
                }
                if (obj instanceof BigInteger) {
                    bi = (BigInteger)obj;
                    return new BigDecimal(bi);
                }
                if (obj instanceof Byte || obj instanceof Short) {
                    return ((Number)obj).intValue();
                }
                if (obj instanceof Float) {
                    return ((Number)obj).doubleValue();
                }
            } else {
                if (obj instanceof String && !bb) {
                    try {
                        if (needTranContent) {
                            return new String(((String)obj).getBytes(dbCharset), toCharset);
                        }
                        break block48;
                    }
                    catch (Exception e) {
                        mm = DataSetMessage.get();
                        throw new RQException(mm.getMessage("error.charset", dbCharset, toCharset));
                    }
                }
                if (obj instanceof Boolean) {
                    return obj;
                }
                if (obj instanceof byte[]) {
                    return obj;
                }
                if (obj instanceof Blob) {
                    blob = (Blob)obj;
                    is = new BufferedInputStream(blob.getBinaryStream());
                    try {
                        baos = new ByteArrayOutputStream(8096);
                        buf = new byte[8096];
                        while ((c1 = is.read(buf)) >= 0) {
                            baos.write(buf, 0, c1);
                        }
                        return baos.toByteArray();
                    }
                    catch (Exception e) {
                        if (is == null) ** GOTO lbl111
                        try {
                            is.close();
                        }
                        catch (Exception buf) {}
                    }
                } else if (obj instanceof Clob) {
                    clob = (Clob)obj;
                    sb = new StringBuffer((int)clob.length());
                    br = new BufferedReader(clob.getCharacterStream());
                    try {
                        buf = new char[8096];
                        while ((c1 = br.read(buf)) >= 0) {
                            sb.append(buf, 0, c1);
                        }
                        return sb.toString();
                    }
                    catch (Exception e) {
                        if (br == null) ** GOTO lbl111
                        try {
                            br.close();
                        }
                        catch (Exception var14_29) {}
                    }
                } else {
                    if (obj instanceof LocalDateTime) {
                        ldt = (LocalDateTime)obj;
                        zdt = ldt.atZone(ZoneId.systemDefault());
                        return Timestamp.from(zdt.toInstant());
                    }
                    if (obj instanceof LocalDate) {
                        ldt = (LocalDate)obj;
                        zdt = ldt.atStartOfDay(ZoneId.systemDefault());
                        return Timestamp.from(zdt.toInstant());
                    }
                    if (dbType == 1 && DatabaseUtil.oracleTIMESTAMP != null && DatabaseUtil.oracleTIMESTAMP.isInstance(obj)) {
                        return TranOracle.tran(DatabaseUtil.TYPE_ORACLE_TIMESTAMP, obj);
                    }
                    if (dbType == 1 && DatabaseUtil.oracleDATE != null && DatabaseUtil.oracleDATE.isInstance(obj)) {
                        return TranOracle.tran(DatabaseUtil.TYPE_ORACLE_DATE, obj);
                    }
                    if (dbType == 3 && DatabaseUtil.sybaseTIMESTAMP != null && DatabaseUtil.sybaseTIMESTAMP.isInstance(obj)) {
                        return TranSybase.tran(DatabaseUtil.TYPE_SYBASE_TIMESTAMP, obj);
                    }
                }
            }
        }
        Logger.debug("Unrecognized data type in SPL: " + obj.getClass().getName());
        if (opt != null && opt.indexOf(114) > -1) {
            return obj;
        }
        throw new RQException("Unrecognized data type in SPL: " + obj.getClass().getName());
    }

    private static String tranName(String name, boolean needTranContent, String dbCharset, String toCharset, boolean bb, String opt) throws Exception {
        String result = name;
        if (name != null && !bb) {
            try {
                if (needTranContent) {
                    result = new String(name.getBytes(dbCharset), toCharset);
                }
            }
            catch (Exception e) {
                MessageManager mm = DataSetMessage.get();
                throw new RQException(mm.getMessage("error.charset", dbCharset, toCharset));
            }
        }
        if (result != null && opt != null && opt.indexOf("l") > -1) {
            result = result.toLowerCase();
        }
        return result;
    }

    public static void cleanFieldName(String name, ArrayList<String> oldcns, ArrayList<String> cns, String tabName) {
        String result = name;
        String prefix = tabName == null ? "." : String.valueOf(tabName) + ".";
        int prelen = prefix.length();
        if (result.startsWith(prefix)) {
            oldcns.add(name);
            String result2 = result.substring(prelen);
            if (result2.length() < 1) {
                result2 = result;
            }
            result = result2;
        } else {
            name = String.valueOf(prefix) + name;
            oldcns.add(name);
        }
        int loc = cns.indexOf(result);
        if (loc > -1) {
            result = oldcns.get(loc);
            result = DatabaseUtil.removeSpecialSymbols(result, 0);
            cns.set(loc, result);
            result = name;
        }
        result = DatabaseUtil.removeSpecialSymbols(result, 0);
        cns.add(result);
    }

    private static String removeSpecialSymbols(String str, int start) {
        int strlen = str == null ? 0 : str.length();
        StringBuffer result = new StringBuffer(strlen);
        int i = start;
        while (i < strlen) {
            char ch = str.charAt(i);
            if (ch == '.' || ch == '-' || ch == '\'' || ch == '\"' || ch == '(' || ch == ')' || ch == '[' || ch == ']' || ch == '{' || ch == '}' || ch == '~' || ch == '+' || ch == '*' || ch == '/' || ch == '^' || ch == '%' || ch == '$' || ch == '=' || ch == '&' || ch == '|' || ch == '!') {
                result.append('_');
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    private static String[] getKeyNames(Connection conn, String tableName) {
        if (conn == null || tableName == null || tableName.trim().length() < 1) {
            return null;
        }
        ResultSet rs = null;
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            rs = dmd.getPrimaryKeys(conn.getCatalog(), null, tableName);
            int count = 0;
            ArrayList<String> nameList = new ArrayList<String>();
            ArrayList<Object> seqList = new ArrayList<Object>();
            while (rs.next()) {
                String keyName = rs.getString("COLUMN_NAME");
                Object seqObj = rs.getObject("KEY_SEQ");
                if (keyName == null || keyName.trim().length() <= 0) continue;
                nameList.add(keyName);
                seqList.add(seqObj);
                ++count;
            }
            if (count > 0) {
                Object[] names0 = nameList.toArray();
                if (names0 == null || names0.length < 1) {
                    return null;
                }
                String[] names = new String[count];
                int[] seqs = new int[count];
                int i = 0;
                while (i < count) {
                    seqs[i] = Integer.parseInt(seqList.get(i).toString());
                    names[i] = names0[i].toString();
                    ++i;
                }
                i = 0;
                while (i < count - 1) {
                    int j = 0;
                    while (j < count - 1 - i) {
                        if (seqs[j] > seqs[j + 1]) {
                            int tmp = seqs[j];
                            String tmps = names[j];
                            seqs[j] = seqs[j + 1];
                            names[j] = names[j + 1];
                            seqs[j + 1] = tmp;
                            names[j + 1] = tmps;
                        }
                        ++j;
                    }
                    ++i;
                }
                String[] stringArray = names;
                return stringArray;
            }
            return null;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public static Sequence select(String tableName, String str, Object[] keyValues, DBSession dbs, String opt) {
        return DatabaseUtil.select(tableName, str, null, keyValues, dbs, opt);
    }

    public static Sequence select(String tableName, String str, String[] keyNames, Object[] keyValues, DBSession dbs, String opt) {
        DBInfo info = dbs.getInfo();
        String dbName = "";
        if (info != null) {
            dbName = info.getName();
        }
        String sql = "select " + str;
        Connection con = null;
        try {
            Object session;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                throw new RQException(mm.getMessage("error.conClosed", dbName));
            }
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e);
        }
        if (keyNames == null) {
            keyNames = DatabaseUtil.getKeyNames(con, tableName);
        }
        if (keyNames == null) {
            return null;
        }
        int size = keyNames.length;
        String key = "";
        Object v = null;
        String condition = null;
        ArrayList<Object> params = new ArrayList<Object>();
        int i = 0;
        while (i < size) {
            key = keyNames[i];
            if (key != null && key.trim().length() > 0) {
                v = null;
                if (i < keyValues.length) {
                    v = keyValues[i];
                }
                if (condition == null) {
                    condition = "(" + key + " = ?)";
                    params.add(v);
                } else {
                    condition = String.valueOf(condition) + " and (" + key + " = ?)";
                    params.add(v);
                }
            }
            ++i;
        }
        if (condition == null || condition.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidCondition"));
        }
        sql = String.valueOf(sql) + " from " + DatabaseUtil.addTilde(tableName, dbs) + " where " + condition;
        return DatabaseUtil.retrieve2(sql, params.toArray(), null, dbs, opt);
    }

    public static Sequence select(String tableName, String[] strs, String[] keyNames, Object[] keyValues, DBSession dbs, String opt) {
        DBInfo info = dbs.getInfo();
        String dbName = "";
        if (info != null) {
            dbName = info.getName();
        }
        String sql = "select ";
        int size = strs.length;
        String fieldAll = null;
        String field = null;
        int i = 0;
        while (i < size) {
            field = strs[i];
            if (field != null && field.trim().length() > 0) {
                fieldAll = fieldAll == null ? field : String.valueOf(fieldAll) + ", " + field;
            }
            ++i;
        }
        if (fieldAll == null || fieldAll.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidFieldValue"));
        }
        Connection con = null;
        try {
            Object session;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                throw new RQException(mm.getMessage("error.conClosed", dbName));
            }
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e);
        }
        if (keyNames == null) {
            keyNames = DatabaseUtil.getKeyNames(con, tableName);
        }
        if (keyNames == null) {
            return null;
        }
        size = keyNames.length;
        String key = "";
        Object v = null;
        String condition = null;
        ArrayList<Object> params = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < size) {
            key = keyNames[i2];
            if (key != null && key.trim().length() > 0) {
                v = null;
                if (i2 < keyValues.length) {
                    v = keyValues[i2];
                }
                if (condition == null) {
                    condition = "(" + key + " = ?)";
                    params.add(v);
                } else {
                    condition = String.valueOf(condition) + " and (" + key + " = ?)";
                    params.add(v);
                }
            }
            ++i2;
        }
        if (condition == null || condition.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidCondition"));
        }
        sql = String.valueOf(sql) + fieldAll + " from " + DatabaseUtil.addTilde(tableName, dbs) + " where " + condition;
        return DatabaseUtil.retrieve2(sql, params.toArray(), null, dbs, opt);
    }

    public static Sequence select(String tableName, String[] strs, Object[] keyValues, DBSession dbs, String opt) {
        return DatabaseUtil.select(tableName, strs, null, keyValues, dbs, opt);
    }

    private static Sequence retrieve2(String sql, Object[] params, byte[] types, DBSession dbs, String opt) {
        ResultSet rs = null;
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        try {
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            byte[] argTypes = null;
            if (paramCount > 0) {
                args = new Object[paramCount];
                argTypes = new byte[paramCount];
                int pos = 0;
                int paramIndex = 0;
                while (paramIndex < paramCount) {
                    pos = Sentence.indexOf(sql, "?", pos + 1, 18);
                    args[paramIndex] = params[paramIndex];
                    argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                    if (args[paramIndex] != null) {
                        if (args[paramIndex] instanceof Sequence && tranContent) {
                            Sequence l = (Sequence)args[paramIndex];
                            int i = 1;
                            int size = l.length();
                            while (i <= size) {
                                Object o = l.get(i);
                                if (o instanceof String && tranSQL) {
                                    o = new String(((String)o).getBytes(), dbCharset);
                                    l.set(i, o);
                                }
                                ++i;
                            }
                        } else if (args[paramIndex] instanceof String && tranSQL) {
                            args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                        }
                        if (args[paramIndex] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[paramIndex]).toArray();
                            int objCount = objs.length;
                            StringBuffer sb = new StringBuffer(2 * objCount);
                            int iObj = 0;
                            while (iObj < objCount) {
                                sb.append("?,");
                                ++iObj;
                            }
                            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                                sb.deleteCharAt(sb.length() - 1);
                            }
                            if (sb.length() > 1) {
                                sql = String.valueOf(sql.substring(0, pos)) + sb.toString() + sql.substring(pos + 1);
                            }
                            pos += sb.length();
                        }
                    }
                    ++paramIndex;
                }
            }
            try {
                pst = con.prepareStatement(sql);
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name2 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name2 = info.getName();
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name2, sql)) + " : " + e.getMessage(), e);
            }
            if (args != null && args.length > 0) {
                int pos = 0;
                int iArg = 0;
                while (iArg < args.length) {
                    ++pos;
                    try {
                        byte type = argTypes[iArg];
                        if (args[iArg] != null && args[iArg] instanceof Sequence) {
                            Object[] objs = ((Sequence)args[iArg]).toArray();
                            int iObj = 0;
                            while (iObj < objs.length) {
                                SQLTool.setObject(dbType, (PreparedStatement)pst, pos, objs[iObj], type);
                                ++pos;
                                ++iObj;
                            }
                            --pos;
                        } else {
                            SQLTool.setObject(dbType, (PreparedStatement)pst, pos, args[iArg], type);
                        }
                    }
                    catch (Exception e) {
                        String name3 = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            name3 = info.getName();
                        }
                        throw new RQException(mm.getMessage("error.argIndex", name3, Integer.toString(iArg + 1)));
                    }
                    ++iArg;
                }
            }
            try {
                rs = pst.executeQuery();
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                String name4 = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name4 = info.getName();
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name4, sql)) + " : " + e.getMessage(), e);
            }
            Sequence sequence = DatabaseUtil.populate2(rs, dbCharset, tranContent, toCharset, dbType, opt);
            return sequence;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    private static Sequence populate2(ResultSet rs, String dbCharset, boolean needTranContent, String toCharset, int dbType, String opt) throws SQLException, UnsupportedEncodingException {
        if (rs == null) {
            return null;
        }
        ResultSetMetaData rsmd = rs.getMetaData();
        int colCount = rsmd.getColumnCount();
        if (needTranContent && (toCharset == null || toCharset.trim().length() == 0)) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.toCharset"));
        }
        boolean bb = true;
        if (toCharset != null) {
            bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
        }
        Sequence series = new Sequence();
        int size = 0;
        Object value = null;
        while (rs.next()) {
            if (colCount == 1) {
                int type = 0;
                if (dbType == 1) {
                    type = rsmd.getColumnType(1);
                }
                try {
                    value = DatabaseUtil.tranData(type, dbType, rs, 1, needTranContent, dbCharset, toCharset, bb, opt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                series.add(value);
            } else {
                Sequence sub = new Sequence();
                int n = 1;
                while (n <= colCount) {
                    int type = 0;
                    if (dbType == 1) {
                        type = rsmd.getColumnType(n);
                    }
                    try {
                        Object obj = DatabaseUtil.tranData(type, dbType, rs, n, needTranContent, dbCharset, toCharset, bb, opt);
                        sub.add(obj);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++n;
                }
                value = sub;
                series.add(value);
            }
            ++size;
        }
        if (size < 2) {
            Sequence ser = new Sequence();
            ser.add(value);
            return ser;
        }
        return series;
    }

    public static Object update(String tableName, String str, Object[] params, byte[] types, Object[] keyValues, DBSession dbs) {
        MessageManager mm;
        if (tableName == null || tableName.trim().length() < 1) {
            MessageManager mm2 = DataSetMessage.get();
            throw new RQException(mm2.getMessage("error.invalidTable"));
        }
        Connection con = null;
        String[] keyNames = null;
        try {
            Object session;
            mm = DataSetMessage.get();
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                String dbName = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    dbName = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", dbName));
            }
            keyNames = DatabaseUtil.getKeyNames(con, tableName);
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e);
        }
        if (keyNames == null) {
            return null;
        }
        if (keyNames == null || keyNames.length < 1) {
            mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidKey"));
        }
        if (keyValues == null || keyValues.length < 1) {
            mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidKeyValue"));
        }
        int size = keyNames.length;
        String condition = null;
        String key = "";
        Object v = null;
        ArrayList<Object> conParams = new ArrayList<Object>();
        int i = 0;
        while (i < size) {
            key = keyNames[i];
            if (key != null && key.trim().length() > 0) {
                v = null;
                if (i < keyValues.length) {
                    v = keyValues[i];
                }
                if (condition == null) {
                    condition = "(" + key + " = ?)";
                    conParams.add(v);
                } else {
                    condition = String.valueOf(condition) + " and (" + key + " = ?)";
                    conParams.add(v);
                }
            }
            ++i;
        }
        if (condition == null || condition.trim().length() < 1) {
            MessageManager mm3 = DataSetMessage.get();
            throw new RQException(mm3.getMessage("error.invalidCondition"));
        }
        String sql = "select count(*) from " + DatabaseUtil.addTilde(tableName, dbs) + " where " + condition;
        Table se = DatabaseUtil.retrieve(sql, conParams.toArray(), null, dbs, null, -1);
        int n = ((Number)((BaseRecord)se.get(1)).getFieldValue(0)).intValue();
        ArrayList<Object> allParams = new ArrayList<Object>();
        if (n > 0) {
            if (str == null || str.trim().length() < 1) {
                MessageManager mm4 = DataSetMessage.get();
                throw new RQException(mm4.getMessage("error.invalidUpdateSQL"));
            }
            sql = "update " + DatabaseUtil.addTilde(tableName, dbs) + " set " + str + " where " + condition;
            DatabaseUtil.addParams(allParams, params);
            allParams.addAll(conParams);
        } else {
            String fieldAll = "";
            if (str == null || str.trim().length() < 1) {
                MessageManager mm5 = DataSetMessage.get();
                throw new RQException(mm5.getMessage("error.invalidUpdateSQL"));
            }
            sql = "insert into " + DatabaseUtil.addTilde(tableName, dbs) + " " + fieldAll + " values (" + str + " )";
            DatabaseUtil.addParams(allParams, params);
        }
        if (dbs != null) {
            return DatabaseUtil.runSQL(sql, allParams.toArray(), types, dbs, true, null);
        }
        String dbName = "";
        MessageManager mm6 = DataSetMessage.get();
        throw new RQException(mm6.getMessage("error.conClosed", dbName));
    }

    private static void addParams(ArrayList<Object> allParams, Object[] params) {
        if (params == null || params.length < 1) {
            return;
        }
        int i = 0;
        int iCount = params.length;
        while (i < iCount) {
            allParams.add(params[i]);
            ++i;
        }
    }

    public static Object update(String tableName, String[] strs, String[] keyNames, Object[] keyValues, DBSession dbs) {
        if (tableName == null || tableName.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidTable"));
        }
        if (keyNames == null || keyNames.length < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidKey"));
        }
        if (keyValues == null || keyValues.length < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidKeyValue"));
        }
        int size = strs.length;
        String str = null;
        int i = 0;
        while (i < size) {
            str = str == null ? strs[i] : String.valueOf(str) + strs[i];
            ++i;
        }
        size = keyNames.length;
        String condition = null;
        String key = "";
        Object v = null;
        ArrayList<Object> conParams = new ArrayList<Object>();
        int i2 = 0;
        while (i2 < size) {
            key = keyNames[i2];
            if (key != null && key.trim().length() > 0) {
                v = null;
                if (i2 < keyValues.length) {
                    v = keyValues[i2];
                }
                if (condition == null) {
                    condition = "(" + key + " = ?)";
                    conParams.add(v);
                } else {
                    condition = String.valueOf(condition) + " and (" + key + " = ?)";
                    conParams.add(v);
                }
            }
            ++i2;
        }
        if (condition == null || condition.trim().length() < 1) {
            MessageManager mm = DataSetMessage.get();
            throw new RQException(mm.getMessage("error.invalidCondition"));
        }
        String sql = "select count(*) from " + DatabaseUtil.addTilde(tableName, dbs) + " where " + condition;
        Table se = DatabaseUtil.retrieve(sql, null, null, dbs, null, -1);
        int n = ((Number)((BaseRecord)se.get(1)).getFieldValue(0)).intValue();
        if (n > 0) {
            if (str == null || str.trim().length() < 1) {
                MessageManager mm = DataSetMessage.get();
                throw new RQException(mm.getMessage("error.invalidUpdateSQL"));
            }
            sql = "update " + DatabaseUtil.addTilde(tableName, dbs) + " set " + str + " where " + condition;
        } else {
            String fieldAll = "";
            if (str == null || str.trim().length() < 1) {
                MessageManager mm = DataSetMessage.get();
                throw new RQException(mm.getMessage("error.invalidUpdateSQL"));
            }
            sql = "insert into " + DatabaseUtil.addTilde(tableName, dbs) + " " + fieldAll + " values (" + str + " )";
        }
        if (dbs != null) {
            return DatabaseUtil.runSQL(sql, conParams.toArray(), null, dbs, true, null);
        }
        String dbName = "";
        MessageManager mm = DataSetMessage.get();
        throw new RQException(mm.getMessage("error.conClosed", dbName));
    }

    public static Sequence proc(String sql, Object[] params, byte[] modes, byte[] types, String[] outVariables, DBSession dbs, Context ctx) {
        Statement pst = null;
        ResultSet rs = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        boolean hasOutParam = false;
        try {
            String outName;
            Object session;
            DBInfo dsInfo = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBInfo) {
                dsInfo = dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            String name = "";
            if (dsInfo != null) {
                name = dsInfo.getName();
            }
            if (con == null || con.isClosed()) {
                throw new RQException(mm.getMessage("error.conClosed", name));
            }
            if (dsInfo != null) {
                dbCharset = dsInfo.getDBCharset();
                tranSQL = dsInfo.getNeedTranSentence();
                tranContent = dsInfo.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    throw new RQException(mm.getMessage("error.fromCharset", name));
                }
                toCharset = dsInfo.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    throw new RQException(mm.getMessage("error.toCharset", name));
                }
                dbType = dsInfo.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            if (sql.trim().startsWith("call")) {
                sql = "{" + sql + "}";
            }
            if (tranSQL) {
                sql = new String(sql.getBytes(), dbCharset);
            }
            int paramCount = params == null ? 0 : params.length;
            Object[] args = null;
            int outCount = 0;
            int outCursor = 0;
            if (paramCount > 0) {
                args = new Object[paramCount];
                int pos = 0;
                int i = 0;
                while (i < paramCount) {
                    pos = Sentence.indexOf(sql, "?", pos + 1, 18);
                    byte mode = modes[i];
                    if (mode == PROC_MODE_OUT || mode == PROC_MODE_INOUT) {
                        hasOutParam = true;
                        if (types[i] != 101) {
                            ++outCount;
                        } else {
                            ++outCursor;
                        }
                    }
                    if (mode == PROC_MODE_IN || mode == PROC_MODE_INOUT) {
                        args[i] = params[i];
                        if (args[i] instanceof Sequence) {
                            Sequence l = (Sequence)args[i];
                            int count = l.length();
                            StringBuffer sb = new StringBuffer(2 * count);
                            int n = 0;
                            while (n < count) {
                                sb.append("?,");
                                ++n;
                            }
                            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                                sb.deleteCharAt(sb.length() - 1);
                            }
                            if (sb.length() > 1) {
                                sql = String.valueOf(sql.substring(0, pos)) + sb.toString() + sql.substring(pos + 1);
                            }
                            pos += sb.length();
                        }
                    }
                    ++i;
                }
            }
            int dsPos = -1;
            Sequence dsPosGroup = new Sequence();
            String[] outParams = new String[outCount];
            int[] outParamsIndex = new int[outCount];
            int outIndex = -1;
            String[] outTables = new String[outCursor];
            int cursorIndex = -1;
            if (hasOutParam) {
                try {
                    pst = con.prepareCall(sql);
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name, sql)) + " : " + e.getMessage(), e);
                }
            } else {
                try {
                    pst = con.prepareStatement(sql);
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name, sql)) + " : " + e.getMessage(), e);
                }
            }
            int paramIndex = 0;
            int iArg = 0;
            while (iArg < paramCount) {
                Object o;
                byte mode = modes[iArg];
                if (mode == PROC_MODE_IN) {
                    if (args[iArg] instanceof Sequence) {
                        Object o2;
                        int size;
                        Sequence l = (Sequence)args[iArg];
                        if (tranSQL) {
                            int i = 1;
                            size = l.length();
                            while (i <= size) {
                                o2 = l.get(i);
                                if (o2 instanceof String) {
                                    o2 = new String(((String)o2).getBytes(), dbCharset);
                                }
                                SQLTool.setObject(dbType, (PreparedStatement)pst, ++paramIndex, o2, types[iArg]);
                                ++i;
                            }
                        } else {
                            int i = 1;
                            size = l.length();
                            while (i <= size) {
                                o2 = l.get(i);
                                SQLTool.setObject(dbType, (PreparedStatement)pst, ++paramIndex, o2, types[iArg]);
                                ++i;
                            }
                        }
                    } else {
                        o = args[iArg];
                        if (tranSQL && o instanceof String) {
                            o = new String(((String)o).getBytes(), dbCharset);
                        }
                        SQLTool.setObject(dbType, (PreparedStatement)pst, ++paramIndex, o, types[iArg]);
                    }
                } else if (mode == PROC_MODE_OUT) {
                    ++paramIndex;
                    if (101 == types[iArg]) {
                        if (dbType == 1) {
                            try {
                                Class<?> c = Class.forName("oracle.jdbc.driver.OracleTypes");
                                Field f = c.getField("CURSOR");
                                ((CallableStatement)pst).registerOutParameter(paramIndex, f.getInt(null));
                            }
                            catch (Exception e) {
                                throw new RQException(mm.getMessage("error.cursorException"));
                            }
                            if (dsPos < 0) {
                                dsPos = paramIndex;
                            } else {
                                dsPosGroup.add(new Integer(paramIndex));
                            }
                            if (dsPos < 0) {
                                throw new RQException(mm.getMessage("error.noResultSet"));
                            }
                            outTables[++cursorIndex] = outVariables[iArg];
                        } else if (dbType == 15 || dbType == 20) {
                            ((CallableStatement)pst).registerOutParameter(paramIndex, 1111);
                            if (dsPos < 0) {
                                dsPos = paramIndex;
                            } else {
                                dsPosGroup.add(new Integer(paramIndex));
                            }
                            if (dsPos < 0) {
                                throw new RQException(mm.getMessage("error.noResultSet"));
                            }
                        }
                    } else {
                        outParams[++outIndex] = outVariables[iArg];
                        outParamsIndex[outIndex] = paramIndex;
                        DatabaseUtil.registerOtherParameter((CallableStatement)pst, paramIndex, types[iArg], mm);
                    }
                } else {
                    o = args[iArg];
                    if (tranContent && o instanceof String) {
                        o = new String(((String)o).getBytes(), dbCharset);
                    }
                    SQLTool.setObject(dbType, (PreparedStatement)pst, ++paramIndex, o, types[iArg]);
                    outParams[++outIndex] = outVariables[iArg];
                    outParamsIndex[outIndex] = paramIndex;
                    DatabaseUtil.registerOtherParameter((CallableStatement)pst, paramIndex, types[iArg], mm);
                }
                ++iArg;
            }
            if (hasOutParam) {
                if ((dbType == 15 || dbType == 20) && dsPos > 0) {
                    ((CallableStatement)pst).execute();
                } else {
                    rs = ((CallableStatement)pst).executeQuery();
                }
                try {
                    int i = 0;
                    int count = outParams.length;
                    while (i < count) {
                        Object value = ((CallableStatement)pst).getObject(outParamsIndex[i]);
                        ctx.setParamValue(outParams[i], value);
                        ++i;
                    }
                }
                catch (Exception e) {
                    throw new RQException(mm.getMessage("error.outParam"));
                }
            }
            try {
                if (dbType == 1 && dsPos > 0) {
                    rs = (ResultSet)((CallableStatement)pst).getObject(dsPos);
                } else if ((dbType == 15 || dbType == 20) && dsPos > 0) {
                    rs = (ResultSet)((CallableStatement)pst).getObject(dsPos);
                } else if (!hasOutParam) {
                    rs = pst.executeQuery();
                }
            }
            catch (SQLException e) {
                if (dbs.getErrorMode()) {
                    dbs.setError(e);
                }
                throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name, sql)) + " : " + e.getMessage(), e);
            }
            if (dsInfo == null) {
                tranContent = false;
            }
            Table se = DatabaseUtil.populate(rs, dbCharset, tranContent, toCharset, dbType, false, null, false, -1, null);
            if (outCursor > 0 && (outName = outTables[0]) != null && outName.trim().length() > 0) {
                ctx.setParamValue(outName, se);
            }
            if (dsPosGroup.length() > 0) {
                Sequence mul_dataset = new Sequence();
                mul_dataset.add(se);
                int size = dsPosGroup.length();
                int i = 0;
                while (i < size) {
                    int loc = (Integer)dsPosGroup.get(i + 1);
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    try {
                        rs = (ResultSet)((CallableStatement)pst).getObject(loc);
                    }
                    catch (SQLException e) {
                        if (dbs.getErrorMode()) {
                            dbs.setError(e);
                        }
                        throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name, sql)) + " : " + e.getMessage(), e);
                    }
                    Table se_add = DatabaseUtil.populate(rs, dbCharset, tranContent, toCharset, dbType, false, null, false, -1, null);
                    mul_dataset.add(se_add);
                    if (outCursor > 0) {
                        String outName2 = null;
                        if (i < outTables.length - 1) {
                            outName2 = outTables[i + 1];
                        }
                        if (outName2 != null && outName2.trim().length() > 0) {
                            ctx.setParamValue(outName2, se_add);
                        }
                    }
                    ++i;
                }
                if (mul_dataset.length() > 1) {
                    Sequence sequence = mul_dataset;
                    return sequence;
                }
            } else if (pst.getMoreResults()) {
                Sequence mul_dataset = new Sequence();
                mul_dataset.add(se);
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                rs = pst.getResultSet();
                Table se_add = DatabaseUtil.populate(rs, dbCharset, tranContent, toCharset, dbType, false, null, false, -1, null);
                mul_dataset.add(se_add);
                boolean more = pst.getMoreResults();
                while (more || pst.getUpdateCount() != -1) {
                    if (!more) {
                        more = pst.getMoreResults();
                        continue;
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    rs = pst.getResultSet();
                    se_add = DatabaseUtil.populate(rs, dbCharset, tranContent, toCharset, dbType, false, null, false, -1, null);
                    mul_dataset.add(se_add);
                    more = pst.getMoreResults();
                }
                if (mul_dataset.length() > 1) {
                    Sequence sequence = mul_dataset;
                    return sequence;
                }
            }
            Table table = se;
            return table;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    public static void registerOtherParameter(CallableStatement cst, int paramIndex, int type, MessageManager mm) {
        try {
            switch (type) {
                case 11: 
                case 61: {
                    cst.registerOutParameter(paramIndex, 12);
                    break;
                }
                case 6: 
                case 56: {
                    cst.registerOutParameter(paramIndex, 8);
                    break;
                }
                case 1: 
                case 51: {
                    cst.registerOutParameter(paramIndex, 4);
                    break;
                }
                case 8: 
                case 58: {
                    cst.registerOutParameter(paramIndex, 91);
                    break;
                }
                case 9: 
                case 59: {
                    cst.registerOutParameter(paramIndex, 92);
                    break;
                }
                case 10: 
                case 60: {
                    cst.registerOutParameter(paramIndex, 93);
                    break;
                }
                case 2: 
                case 4: 
                case 52: 
                case 54: {
                    cst.registerOutParameter(paramIndex, -5);
                    break;
                }
                case 3: 
                case 53: {
                    cst.registerOutParameter(paramIndex, 5);
                    break;
                }
                case 5: 
                case 55: {
                    cst.registerOutParameter(paramIndex, 6);
                    break;
                }
                case 7: 
                case 57: {
                    cst.registerOutParameter(paramIndex, 3);
                    break;
                }
                default: {
                    cst.registerOutParameter(paramIndex, 12);
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new RQException(mm.getMessage("error.regParam", Integer.toString(paramIndex)));
        }
    }

    private static String addTilde(String field, DBSession dbs) {
        DBConfig dbc;
        if (dbs != null && dbs.getInfo() instanceof DBConfig && (dbc = (DBConfig)dbs.getInfo()).isAddTilde()) {
            int dbType = dbc.getDBType();
            field = String.valueOf(DBTypes.getLeftTilde(dbType)) + field + DBTypes.getRightTilde(dbType);
        }
        return field;
    }

    private static String removeTilde(String field, DBSession dbs) {
        DBConfig dbc;
        if (field == null || field.trim().length() < 1) {
            return field;
        }
        if (dbs != null && dbs.getInfo() instanceof DBConfig && (dbc = (DBConfig)dbs.getInfo()).isAddTilde()) {
            int dbType = dbc.getDBType();
            if (field.substring(0, 1).equals(DBTypes.getLeftTilde(dbType))) {
                field = field.substring(1);
            }
            if (field.substring(field.length() - 1).equals(DBTypes.getRightTilde(dbType))) {
                field = field.substring(0, field.length() - 1);
            }
        }
        return field;
    }

    public static Table queryGroup(String inisql, Object[][] valueGroup, byte[] types, DBSession dbs, String opt, Context ctx) {
        ResultSet rs = null;
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        try {
            String name;
            Object session;
            DBConfig dsConfig = null;
            MessageManager mm = DataSetMessage.get();
            if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                dsConfig = (DBConfig)dbs.getInfo();
            }
            if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                con = (Connection)session;
            }
            if (con == null || con.isClosed()) {
                name = "";
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    name = info.getName();
                }
                throw new RQException(mm.getMessage("error.conClosed", name));
            }
            if (dsConfig != null) {
                dbCharset = dsConfig.getDBCharset();
                tranSQL = dsConfig.getNeedTranSentence();
                tranContent = dsConfig.getNeedTranContent();
                if ((tranContent || tranSQL) && dbCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.fromCharset", name));
                }
                toCharset = dsConfig.getClientCharset();
                if ((tranContent || tranSQL) && toCharset == null) {
                    name = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name = info.getName();
                    }
                    throw new RQException(mm.getMessage("error.toCharset", name));
                }
                dbType = dsConfig.getDBType();
            } else {
                tranContent = false;
            }
            if (tranSQL) {
                inisql = new String(inisql.getBytes(), dbCharset);
            }
            Table table = null;
            boolean addTable = false;
            if (opt != null && opt.indexOf("f") > -1) {
                addTable = true;
            }
            boolean oneRecord = false;
            if (opt != null && opt.indexOf("1") > -1) {
                oneRecord = true;
            }
            int queryCount = valueGroup == null ? 0 : valueGroup.length;
            int qi = 0;
            while (qi < queryCount) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        rs = null;
                    }
                    if (pst != null) {
                        pst.close();
                        pst = null;
                    }
                }
                catch (Exception e) {
                    throw new RQException(e.getMessage(), e);
                }
                String sql = inisql;
                Object[] params = valueGroup[qi];
                int paramCount = params == null ? 0 : params.length;
                Object[] args = null;
                byte[] argTypes = null;
                if (paramCount > 0) {
                    args = new Object[paramCount];
                    argTypes = new byte[paramCount];
                    int pos = 0;
                    int paramIndex = 0;
                    while (paramIndex < paramCount) {
                        pos = Sentence.indexOf(sql, "?", pos + 1, 18);
                        args[paramIndex] = params[paramIndex];
                        argTypes[paramIndex] = types == null || types.length <= paramIndex ? (byte)0 : types[paramIndex];
                        if (args[paramIndex] != null) {
                            if (args[paramIndex] instanceof Sequence && tranContent) {
                                Sequence l = (Sequence)args[paramIndex];
                                int i = 1;
                                int size = l.length();
                                while (i <= size) {
                                    Object o = l.get(i);
                                    if (o instanceof String && tranSQL) {
                                        o = new String(((String)o).getBytes(), dbCharset);
                                        l.set(i, o);
                                    }
                                    ++i;
                                }
                            } else if (args[paramIndex] instanceof String && tranSQL) {
                                args[paramIndex] = new String(((String)args[paramIndex]).getBytes(), dbCharset);
                            }
                            if (args[paramIndex] instanceof Sequence) {
                                Object[] objs = ((Sequence)args[paramIndex]).toArray();
                                int objCount = objs.length;
                                StringBuffer sb = new StringBuffer(2 * objCount);
                                int iObj = 0;
                                while (iObj < objCount) {
                                    sb.append("?,");
                                    ++iObj;
                                }
                                if (sb.length() > 0 && sb.charAt(sb.length() - 1) == ',') {
                                    sb.deleteCharAt(sb.length() - 1);
                                }
                                if (sb.length() > 1) {
                                    sql = String.valueOf(sql.substring(0, pos)) + sb.toString() + sql.substring(pos + 1);
                                }
                                pos += sb.length();
                            }
                        }
                        ++paramIndex;
                    }
                }
                try {
                    pst = con.prepareStatement(sql);
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    String name2 = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name2 = info.getName();
                    }
                    throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name2, sql)) + " : " + e.getMessage(), e);
                }
                if (args != null && args.length > 0) {
                    int pos = 0;
                    int iArg = 0;
                    while (iArg < args.length) {
                        ++pos;
                        try {
                            byte type = argTypes[iArg];
                            if (args[iArg] != null && args[iArg] instanceof Sequence) {
                                Object[] objs = ((Sequence)args[iArg]).toArray();
                                int iObj = 0;
                                while (iObj < objs.length) {
                                    SQLTool.setObject(dbType, (PreparedStatement)pst, pos, objs[iObj], type);
                                    ++pos;
                                    ++iObj;
                                }
                                --pos;
                            } else {
                                SQLTool.setObject(dbType, (PreparedStatement)pst, pos, args[iArg], type);
                            }
                        }
                        catch (Exception e) {
                            String name3 = "";
                            DBInfo info = dbs.getInfo();
                            if (info != null) {
                                name3 = info.getName();
                            }
                            throw new RQException(mm.getMessage("error.argIndex", name3, Integer.toString(iArg + 1)));
                        }
                        ++iArg;
                    }
                }
                try {
                    rs = pst.executeQuery();
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    String name4 = "";
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        name4 = info.getName();
                    }
                    throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name4, sql)) + " : " + e.getMessage(), e);
                }
                if (oneRecord) {
                    Table table2 = DatabaseUtil.populate(rs, dbCharset, tranContent, toCharset, dbType, addTable, table, oneRecord, -1, opt);
                    return table2;
                }
                table = DatabaseUtil.populate(rs, dbCharset, tranContent, toCharset, dbType, addTable, table, oneRecord, -1, opt);
                ++qi;
            }
            Table table3 = table;
            return table3;
        }
        catch (RQException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    private static byte[] toByteArray(ArrayList<Byte> bytes) {
        byte[] rs = new byte[bytes.size()];
        int i = 0;
        for (byte obj : bytes) {
            rs[i++] = obj;
        }
        return rs;
    }

    public static int update(ICursor cs, String table, String[] fields, String[] fopts, Expression[] exps, String opt, DBSession dbs, Context ctx) {
        Statement st = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        int fsize = fields.length;
        String field = "";
        String fieldAll = null;
        String dbName = "";
        int batchSize = 1000;
        Statement pst = null;
        try {
            try {
                Sequence fetchSeq;
                DBConfig dsConfig = null;
                if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                    dsConfig = (DBConfig)dbs.getInfo();
                }
                MessageManager mm = DataSetMessage.get();
                if (dbs != null) {
                    Object session = dbs.getSession();
                    if (session instanceof Connection) {
                        con = (Connection)session;
                    }
                    if ((batchSize = dsConfig.getBatchSize()) < 1) {
                        batchSize = 1;
                    }
                    dbCharset = dsConfig.getDBCharset();
                    tranSQL = dsConfig.getNeedTranSentence();
                    tranContent = dsConfig.getNeedTranContent();
                    if ((tranContent || tranSQL) && dbCharset == null) {
                        throw new RQException(mm.getMessage("error.fromCharset", dbName));
                    }
                    toCharset = dsConfig.getClientCharset();
                    if ((tranContent || tranSQL) && toCharset == null) {
                        throw new RQException(mm.getMessage("error.toCharset", dbName));
                    }
                    dbType = dsConfig.getDBType();
                } else {
                    tranContent = false;
                }
                DBInfo info = dbs.getInfo();
                if (info != null) {
                    dbName = info.getName();
                }
                if (con == null || con.isClosed()) {
                    throw new RQException(mm.getMessage("error.conClosed", dbName));
                }
                boolean bb = true;
                if (toCharset != null) {
                    bb = toCharset.equalsIgnoreCase(dbCharset) || dbCharset == null;
                }
                ResultSet rs = null;
                byte[] tColTypes = null;
                ArrayList<Integer> keyCols = new ArrayList<Integer>();
                ArrayList<String> autoKeys = new ArrayList<String>();
                boolean initial = true;
                byte[] ais = new byte[fsize];
                if (fopts != null) {
                    int osize = fopts.length;
                    if (osize > fsize) {
                        osize = fsize;
                    }
                    int i = 0;
                    while (i < osize) {
                        String fopt = fopts[i];
                        if (fopt != null) {
                            if (fopt.indexOf("p") > -1) {
                                keyCols.add(new Integer(i));
                            }
                            if (fopt.indexOf("a") > -1) {
                                ais[i] = 1;
                                autoKeys.add(fields[i]);
                            } else {
                                ais[i] = 0;
                            }
                        }
                        ++i;
                    }
                }
                int[] kis = null;
                int keysize = keyCols.size();
                String check_sql = "";
                String update_sql = "";
                String insert_sql = "";
                while ((fetchSeq = cs.fetch(batchSize)) != null) {
                    String sql;
                    int ki;
                    if (fetchSeq.length() == 0) {
                        break;
                    }
                    if (initial) {
                        if (keysize < 1) {
                            Object o1 = fetchSeq.get(1);
                            if (o1 instanceof BaseRecord) {
                                DataStruct ds1 = ((BaseRecord)o1).dataStruct();
                                String[] keys = ds1.getPrimary();
                                int kc = keys == null ? 0 : keys.length;
                                int i = 0;
                                while (i < kc) {
                                    String key = keys[i];
                                    if (key != null) {
                                        ki = -1;
                                        int j = 0;
                                        while (j < fsize) {
                                            if (key.equalsIgnoreCase(fields[j])) {
                                                ki = j;
                                                break;
                                            }
                                            ++j;
                                        }
                                        if (ki > -1) {
                                            keyCols.add(new Integer(ki));
                                        }
                                    }
                                    ++i;
                                }
                            }
                            keysize = keyCols.size();
                        }
                        if (tColTypes == null || tColTypes.length < 1 || keysize < 1) {
                            sql = "select";
                            int i = 0;
                            int iSize = fields.length;
                            while (i < iSize) {
                                sql = String.valueOf(sql) + " " + DatabaseUtil.addTilde(fields[i], dbs);
                                if (i < iSize - 1) {
                                    sql = String.valueOf(sql) + ",";
                                }
                                ++i;
                            }
                            sql = String.valueOf(sql) + " from " + DatabaseUtil.addTilde(table, dbs) + " where 1 = 0";
                            try {
                                try {
                                    pst = con.prepareStatement(sql);
                                    rs = pst.executeQuery();
                                    ResultSetMetaData rsmd = rs.getMetaData();
                                    int colSize = rsmd.getColumnCount();
                                    tColTypes = new byte[fsize];
                                    int ci = 0;
                                    while (ci < colSize) {
                                        String colname = rsmd.getColumnLabel(ci + 1);
                                        if ((colname = DatabaseUtil.tranName(colname, tranContent, dbCharset, toCharset, bb, opt)) != null && colname.trim().length() >= 1) {
                                            int fi = 0;
                                            while (fi < fsize) {
                                                if (colname.equalsIgnoreCase(fields[fi])) {
                                                    byte rqType;
                                                    int sqlType = rsmd.getColumnType(ci + 1);
                                                    tColTypes[fi] = rqType = Types.getTypeBySQLType(sqlType);
                                                    break;
                                                }
                                                ++fi;
                                            }
                                        }
                                        ++ci;
                                    }
                                    if (keysize < 1) {
                                        String[] tns;
                                        if (table.indexOf(".") > 0 && ((tns = table.split("\\.")) == null || tns.length < 2)) {
                                            int loc = table.indexOf(".");
                                            tns = new String[]{table.substring(0, loc), table.substring(loc + 1)};
                                        }
                                        try {
                                            while (rs.next()) {
                                                String columnName = rs.getString("COLUMN_NAME");
                                                if (columnName == null) continue;
                                                int ki2 = -1;
                                                int i2 = 0;
                                                while (i2 < fsize) {
                                                    if (columnName.equalsIgnoreCase(fields[i2])) {
                                                        ki2 = i2;
                                                        break;
                                                    }
                                                    ++i2;
                                                }
                                                if (ki2 <= -1) continue;
                                                keyCols.add(new Integer(ki2));
                                            }
                                            keysize = keyCols.size();
                                        }
                                        catch (Exception columnName) {}
                                    }
                                }
                                catch (Exception e) {
                                    throw new RQException(e.getMessage(), e);
                                }
                            }
                            finally {
                                try {
                                    if (rs != null) {
                                        rs.close();
                                    }
                                    if (pst != null) {
                                        pst.close();
                                    }
                                }
                                catch (Exception e) {
                                    throw new RQException(e.getMessage(), e);
                                }
                                rs = null;
                            }
                        }
                        if (keysize < 1) {
                            keyCols.add(new Integer(0));
                            keysize = keyCols.size();
                        }
                        Expression[] keyExps = null;
                        kis = new int[keysize];
                        keyExps = new Expression[keysize];
                        int i = 0;
                        while (i < keysize) {
                            kis[i] = (Integer)keyCols.get(i);
                            keyExps[i] = exps[kis[i]];
                            ++i;
                        }
                        int iField = 0;
                        while (iField < fsize) {
                            if (ais[iField] != 1 && (field = fields[iField]) != null && field.trim().length() > 0) {
                                fieldAll = fieldAll == null ? "(" + field : String.valueOf(fieldAll) + ", " + field;
                            }
                            ++iField;
                        }
                        if (fieldAll == null || fieldAll.trim().length() < 1) {
                            throw new RQException(mm.getMessage("error.invalidField"));
                        }
                        fieldAll = String.valueOf(fieldAll) + ")";
                    }
                    try {
                        if (initial) {
                            if (opt != null && opt.indexOf("a") > -1) {
                                Logger.debug(mm.getMessage("info.clearTable", table));
                                sql = "delete from " + DatabaseUtil.addTilde(table, dbs);
                                st = con.createStatement();
                                st.execute(sql);
                                st.close();
                            }
                            String condition = null;
                            String key = "";
                            int j = 0;
                            while (j < keysize) {
                                key = fields[kis[j]];
                                if (key != null && key.trim().length() > 0) {
                                    condition = condition == null ? "(" + key + " = ?)" : String.valueOf(condition) + " and (" + key + " = ?)";
                                }
                                ++j;
                            }
                            check_sql = "select count(*) from " + DatabaseUtil.addTilde(table, dbs) + " where " + condition;
                            String sets = null;
                            int iField = 0;
                            while (iField < fsize) {
                                if (ais[iField] != 1 && (field = fields[iField]) != null && field.trim().length() > 0) {
                                    sets = sets == null ? String.valueOf(field) + " = ?" : String.valueOf(sets) + ", " + field + " = ?";
                                }
                                ++iField;
                            }
                            if (sets == null || sets.trim().length() < 1) {
                                throw new RQException(mm.getMessage("error.invalidField"));
                            }
                            update_sql = "update " + DatabaseUtil.addTilde(table, dbs) + " set " + sets + " where " + condition;
                            sets = null;
                            iField = 0;
                            while (iField < fsize) {
                                if (ais[iField] != 1 && (field = fields[iField]) != null && field.trim().length() > 0) {
                                    if (sets == null) {
                                        fieldAll = "(" + field;
                                        sets = "( ?";
                                    } else {
                                        fieldAll = String.valueOf(fieldAll) + ", " + field;
                                        sets = String.valueOf(sets) + ", ?";
                                    }
                                }
                                ++iField;
                            }
                            if (sets == null || sets.trim().length() < 1) {
                                throw new RQException(mm.getMessage("error.invalidFieldValue"));
                            }
                            sets = String.valueOf(sets) + " )";
                            if (fieldAll == null || fieldAll.trim().length() < 1) {
                                throw new RQException(mm.getMessage("error.invalidField"));
                            }
                            fieldAll = String.valueOf(fieldAll) + " )";
                            insert_sql = "insert into " + DatabaseUtil.addTilde(table, dbs) + " " + fieldAll + " values " + sets;
                            if (tranSQL) {
                                check_sql = new String(check_sql.getBytes(), dbCharset);
                                update_sql = new String(update_sql.getBytes(), dbCharset);
                                insert_sql = new String(insert_sql.getBytes(), dbCharset);
                            }
                        }
                        ArrayList<Expression> updateParams = new ArrayList<Expression>();
                        ArrayList<Expression> primaryParams = new ArrayList<Expression>();
                        ArrayList<Expression> insertParams = new ArrayList<Expression>();
                        ArrayList<Byte> updateTypes = new ArrayList<Byte>();
                        ArrayList<Byte> primaryTypes = new ArrayList<Byte>();
                        ArrayList<Byte> insertTypes = new ArrayList<Byte>();
                        int iField = 0;
                        while (iField < fsize) {
                            if (ais[iField] != 1) {
                                insertParams.add(exps[iField]);
                                insertTypes.add((byte)tColTypes[iField]);
                            }
                            ++iField;
                        }
                        ki = 0;
                        while (ki < keysize) {
                            primaryParams.add(exps[kis[ki]]);
                            primaryTypes.add(tColTypes[kis[ki]]);
                            ++ki;
                        }
                        updateParams.addAll(insertParams);
                        updateTypes.addAll(insertTypes);
                        updateParams.addAll(primaryParams);
                        updateTypes.addAll(primaryTypes);
                        boolean isAutoDetect = true;
                        if (opt != null) {
                            if (opt.indexOf(105) > -1) {
                                if (initial) {
                                    try {
                                        Logger.debug(mm.getMessage("info.insertOnly", insert_sql));
                                        pst = con.prepareStatement(insert_sql);
                                    }
                                    catch (SQLException e) {
                                        if (dbs.getErrorMode()) {
                                            dbs.setError(e);
                                        }
                                        throw new RQException(String.valueOf(mm.getMessage("error.sqlException", dbName, insert_sql)) + " : " + e.getMessage(), e);
                                    }
                                }
                                DatabaseUtil.executeBatchPst(fetchSeq, (PreparedStatement)pst, insertParams, insertTypes, ctx, dbs, dbCharset, tranSQL, dbType, dbName);
                                isAutoDetect = false;
                            } else if (opt.indexOf(117) > -1) {
                                if (initial) {
                                    try {
                                        Logger.debug(mm.getMessage("info.updateOnly", update_sql));
                                        pst = con.prepareStatement(update_sql);
                                    }
                                    catch (SQLException e) {
                                        if (dbs.getErrorMode()) {
                                            dbs.setError(e);
                                        }
                                        throw new RQException(String.valueOf(mm.getMessage("error.sqlException", dbName, update_sql)) + " : " + e.getMessage(), e);
                                    }
                                }
                                DatabaseUtil.executeBatchPst(fetchSeq, (PreparedStatement)pst, updateParams, updateTypes, ctx, dbs, dbCharset, tranSQL, dbType, dbName);
                                isAutoDetect = false;
                            }
                        }
                        if (initial) {
                            initial = false;
                        }
                        if (!isAutoDetect) continue;
                        Expression[] expParams = new Expression[primaryParams.size()];
                        primaryParams.toArray(expParams);
                        Sequence recordCount = DatabaseUtil.query(fetchSeq, check_sql, expParams, DatabaseUtil.toByteArray(primaryTypes), opt, ctx, dbs, null, null, keysize);
                        Sequence updateRecords = new Sequence();
                        Sequence insertRecords = new Sequence();
                        int rsize = recordCount == null ? 0 : recordCount.length();
                        int i = 1;
                        while (i <= rsize) {
                            BaseRecord r = (BaseRecord)recordCount.get(i);
                            int c = ((Number)r.getFieldValue(0)).intValue();
                            if (c > 0) {
                                updateRecords.add(fetchSeq.get(i));
                            } else {
                                insertRecords.add(fetchSeq.get(i));
                            }
                            ++i;
                        }
                        if (updateRecords.length() > 0) {
                            Logger.debug(mm.getMessage("info.autoUpdate", update_sql));
                            DatabaseUtil.executeBatchSql(updateRecords, update_sql, updateParams, updateTypes, ctx, dbs);
                        }
                        if (insertRecords.length() <= 0) continue;
                        Logger.debug(mm.getMessage("info.autoInsert", insert_sql));
                        DatabaseUtil.executeBatchSql(insertRecords, insert_sql, insertParams, insertTypes, ctx, dbs);
                    }
                    catch (RQException e) {
                        Logger.debug(mm.getMessage("error.update", e.getMessage()));
                        if (!dbs.getErrorMode()) continue;
                        dbs.setError(new SQLException(e.getMessage(), "Error: 5001 Update error: ", 5001));
                    }
                }
            }
            catch (RQException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (opt == null || opt.indexOf(107) < 0) {
                    con.commit();
                }
                if (st != null) {
                    st.close();
                }
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        return 0;
    }

    public static int update(Sequence srcSeq, Sequence compSeq, String table, String[] fields, String[] fopts, Expression[] exps, String opt, DBSession dbs, Context ctx) {
        boolean oClear = false;
        if (opt != null && opt.indexOf("a") > -1) {
            oClear = true;
        }
        if (!oClear && compSeq != null) {
            compSeq.length();
        }
        Statement st = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        int fsize = fields.length;
        String field = "";
        String fieldAll = null;
        String dbn = "";
        int batchSize = 1000;
        try {
            try {
                Object session;
                DBConfig dsConfig = null;
                if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                    dsConfig = (DBConfig)dbs.getInfo();
                }
                if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                    con = (Connection)session;
                }
                if (con == null || con.isClosed()) {
                    DBInfo info = dbs.getInfo();
                    if (info != null) {
                        dbn = info.getName();
                    }
                    MessageManager mm = DataSetMessage.get();
                    throw new RQException(mm.getMessage("error.conClosed", dbn));
                }
                boolean bb = true;
                ResultSet rs = null;
                byte[] tColTypes = null;
                ArrayList<Integer> keyCols = new ArrayList<Integer>();
                ArrayList<String> autoKeys = new ArrayList<String>();
                byte[] ais = new byte[fsize];
                if (fopts != null) {
                    int osize = fopts.length;
                    if (osize > fsize) {
                        osize = fsize;
                    }
                    int i = 0;
                    while (i < osize) {
                        String fopt = fopts[i];
                        if (fopt != null) {
                            if (fopt.indexOf("p") > -1) {
                                keyCols.add(new Integer(i));
                            }
                            if (fopt.indexOf("a") > -1) {
                                ais[i] = 1;
                                autoKeys.add(fields[i]);
                            } else {
                                ais[i] = fopt.indexOf("p") > -1 ? Col_NormalKey : (byte)0;
                            }
                        }
                        ++i;
                    }
                }
                int[] kis = null;
                int keysize = keyCols.size();
                if (tColTypes == null || tColTypes.length < 1 || keysize < 1) {
                    String sql = "select";
                    int i = 0;
                    int iSize = fields.length;
                    while (i < iSize) {
                        sql = String.valueOf(sql) + " " + DatabaseUtil.addTilde(fields[i], dbs);
                        if (i < iSize - 1) {
                            sql = String.valueOf(sql) + ",";
                        }
                        ++i;
                    }
                    sql = String.valueOf(sql) + " from " + DatabaseUtil.addTilde(table, dbs) + " where 1 = 0";
                    PreparedStatement pst = null;
                    try {
                        try {
                            pst = con.prepareStatement(sql);
                            rs = pst.executeQuery();
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int colSize = rsmd.getColumnCount();
                            tColTypes = new byte[fsize];
                            int ci = 0;
                            while (ci < colSize) {
                                String colname = rsmd.getColumnLabel(ci + 1);
                                if ((colname = DatabaseUtil.tranName(colname, tranContent, dbCharset, toCharset, bb, opt)) != null && colname.trim().length() >= 1) {
                                    int fi = 0;
                                    while (fi < fsize) {
                                        if (colname.equalsIgnoreCase(fields[fi])) {
                                            byte rqType;
                                            int sqlType = rsmd.getColumnType(ci + 1);
                                            tColTypes[fi] = rqType = Types.getTypeBySQLType(sqlType);
                                            break;
                                        }
                                        ++fi;
                                    }
                                }
                                ++ci;
                            }
                            if (keysize < 1) {
                                DatabaseMetaData dbmd = con.getMetaData();
                                String schema = "";
                                String tn = "";
                                if (table.indexOf(".") > 0) {
                                    String[] tns = table.split("\\.");
                                    if (tns == null || tns.length < 2) {
                                        int loc = table.indexOf(".");
                                        tns = new String[]{table.substring(0, loc), table.substring(loc + 1)};
                                    }
                                    schema = tns[0];
                                    tn = tns[1];
                                } else {
                                    tn = table;
                                }
                                try {
                                    rs.close();
                                    rs = dbmd.getPrimaryKeys("", schema, tn);
                                    while (rs.next()) {
                                        String columnName = rs.getString("COLUMN_NAME");
                                        if (columnName == null) continue;
                                        int ki = -1;
                                        int i2 = 0;
                                        while (i2 < fsize) {
                                            if (columnName.equalsIgnoreCase(fields[i2])) {
                                                ki = i2;
                                                break;
                                            }
                                            ++i2;
                                        }
                                        if (ki <= -1) continue;
                                        keyCols.add(new Integer(ki));
                                    }
                                    keysize = keyCols.size();
                                }
                                catch (Exception columnName) {}
                            }
                        }
                        catch (Exception e) {
                            throw new RQException(e.getMessage(), e);
                        }
                    }
                    finally {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                            if (pst != null) {
                                pst.close();
                            }
                        }
                        catch (Exception e) {
                            throw new RQException(e.getMessage(), e);
                        }
                        rs = null;
                    }
                }
                if ((keysize = keyCols.size()) < 1) {
                    Object o1;
                    DataStruct ds1 = null;
                    if (srcSeq instanceof Table) {
                        ds1 = ((Table)srcSeq).dataStruct();
                    }
                    if (ds1 == null && srcSeq != null && srcSeq.length() > 0 && (o1 = srcSeq.get(1)) instanceof BaseRecord) {
                        ds1 = ((BaseRecord)o1).dataStruct();
                    }
                    if (ds1 != null) {
                        String[] keys = ds1.getPrimary();
                        int kc = keys == null ? 0 : keys.length;
                        int i = 0;
                        while (i < kc) {
                            String key = keys[i];
                            if (key != null) {
                                int ki = -1;
                                int j = 0;
                                while (j < fsize) {
                                    if (key.equalsIgnoreCase(fields[j])) {
                                        ki = j;
                                        break;
                                    }
                                    ++j;
                                }
                                if (ki > -1) {
                                    keyCols.add(new Integer(ki));
                                }
                            }
                            ++i;
                        }
                    }
                    keysize = keyCols.size();
                }
                if (keysize < 1) {
                    MessageManager mm = DataSetMessage.get();
                    throw new RQException(mm.getMessage("error.invalidKey"));
                }
                Expression[] keyExps = null;
                kis = new int[keysize];
                keyExps = new Expression[keysize];
                int i = 0;
                while (i < keysize) {
                    kis[i] = (Integer)keyCols.get(i);
                    keyExps[i] = exps[kis[i]];
                    ++i;
                }
                int iField = 0;
                while (iField < fsize) {
                    if (ais[iField] != 1 && (field = fields[iField]) != null && field.trim().length() > 0) {
                        fieldAll = fieldAll == null ? "(" + field : String.valueOf(fieldAll) + ", " + field;
                    }
                    ++iField;
                }
                if (fieldAll == null || fieldAll.trim().length() < 1) {
                    MessageManager mm = DataSetMessage.get();
                    throw new RQException(mm.getMessage("error.invalidField"));
                }
                fieldAll = String.valueOf(fieldAll) + ")";
                if (dsConfig != null) {
                    batchSize = dsConfig.getBatchSize();
                    if (batchSize < 1) {
                        batchSize = 1;
                    }
                    dbCharset = dsConfig.getDBCharset();
                    tranSQL = dsConfig.getNeedTranSentence();
                    tranContent = dsConfig.getNeedTranContent();
                    if ((tranContent || tranSQL) && dbCharset == null) {
                        String dbName = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            dbName = info.getName();
                        }
                        MessageManager mm = DataSetMessage.get();
                        throw new RQException(mm.getMessage("error.fromCharset", dbName));
                    }
                    toCharset = dsConfig.getClientCharset();
                    if ((tranContent || tranSQL) && toCharset == null) {
                        String dbName = "";
                        DBInfo info = dbs.getInfo();
                        if (info != null) {
                            dbName = info.getName();
                        }
                        MessageManager mm = DataSetMessage.get();
                        throw new RQException(mm.getMessage("error.toCharset", dbName));
                    }
                    dbType = dsConfig.getDBType();
                } else {
                    tranContent = false;
                }
                String dbName = "";
                try {
                    IArray oldMems;
                    Sequence insertSeq;
                    Expression[] keysFields;
                    boolean clearAll = false;
                    if (opt != null && opt.indexOf("a") > -1) {
                        MessageManager mm = DataSetMessage.get();
                        Logger.debug(mm.getMessage("info.clearTable", table));
                        String sql = "delete from " + DatabaseUtil.addTilde(table, dbs);
                        st = con.createStatement();
                        st.execute(sql);
                        st.close();
                        clearAll = true;
                    }
                    ArrayList<Expression> updateParams = new ArrayList<Expression>();
                    ArrayList<Expression> updateFields = new ArrayList<Expression>();
                    ArrayList<Expression> primaryParams = new ArrayList<Expression>();
                    ArrayList<Expression> insertParams = new ArrayList<Expression>();
                    ArrayList<Byte> updateTypes = new ArrayList<Byte>();
                    ArrayList<Byte> primaryTypes = new ArrayList<Byte>();
                    ArrayList<Byte> insertTypes = new ArrayList<Byte>();
                    int iField2 = 0;
                    while (iField2 < fsize) {
                        if (ais[iField2] != 1) {
                            insertParams.add(exps[iField2]);
                            insertTypes.add(tColTypes[iField2]);
                            if (ais[iField2] != Col_NormalKey) {
                                updateParams.add(exps[iField2]);
                                updateFields.add(new Expression(fields[iField2]));
                                updateTypes.add(tColTypes[iField2]);
                            }
                        }
                        ++iField2;
                    }
                    ArrayList<Expression> primaryFields = new ArrayList<Expression>();
                    int ki = 0;
                    while (ki < keysize) {
                        primaryFields.add(new Expression(fields[kis[ki]]));
                        primaryParams.add(exps[kis[ki]]);
                        primaryTypes.add(tColTypes[kis[ki]]);
                        updateFields.add(new Expression(fields[kis[ki]]));
                        ++ki;
                    }
                    updateParams.addAll(primaryParams);
                    updateTypes.addAll(primaryTypes);
                    Expression[] params = new Expression[primaryParams.size()];
                    ArrayList<Integer> nullKeys = new ArrayList<Integer>();
                    primaryParams.toArray(params);
                    int paramCount = params.length;
                    int len = srcSeq.length();
                    ComputeStack stack = ctx.getComputeStack();
                    Current current = new Current(srcSeq);
                    stack.push(current);
                    try {
                        int p = 0;
                        while (p < paramCount) {
                            if (params[p] != null) {
                                int i3 = 1;
                                while (i3 <= len) {
                                    current.setCurrent(i3);
                                    Object pv = params[p].calculate(ctx);
                                    if (pv == null) {
                                        nullKeys.add(p);
                                        break;
                                    }
                                    ++i3;
                                }
                            }
                            ++p;
                        }
                    }
                    finally {
                        stack.pop();
                    }
                    int nkeys = nullKeys.size();
                    int nulls = (int)Math.round(Math.pow(2.0, nkeys)) - 1;
                    String[] ucons = nulls > 0 ? new String[nulls] : null;
                    String condition = null;
                    String key = "";
                    String check_sql = "";
                    String update_sql = "";
                    String insert_sql = "";
                    String delete_sql = "";
                    String[] ch_sqls = nulls > 0 ? new String[nulls] : null;
                    String[] up_sqls = nulls > 0 ? new String[nulls] : null;
                    String[] de_sqls = nulls > 0 ? new String[nulls] : null;
                    int j = 0;
                    while (j < keysize) {
                        key = fields[kis[j]];
                        if (key != null && key.trim().length() > 0) {
                            int k;
                            int kloc;
                            if (condition == null) {
                                condition = "(" + key + " = ?)";
                                if (ucons != null && (kloc = nullKeys.indexOf(j)) > -1) {
                                    k = 0;
                                    while (k < nulls) {
                                        ucons[k] = (k & 1 << kloc) == 0 ? String.valueOf(key) + " is null" : "(" + key + " = ?)";
                                        ++k;
                                    }
                                }
                            } else {
                                condition = String.valueOf(condition) + " and (" + key + " = ?)";
                                if (ucons != null && (kloc = nullKeys.indexOf(j)) > -1) {
                                    k = 0;
                                    while (k < nulls) {
                                        if ((k & 1 << kloc) == 0) {
                                            int n = k;
                                            ucons[n] = String.valueOf(ucons[n]) + " and " + key + " is null";
                                        } else {
                                            int n = k;
                                            ucons[n] = String.valueOf(ucons[n]) + " and (" + key + " = ?)";
                                        }
                                        ++k;
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                    check_sql = "select count(*) from " + DatabaseUtil.addTilde(table, dbs) + " where " + condition;
                    delete_sql = "delete from " + DatabaseUtil.addTilde(table, dbs) + " where " + condition;
                    if (ucons != null) {
                        int i4 = 0;
                        while (i4 < nulls) {
                            ch_sqls[i4] = "select count(*) from " + DatabaseUtil.addTilde(table, dbs) + " where " + ucons[i4];
                            de_sqls[i4] = "delete from " + DatabaseUtil.addTilde(table, dbs) + " where " + ucons[i4];
                            ++i4;
                        }
                    }
                    String usets = null;
                    int iField3 = 0;
                    while (iField3 < fsize) {
                        if (ais[iField3] != 1 && ais[iField3] != Col_NormalKey && (field = fields[iField3]) != null && field.trim().length() > 0) {
                            usets = usets == null ? String.valueOf(field) + " = ?" : String.valueOf(usets) + ", " + field + " = ?";
                        }
                        ++iField3;
                    }
                    if (usets == null || usets.trim().length() < 1) {
                        if (fields == null || fields.length == 0) {
                            MessageManager mm = DataSetMessage.get();
                            throw new RQException(mm.getMessage("error.invalidField"));
                        }
                        iField3 = 0;
                        while (iField3 < fsize) {
                            if (ais[iField3] != 1 && (field = fields[iField3]) != null && field.trim().length() > 0 && usets == null) {
                                usets = String.valueOf(field) + " = ?";
                                break;
                            }
                            ++iField3;
                        }
                        if (usets == null || usets.trim().length() < 1) {
                            MessageManager mm = DataSetMessage.get();
                            throw new RQException(mm.getMessage("error.invalidFieldValue"));
                        }
                        MessageManager mm = DataSetMessage.get();
                        Logger.warn(mm.getMessage("info.noUpdateField"));
                    }
                    update_sql = "update " + DatabaseUtil.addTilde(table, dbs) + " set " + usets + " where " + condition;
                    if (ucons != null) {
                        int i5 = 0;
                        while (i5 < nulls) {
                            up_sqls[i5] = "update " + DatabaseUtil.addTilde(table, dbs) + " set " + usets + " where " + ucons[i5];
                            ++i5;
                        }
                    }
                    String sets = null;
                    int iField4 = 0;
                    while (iField4 < fsize) {
                        if (ais[iField4] != 1 && (field = fields[iField4]) != null && field.trim().length() > 0) {
                            if (sets == null) {
                                fieldAll = "(" + field;
                                sets = "( ?";
                            } else {
                                fieldAll = String.valueOf(fieldAll) + ", " + field;
                                sets = String.valueOf(sets) + ", ?";
                            }
                        }
                        ++iField4;
                    }
                    if (sets == null || sets.trim().length() < 1) {
                        MessageManager mm = DataSetMessage.get();
                        throw new RQException(mm.getMessage("error.invalidFieldValue"));
                    }
                    sets = String.valueOf(sets) + " )";
                    if (fieldAll == null || fieldAll.trim().length() < 1) {
                        MessageManager mm = DataSetMessage.get();
                        throw new RQException(mm.getMessage("error.invalidField"));
                    }
                    fieldAll = String.valueOf(fieldAll) + " )";
                    insert_sql = "insert into " + DatabaseUtil.addTilde(table, dbs) + " " + fieldAll + " values " + sets;
                    if (tranSQL) {
                        check_sql = new String(check_sql.getBytes(), dbCharset);
                        update_sql = new String(update_sql.getBytes(), dbCharset);
                        insert_sql = new String(insert_sql.getBytes(), dbCharset);
                        delete_sql = new String(delete_sql.getBytes(), dbCharset);
                        if (ucons != null) {
                            int i6 = 0;
                            while (i6 < nulls) {
                                ch_sqls[i6] = new String(ch_sqls[i6].getBytes(), dbCharset);
                                de_sqls[i6] = new String(de_sqls[i6].getBytes(), dbCharset);
                                up_sqls[i6] = new String(up_sqls[i6].getBytes(), dbCharset);
                                ++i6;
                            }
                        }
                    }
                    boolean isAutoDetect = true;
                    if (opt != null) {
                        Expression[] keysParam;
                        MessageManager mm;
                        if (opt.indexOf(100) > -1 && !clearAll) {
                            mm = DataSetMessage.get();
                            Logger.debug(mm.getMessage("info.deleteOnly"));
                            Expression[] keysFields2 = new Expression[primaryFields.size()];
                            primaryFields.toArray(keysFields2);
                            DatabaseUtil.executeDifferBatch(srcSeq, compSeq, delete_sql, primaryFields, primaryParams, primaryTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize, de_sqls, nullKeys, keysize);
                            isAutoDetect = false;
                        } else if (opt.indexOf(105) > -1) {
                            if (compSeq != null && compSeq.length() > 0) {
                                mm = DataSetMessage.get();
                                Logger.debug(mm.getMessage("info.insertOnly", insert_sql));
                                keysParam = new Expression[primaryParams.size()];
                                primaryParams.toArray(keysParam);
                                keysFields = new Expression[primaryFields.size()];
                                primaryFields.toArray(keysFields);
                                insertSeq = DatabaseUtil.diffSequence(srcSeq, compSeq, keysParam, keysFields, ctx);
                                oldMems = srcSeq.getMems();
                                srcSeq.setMems(insertSeq.getMems());
                                DatabaseUtil.executeBatchSql(srcSeq, insert_sql, insertParams, insertTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize);
                                srcSeq.setMems(oldMems);
                            } else {
                                mm = DataSetMessage.get();
                                Logger.debug(mm.getMessage("info.insertOnly", insert_sql));
                                DatabaseUtil.executeBatchSql(srcSeq, insert_sql, insertParams, insertTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize);
                            }
                            isAutoDetect = false;
                        } else if (opt.indexOf(117) > -1) {
                            if (compSeq != null && compSeq.length() > 0) {
                                mm = DataSetMessage.get();
                                Logger.debug(mm.getMessage("info.updateOnly", update_sql));
                                keysParam = new Expression[primaryParams.size()];
                                primaryParams.toArray(keysParam);
                                keysFields = new Expression[primaryFields.size()];
                                primaryFields.toArray(keysFields);
                                Sequence remainSeq = DatabaseUtil.isectSequence(srcSeq, compSeq, keysParam, keysFields, ctx);
                                oldMems = srcSeq.getMems();
                                srcSeq.setMems(remainSeq.getMems());
                                DatabaseUtil.executeDifferBatch(compSeq, srcSeq, update_sql, updateParams, updateFields, updateTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize, up_sqls, nullKeys, keysize);
                                srcSeq.setMems(oldMems);
                            } else {
                                DatabaseUtil.executeBatchSql(srcSeq, update_sql, updateParams, updateTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize);
                            }
                            isAutoDetect = false;
                        }
                    }
                    if (isAutoDetect) {
                        if (compSeq != null && compSeq.length() > 0) {
                            MessageManager mm;
                            if (!clearAll) {
                                Expression[] keysFields3 = new Expression[primaryFields.size()];
                                primaryFields.toArray(keysFields3);
                                mm = DataSetMessage.get();
                                Logger.debug(mm.getMessage("info.autoDelete"));
                                DatabaseUtil.executeDifferBatch(srcSeq, compSeq, delete_sql, primaryFields, primaryParams, primaryTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize, de_sqls, nullKeys, keysize);
                            }
                            Expression[] keysParam = new Expression[primaryParams.size()];
                            primaryParams.toArray(keysParam);
                            mm = DataSetMessage.get();
                            Logger.debug(mm.getMessage("info.autoInsert", insert_sql));
                            keysFields = new Expression[primaryFields.size()];
                            primaryFields.toArray(keysFields);
                            insertSeq = DatabaseUtil.diffSequence(srcSeq, compSeq, keysParam, keysFields, ctx);
                            oldMems = srcSeq.getMems();
                            srcSeq.setMems(insertSeq.getMems());
                            DatabaseUtil.executeBatchSql(srcSeq, insert_sql, insertParams, insertTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize);
                            srcSeq.setMems(oldMems);
                            Logger.debug(mm.getMessage("info.autoUpdate", update_sql));
                            Sequence remainSeq = DatabaseUtil.mergeDiffSequence(srcSeq, insertSeq, null, ctx);
                            srcSeq.setMems(remainSeq.getMems());
                            DatabaseUtil.executeDifferBatch(compSeq, srcSeq, update_sql, updateParams, updateFields, updateTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize, up_sqls, nullKeys, keysize);
                            srcSeq.setMems(oldMems);
                        } else {
                            Expression[] expParams = new Expression[primaryParams.size()];
                            primaryParams.toArray(expParams);
                            Sequence recordCount = DatabaseUtil.query(srcSeq, check_sql, expParams, DatabaseUtil.toByteArray(primaryTypes), opt, ctx, dbs, ch_sqls, nullKeys, keysize);
                            Sequence updateRecords = new Sequence();
                            Sequence insertRecords = new Sequence();
                            int rsize = recordCount == null ? 0 : recordCount.length();
                            int i7 = 1;
                            while (i7 <= rsize) {
                                BaseRecord r = (BaseRecord)recordCount.get(i7);
                                int c = 0;
                                if (r != null) {
                                    c = ((Number)r.getFieldValue(0)).intValue();
                                }
                                if (c > 0) {
                                    updateRecords.add(srcSeq.get(i7));
                                } else {
                                    insertRecords.add(srcSeq.get(i7));
                                }
                                ++i7;
                            }
                            if (updateRecords.length() > 0) {
                                MessageManager mm = DataSetMessage.get();
                                Logger.debug(mm.getMessage("info.autoUpdate", update_sql));
                                DatabaseUtil.executeDifferBatch(null, updateRecords, update_sql, updateParams, updateFields, updateTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize, up_sqls, nullKeys, keysize);
                            }
                            if (insertRecords.length() > 0) {
                                MessageManager mm = DataSetMessage.get();
                                Logger.debug(mm.getMessage("info.autoInsert", insert_sql));
                                DatabaseUtil.executeBatchSql(insertRecords, insert_sql, insertParams, insertTypes, ctx, dbs, con, dbCharset, tranSQL, dbType, dbName, batchSize);
                            }
                        }
                    }
                }
                catch (RQException e) {
                    MessageManager mm = DataSetMessage.get();
                    Logger.debug(mm.getMessage("error.update", e.getMessage()));
                    if (dbs.getErrorMode()) {
                        dbs.setError(new SQLException(e.getMessage(), "Error: 5001 Update error: ", 5001));
                    }
                }
            }
            catch (RQException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (opt == null || opt.indexOf(107) < 0) {
                    con.commit();
                }
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        return 0;
    }

    public static int update(Sequence srcSeries, String table, String[] fields, String[] fopts, Expression[] exps, String opt, DBSession dbs, Context ctx) {
        return DatabaseUtil.update(srcSeries, null, table, fields, fopts, exps, opt, dbs, ctx);
    }

    private static void executeBatchSql(Sequence srcSeries, String sql, ArrayList<Expression> exps, ArrayList<Byte> expTypes, Context ctx, DBSession dbs) {
        Expression[] expParams = new Expression[exps.size()];
        exps.toArray(expParams);
        DatabaseUtil.execute(srcSeries, sql, expParams, DatabaseUtil.toByteArray(expTypes), ctx, dbs);
    }

    private static void executeDifferBatch(Sequence srcSeq, Sequence compSeq, String sql, ArrayList<Expression> paramExps, ArrayList<Expression> oldFieldExps, ArrayList<Byte> paramTypes, Context ctx, DBSession dbs, Connection con, String dbCharset, boolean tranSQL, int dbType, String dbn, int batchSize, String[] nullSqls, ArrayList<Integer> nullKeys, int keysize) {
        Sequence diffParamSeq;
        int p;
        int i;
        Expression[] params = new Expression[paramExps.size()];
        paramExps.toArray(params);
        Expression[] fieldParams = new Expression[oldFieldExps.size()];
        oldFieldExps.toArray(fieldParams);
        byte[] types = DatabaseUtil.toByteArray(paramTypes);
        if (compSeq == null || compSeq.length() == 0) {
            return;
        }
        int pCount = params == null ? 0 : params.length;
        int keyStart = pCount - keysize;
        int len = compSeq.length();
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(compSeq);
        stack.push(current);
        Sequence usingParams = new Sequence();
        int nulls = nullSqls == null ? 0 : nullSqls.length;
        boolean nkeys = nullKeys != null && nullKeys.size() > 0 && nulls > 0;
        ArrayList<Sequence> nullParams = null;
        if (nkeys) {
            nullParams = new ArrayList<Sequence>(nulls);
            i = 0;
            while (i < nulls) {
                nullParams.add(new Sequence());
                ++i;
            }
        }
        try {
            i = 1;
            while (i <= len) {
                current.setCurrent(i);
                Sequence pValues = new Sequence();
                int nloc = 0;
                p = 0;
                while (p < pCount) {
                    if (params[p] != null) {
                        Object pv = params[p].calculate(ctx);
                        if (nkeys && p >= keyStart && pv == null) {
                            int kloc = nullKeys.indexOf(p - keyStart);
                            nloc += 1 << kloc;
                        }
                        pValues.add(pv);
                    }
                    ++p;
                }
                if (nloc > 0) {
                    nloc = nulls - nloc;
                    ((Sequence)nullParams.get(nloc)).add(pValues);
                } else {
                    usingParams.add(pValues);
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        Sequence initParams = new Sequence();
        if (srcSeq != null && srcSeq.length() > 0) {
            len = srcSeq.length();
            stack = ctx.getComputeStack();
            current = new Current(srcSeq);
            stack.push(current);
            try {
                int i2 = 1;
                while (i2 <= len) {
                    current.setCurrent(i2);
                    Sequence pValues = new Sequence();
                    p = 0;
                    while (p < pCount) {
                        if (fieldParams[p] != null) {
                            pValues.add(fieldParams[p].calculate(ctx));
                        }
                        ++p;
                    }
                    initParams.add(pValues);
                    ++i2;
                }
            }
            finally {
                stack.pop();
            }
        }
        if ((len = (diffParamSeq = (usingParams = usingParams.sort(null)).diff(initParams = initParams.sort(null), true)).length()) < 1 && !nkeys) {
            return;
        }
        Object[][] valueGroup = new Object[len][pCount];
        int i3 = 1;
        while (i3 <= len) {
            Sequence seq = (Sequence)diffParamSeq.get(i3);
            valueGroup[i3 - 1] = seq.toArray();
            ++i3;
        }
        DatabaseUtil.executeBatch(sql, valueGroup, types, dbs, con, dbCharset, tranSQL, dbType, dbn, batchSize, true);
        if (nkeys) {
            i3 = 0;
            while (i3 < nulls) {
                Sequence nullParam = (Sequence)nullParams.get(i3);
                diffParamSeq = (nullParam = nullParam.sort(null)).diff(initParams, true);
                len = diffParamSeq.length();
                if (len >= 1) {
                    valueGroup = new Object[len][pCount];
                    sql = nullSqls[i3];
                    int j = 1;
                    while (j <= len) {
                        Sequence seq = (Sequence)diffParamSeq.get(j);
                        int psize = seq.length();
                        ArrayList<Object> ps = new ArrayList<Object>();
                        int p2 = 0;
                        while (p2 < psize) {
                            Object pv = seq.get(p2 + 1);
                            if (p2 < keyStart || pv != null) {
                                ps.add(pv);
                            }
                            ++p2;
                        }
                        valueGroup[j - 1] = ps.toArray();
                        ++j;
                    }
                    DatabaseUtil.executeBatch(sql, valueGroup, types, dbs, con, dbCharset, tranSQL, dbType, dbn, batchSize, true);
                }
                ++i3;
            }
        }
    }

    private static Sequence mergeDiffSequence(Sequence seq1, Sequence seq2, Expression[] exps, Context ctx) {
        Sequence diffAll = new Sequence();
        diffAll.add(seq1);
        diffAll.add(seq2);
        Sequence diffSeq = diffAll.merge(exps, "od", ctx);
        return diffSeq;
    }

    private static Sequence diffSequence(Sequence seq1, Sequence seq2, Expression[] exps1, Expression[] exps2, Context ctx) {
        if (exps1 == null || exps1.length < 1 || exps1[0] == null) {
            return DatabaseUtil.mergeDiffSequence(seq1, seq2, exps2, ctx);
        }
        if (exps2 == null || exps2.length < 1 || exps2[0] == null) {
            return DatabaseUtil.mergeDiffSequence(seq1, seq2, exps1, ctx);
        }
        int keyCount = exps1.length;
        IArray mems2 = seq2.getMems();
        int len2 = mems2.size();
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil((int)((double)len2 * 1.2));
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(seq2);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len2) {
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps2[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] == null) {
                    groups[hash] = new ListBase1(INIT_GROUPSIZE);
                    groups[hash].add(keys);
                } else {
                    int index = HashUtil.bsearch_a(groups[hash], keys, keyCount);
                    if (index < 1) {
                        groups[hash].add(-index, keys);
                    } else {
                        groups[hash].add(index, keys);
                    }
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        IArray mems1 = seq1.getMems();
        int len1 = mems1.size();
        Sequence result = new Sequence(len1);
        current = new Current(seq1);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len1) {
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps1[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] == null) {
                    result.add(mems1.get(i));
                } else {
                    int index = HashUtil.bsearch_a(groups[hash], keys, keyCount);
                    if (index < 1) {
                        result.add(mems1.get(i));
                    } else {
                        groups[hash].remove(index);
                    }
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        result.trimToSize();
        return result;
    }

    private static Sequence mergeIntersection(Sequence seq1, Sequence seq2, Expression[] exps, Context ctx) {
        Sequence diffAll = new Sequence();
        diffAll.add(seq1);
        diffAll.add(seq2);
        Sequence diffSeq = diffAll.merge(exps, "oi", ctx);
        return diffSeq;
    }

    private static Sequence isectSequence(Sequence seq1, Sequence seq2, Expression[] exps1, Expression[] exps2, Context ctx) {
        if (exps1 == null || exps1.length < 1 || exps1[0] == null) {
            return DatabaseUtil.mergeIntersection(seq1, seq2, exps2, ctx);
        }
        if (exps2 == null || exps2.length < 1 || exps2[0] == null) {
            return DatabaseUtil.mergeIntersection(seq1, seq2, exps1, ctx);
        }
        int keyCount = exps1.length;
        IArray mems2 = seq2.getMems();
        int len2 = mems2.size();
        int INIT_GROUPSIZE = HashUtil.getInitGroupSize();
        HashUtil hashUtil = new HashUtil((int)((double)len2 * 1.2));
        ListBase1[] groups = new ListBase1[hashUtil.getCapacity()];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(seq2);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len2) {
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps2[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] == null) {
                    groups[hash] = new ListBase1(INIT_GROUPSIZE);
                    groups[hash].add(keys);
                } else {
                    int index = HashUtil.bsearch_a(groups[hash], keys, keyCount);
                    if (index < 1) {
                        groups[hash].add(-index, keys);
                    } else {
                        groups[hash].add(index, keys);
                    }
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        IArray mems1 = seq1.getMems();
        int len1 = mems1.size();
        Sequence result = new Sequence(len1);
        current = new Current(seq1);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len1) {
                int index;
                Object[] keys = new Object[keyCount];
                current.setCurrent(i);
                int c = 0;
                while (c < keyCount) {
                    keys[c] = exps1[c].calculate(ctx);
                    ++c;
                }
                int hash = hashUtil.hashCode(keys, keyCount);
                if (groups[hash] != null && (index = HashUtil.bsearch_a(groups[hash], keys, keyCount)) > 0) {
                    result.add(mems1.get(i));
                    groups[hash].remove(index);
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        result.trimToSize();
        return result;
    }

    private static void executeBatchPst(Sequence srcSeries, PreparedStatement pst, ArrayList<Expression> exps, ArrayList<Byte> expTypes, Context ctx, DBSession dbs, String dbCharset, boolean tranSQL, int dbType, String name) {
        Expression[] expParams = new Expression[exps.size()];
        exps.toArray(expParams);
        DatabaseUtil.executePst(srcSeries, pst, expParams, DatabaseUtil.toByteArray(expTypes), ctx, dbs, dbCharset, tranSQL, dbType, name);
    }

    private static void executeBatchSql(Sequence srcSeries, String sql, ArrayList<Expression> exps, ArrayList<Byte> expTypes, Context ctx, DBSession dbs, Connection con, String dbCharset, boolean tranSQL, int dbType, String dbn, int batchSize) {
        Expression[] expParams = new Expression[exps.size()];
        exps.toArray(expParams);
        DatabaseUtil.execute(srcSeries, sql, expParams, DatabaseUtil.toByteArray(expTypes), ctx, dbs, con, dbCharset, tranSQL, dbType, dbn, batchSize);
    }

    public static Sequence query(Sequence srcSeries, String sql, Expression[] params, byte[] types, String opt, Context ctx, DBSession dbs) {
        return DatabaseUtil.query(srcSeries, sql, params, types, opt, ctx, dbs, null, null, 0);
    }

    private static Sequence query(Sequence srcSeries, String sql, Expression[] params, byte[] types, String opt, Context ctx, DBSession dbs, String[] nullSqls, ArrayList<Integer> nullKeys, int keysize) {
        int i;
        if (srcSeries == null || srcSeries.length() == 0 || params == null || params.length == 0) {
            return DatabaseUtil.query(sql, null, null, opt, ctx, dbs);
        }
        int pCount = params.length;
        int keyStart = pCount - keysize;
        int len = srcSeries.length();
        ArrayList<ArrayList<Object>> vgs = new ArrayList<ArrayList<Object>>(len);
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(srcSeries);
        stack.push(current);
        int nulls = nullSqls == null ? 0 : nullSqls.length;
        boolean nkeys = nullKeys != null && nullKeys.size() > 0 && nulls > 0;
        ArrayList nullParams = null;
        int[] res = new int[len];
        if (nkeys) {
            nullParams = new ArrayList(nulls);
            i = 0;
            while (i < nulls) {
                nullParams.add(new ArrayList());
                ++i;
            }
        }
        try {
            i = 1;
            while (i <= len) {
                current.setCurrent(i);
                ArrayList<Object> pValues = new ArrayList<Object>();
                int nloc = 0;
                int p = 0;
                while (p < pCount) {
                    if (params[p] != null) {
                        Object pv = params[p].calculate(ctx);
                        if (nkeys && p >= keyStart && pv == null) {
                            int kloc = nullKeys.indexOf(p - keyStart);
                            nloc += 1 << kloc;
                        }
                        pValues.add(pv);
                    }
                    ++p;
                }
                if (nloc > 0) {
                    nloc = nulls - nloc;
                    ((ArrayList)nullParams.get(nloc)).add(pValues);
                    res[i - 1] = nloc + 1;
                } else {
                    vgs.add(pValues);
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        Object[][] valueGroup = DatabaseUtil.toGroup(vgs);
        Table tbl = DatabaseUtil.queryGroup(sql, valueGroup, types, dbs, opt, ctx);
        if (nkeys) {
            ArrayList<Table> nTbls = new ArrayList<Table>(nulls);
            Table tbli = null;
            int i2 = 0;
            while (i2 < nulls) {
                ArrayList nullParam = (ArrayList)nullParams.get(i2);
                valueGroup = DatabaseUtil.toGroup(nullParam, keyStart);
                if (valueGroup != null) {
                    tbli = DatabaseUtil.queryGroup(nullSqls[i2], valueGroup, null, dbs, opt, ctx);
                } else if (nullSqls[i2].indexOf("?") < 0) {
                    valueGroup = new Object[][]{null};
                    tbli = DatabaseUtil.queryGroup(nullSqls[i2], valueGroup, null, dbs, opt, ctx);
                }
                nTbls.add(tbli);
                ++i2;
            }
            Sequence result = new Sequence(len);
            int[] locs = new int[nulls + 1];
            Object o = null;
            int i3 = 0;
            while (i3 < len) {
                int ri = res[i3];
                locs[ri] = locs[ri] + 1;
                if (ri <= 0) {
                    o = tbl.get(locs[ri]);
                } else {
                    Table ot = (Table)nTbls.get(ri - 1);
                    if (ot == null) {
                        o = null;
                    } else {
                        if (locs[ri] > ot.length()) {
                            locs[ri] = ot.length();
                        }
                        o = ot.get(locs[ri]);
                    }
                }
                result.add(o);
                ++i3;
            }
            return result;
        }
        return tbl;
    }

    private static Object[][] toGroup(ArrayList<ArrayList<Object>> lvalues) {
        int len = lvalues.size();
        if (len < 1) {
            return null;
        }
        ArrayList<Object> o1 = lvalues.get(0);
        int len2 = o1.size();
        if (len2 < 1) {
            return null;
        }
        Object[][] result = new Object[len][len2];
        int i = 0;
        while (i < len) {
            o1 = lvalues.get(i);
            int j = 0;
            while (j < len2) {
                result[i][j] = o1.get(j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static Object[][] toGroup(ArrayList<ArrayList<Object>> lvalues, int keyStart) {
        int len2;
        int len = lvalues.size();
        if (len < 1) {
            return null;
        }
        ArrayList<Object> o1 = lvalues.get(0);
        int len22 = len2 = o1.size();
        int i = keyStart;
        while (i < len2) {
            Object o = o1.get(i);
            if (o == null) {
                --len22;
            }
            ++i;
        }
        if (len22 < 1) {
            return null;
        }
        Object[][] result = new Object[len][len22];
        int i2 = 0;
        while (i2 < len) {
            o1 = lvalues.get(i2);
            int col = 0;
            int j = 0;
            while (j < len2) {
                Object o = o1.get(j);
                if (o != null) {
                    result[i2][col] = o;
                    ++col;
                }
                ++j;
            }
            ++i2;
        }
        return result;
    }

    public static Sequence query(String sql, Object[] params, byte[] types, String opt, Context ctx, DBSession dbs) {
        return DatabaseUtil.query(sql, params, types, dbs, opt, ctx);
    }

    public static void execute(Sequence srcSeries, String sql, Expression[] params, byte[] types, Context ctx, DBSession dbs) {
        if (srcSeries == null) {
            return;
        }
        int paramCount = params == null ? 0 : params.length;
        int len = srcSeries.length();
        Object[][] valueGroup = new Object[len][paramCount];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(srcSeries);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len) {
                current.setCurrent(i);
                Object[] paramValues = new Object[paramCount];
                valueGroup[i - 1] = paramValues;
                int p = 0;
                while (p < paramCount) {
                    if (params[p] != null) {
                        paramValues[p] = params[p].calculate(ctx);
                    }
                    ++p;
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        DatabaseUtil.execute2(sql, valueGroup, types, dbs, true);
    }

    private static void execute(Sequence srcSeries, String sql, Expression[] params, byte[] types, Context ctx, DBSession dbs, Connection con, String dbCharset, boolean tranSQL, int dbType, String dbn, int batchSize) {
        if (srcSeries == null) {
            return;
        }
        int paramCount = params == null ? 0 : params.length;
        int len = srcSeries.length();
        Object[][] valueGroup = new Object[len][paramCount];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(srcSeries);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len) {
                current.setCurrent(i);
                Object[] paramValues = new Object[paramCount];
                valueGroup[i - 1] = paramValues;
                int p = 0;
                while (p < paramCount) {
                    if (params[p] != null) {
                        paramValues[p] = params[p].calculate(ctx);
                    }
                    ++p;
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        DatabaseUtil.executeBatch(sql, valueGroup, types, dbs, con, dbCharset, tranSQL, dbType, dbn, batchSize, true);
    }

    public static void execute(ICursor cs, String sql, Expression[] params, byte[] types, Context ctx, DBSession dbs) {
        Statement pst = null;
        Connection con = null;
        String dbCharset = null;
        String toCharset = null;
        boolean tranSQL = false;
        boolean tranContent = true;
        int dbType = 0;
        String name = "";
        DBInfo info = dbs.getInfo();
        if (info != null) {
            name = info.getName();
        }
        int batchSize = 1000;
        try {
            try {
                Sequence fetchSeq;
                Object session;
                DBConfig dsConfig = null;
                MessageManager mm = DataSetMessage.get();
                if (dbs != null && dbs.getInfo() instanceof DBConfig) {
                    dsConfig = (DBConfig)dbs.getInfo();
                }
                if (dbs != null && (session = dbs.getSession()) instanceof Connection) {
                    con = (Connection)session;
                }
                if (con == null || con.isClosed()) {
                    throw new RQException(mm.getMessage("error.conClosed", name));
                }
                if (dsConfig != null) {
                    batchSize = dsConfig.getBatchSize();
                    if (batchSize < 1) {
                        batchSize = 1;
                    }
                    dbCharset = dsConfig.getDBCharset();
                    tranSQL = dsConfig.getNeedTranSentence();
                    tranContent = dsConfig.getNeedTranContent();
                    if ((tranContent || tranSQL) && dbCharset == null) {
                        throw new RQException(mm.getMessage("error.fromCharset", name));
                    }
                    toCharset = dsConfig.getClientCharset();
                    if ((tranContent || tranSQL) && toCharset == null) {
                        throw new RQException(mm.getMessage("error.toCharset", name));
                    }
                    dbType = dsConfig.getDBType();
                } else {
                    tranContent = false;
                }
                if (tranSQL) {
                    sql = new String(sql.getBytes(), dbCharset);
                }
                try {
                    pst = con.prepareStatement(sql);
                }
                catch (SQLException e) {
                    if (dbs.getErrorMode()) {
                        dbs.setError(e);
                    }
                    throw new RQException(String.valueOf(mm.getMessage("error.sqlException", name, sql)) + " : " + e.getMessage(), e);
                }
                while ((fetchSeq = cs.fetch(batchSize)) != null) {
                    if (fetchSeq.length() == 0) {
                        break;
                    }
                    DatabaseUtil.executePst(fetchSeq, (PreparedStatement)pst, params, types, ctx, dbs, dbCharset, tranSQL, dbType, name);
                }
            }
            catch (RQException re) {
                throw re;
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (Exception e) {
                throw new RQException(e.getMessage(), e);
            }
        }
    }

    private static void executePst(Sequence srcSeries, PreparedStatement pst, Expression[] params, byte[] types, Context ctx, DBSession dbs, String dbCharset, boolean tranSQL, int dbType, String name) {
        if (srcSeries == null) {
            return;
        }
        int paramCount = params == null ? 0 : params.length;
        int len = srcSeries.length();
        Object[][] valueGroup = new Object[len][paramCount];
        ComputeStack stack = ctx.getComputeStack();
        Current current = new Current(srcSeries);
        stack.push(current);
        try {
            int i = 1;
            while (i <= len) {
                current.setCurrent(i);
                Object[] paramValues = new Object[paramCount];
                valueGroup[i - 1] = paramValues;
                int p = 0;
                while (p < paramCount) {
                    if (params[p] != null) {
                        paramValues[p] = params[p].calculate(ctx);
                    }
                    ++p;
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        DatabaseUtil.executeBatch(pst, valueGroup, types, dbs, dbCharset, tranSQL, dbType, name, true);
    }

    public static void connectAutoDBs(Context ctx, List<String> startDsNames) {
        try {
            if (startDsNames != null) {
                int i = 0;
                while (i < startDsNames.size()) {
                    String dsName = startDsNames.get(i);
                    ISessionFactory isf = Env.getDBSessionFactory(dsName);
                    if (isf != null) {
                        ctx.setDBSession(dsName, isf.getSession());
                        Logger.debug(String.valueOf(dsName) + " is auto connected.");
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeAutoDBs(Context ctx) {
        if (ctx == null) {
            return;
        }
        Map<String, DBSession> map = ctx.getDBSessionMap();
        if (map != null) {
            Iterator<String> iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Object o;
                String name = iter.next().toString();
                DBSession sess = ctx.getDBSession(name);
                if (sess == null || sess.isClosed() || (o = ctx.getDBSession(name).getSession()) == null || !(o instanceof Connection)) continue;
                try {
                    ((Connection)o).close();
                    Logger.debug(String.valueOf(name) + " is auto closed.");
                }
                catch (Exception e) {
                    Logger.warn(e.getMessage(), e);
                }
            }
        }
    }
}

