/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.dm.Sequence;
import com.scudata.util.XMLUtil;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class HTMLUtil {
    private static void getTable(Element element, boolean doParse, Sequence result) {
        Elements rows = element.select("tr");
        int rowCount = rows == null ? 0 : rows.size();
        Sequence rowValues = new Sequence(rowCount);
        result.add(rowValues);
        int r = 0;
        while (r < rowCount) {
            int colCount;
            Element row = (Element)rows.get(r);
            Elements cols = row.select("td");
            int n = colCount = cols == null ? 0 : cols.size();
            if (colCount == 0 && r == 0) {
                cols = row.select("th");
                colCount = cols == null ? 0 : cols.size();
            }
            Sequence colValues = new Sequence(colCount);
            rowValues.add(colValues);
            int c = 0;
            while (c < colCount) {
                String text = ((Element)cols.get(c)).text();
                if (text != null) {
                    if ((text = text.trim()).length() > 0) {
                        if (doParse) {
                            Object val = XMLUtil.parseText(text);
                            colValues.add(val);
                        } else {
                            colValues.add(text);
                        }
                    } else {
                        colValues.add(null);
                    }
                } else {
                    colValues.add(null);
                }
                ++c;
            }
            ++r;
        }
    }

    public static Sequence htmlparse(String html, String[] tags, int[] seqs, int[] subSeqs, String opt) {
        int len = tags.length;
        Sequence result = new Sequence(len);
        boolean containNull = false;
        boolean doParse = false;
        if (opt != null) {
            if (opt.indexOf(48) != -1) {
                containNull = true;
            }
            if (opt.indexOf(112) != -1) {
                doParse = true;
            }
        }
        Document doc = Jsoup.parse((String)html);
        int i = 0;
        while (i < len) {
            Elements elements = doc.getElementsByTag(tags[i]);
            if (elements == null || elements.size() == 0) {
                if (containNull) {
                    result.add(null);
                }
            } else if (seqs[i] == -1) {
                int j = 0;
                int size = elements.size();
                while (j < size) {
                    Element element = (Element)elements.get(j);
                    if (tags[i].equals("table")) {
                        HTMLUtil.getTable(element, doParse, result);
                    } else {
                        String text = null;
                        if (subSeqs[i] < element.childNodeSize()) {
                            Node node = element.childNode(subSeqs[i]);
                            text = node.toString();
                        }
                        if (text != null) {
                            if ((text = text.trim()).length() > 0) {
                                if (doParse) {
                                    Object val = XMLUtil.parseText(text);
                                    result.add(val);
                                } else {
                                    result.add(text);
                                }
                            } else if (containNull) {
                                result.add(null);
                            }
                        } else if (containNull) {
                            result.add(null);
                        }
                    }
                    ++j;
                }
            } else if (elements.size() > seqs[i]) {
                Element element = (Element)elements.get(seqs[i]);
                if (tags[i].equals("table")) {
                    HTMLUtil.getTable(element, doParse, result);
                } else {
                    String text = null;
                    if (subSeqs[i] < element.childNodeSize()) {
                        Node node = element.childNode(subSeqs[i]);
                        text = node.toString();
                    }
                    if (text != null) {
                        if ((text = text.trim()).length() > 0) {
                            if (doParse) {
                                Object val = XMLUtil.parseText(text);
                                result.add(val);
                            } else {
                                result.add(text);
                            }
                        } else if (containNull) {
                            result.add(null);
                        }
                    } else if (containNull) {
                        result.add(null);
                    }
                }
            } else if (containNull) {
                result.add(null);
            }
            ++i;
        }
        return result;
    }

    private static void getAllNodeText(Node node, Sequence out, boolean containNull, boolean doParse) {
        if (node instanceof TextNode) {
            String text = ((TextNode)node).text();
            if (text != null) {
                if ((text = text.trim()).length() > 0) {
                    if (doParse) {
                        Object val = XMLUtil.parseText(text);
                        out.add(val);
                    } else {
                        out.add(text);
                    }
                } else if (containNull) {
                    out.add(null);
                }
            } else if (containNull) {
                out.add(null);
            }
        } else {
            List childs = node.childNodes();
            if (childs != null && childs.size() > 0) {
                for (Node child : childs) {
                    HTMLUtil.getAllNodeText(child, out, containNull, doParse);
                }
            } else if (containNull && !node.nodeName().equals("head") && !node.nodeName().equals("body")) {
                out.add(null);
            }
        }
    }

    public static Sequence htmlparse(String html, String opt) {
        Sequence result = new Sequence();
        Document doc = Jsoup.parse((String)html);
        List childs = doc.childNodes();
        boolean containNull = false;
        boolean doParse = false;
        if (opt != null) {
            if (opt.indexOf(48) != -1) {
                containNull = true;
            }
            if (opt.indexOf(112) != -1) {
                doParse = true;
            }
        }
        if (childs != null) {
            for (Node child : childs) {
                HTMLUtil.getAllNodeText(child, result, containNull, doParse);
            }
        }
        return result;
    }
}

