/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.array.IArray;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Env;
import com.scudata.dm.ListBase1;
import com.scudata.dm.Sequence;
import com.scudata.util.Variant;

public final class HashUtil {
    private final int capacity;
    private static final int[] PRIMES = new int[]{13, 19, 29, 41, 59, 79, 107, 149, 197, 263, 347, 457, 599, 787, 1031, 1361, 1777, 2333, 3037, 3967, 5167, 6719, 8737, 11369, 14783, 19219, 24989, 32491, 42257, 54941, 71429, 92861, 120721, 156941, 204047, 265271, 344857, 448321, 582821, 757693, 985003, 1280519, 1664681, 2164111, 2813353, 3657361, 4754591, 6180989, 8035301, 10445899, 13579681, 17653589, 22949669, 29834603, 38784989, 50420551, 65546729, 85210757, 110774011, 144006217, 187208107, 243370577, 316381771, 411296309, 534685237, 695090819, 903618083, 1174703521, 1527114613, 1837299131, Integer.MAX_VALUE};

    private static int getNearCapacity(int c) {
        if (c > Env.MAX_HASHCAPACITY) {
            c = Env.MAX_HASHCAPACITY;
        }
        int i = 0;
        int len = PRIMES.length;
        while (i < len) {
            if (PRIMES[i] == c) {
                return PRIMES[i];
            }
            if (PRIMES[i] > c) {
                return PRIMES[i] > Env.MAX_HASHCAPACITY ? PRIMES[i - 1] : PRIMES[i];
            }
            ++i;
        }
        throw new RuntimeException();
    }

    public static int getInitGroupSize() {
        return 3;
    }

    public HashUtil() {
        this.capacity = Env.getDefaultHashCapacity();
    }

    public HashUtil(int capacity) {
        this.capacity = HashUtil.getNearCapacity(capacity);
    }

    public HashUtil(int capacity, boolean doAdjust) {
        this.capacity = doAdjust ? HashUtil.getNearCapacity(capacity) : capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int hashCode(Object[] vals) {
        return this.hashCode(vals, vals.length);
    }

    public int hashCode(Object[] vals, int count) {
        int hash = vals[0] != null ? vals[0].hashCode() : 0;
        int i = 1;
        while (i < count) {
            hash = vals[i] != null ? 31 * hash + vals[i].hashCode() : (hash *= 31);
            ++i;
        }
        return this.hashCode(hash);
    }

    public int hashCode(Object val) {
        if (val != null) {
            return this.hashCode(val.hashCode());
        }
        return 0;
    }

    public static int hashCode(Object val, int capacity) {
        if (val != null) {
            int h = val.hashCode();
            if ((h = (h + (h >> 16)) % capacity) > 0) {
                return h;
            }
            return -h;
        }
        return 0;
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    public int hashCode(int h) {
        if ((h = (h + (h >> 16)) % this.capacity) > 0) {
            return h;
        }
        return -h;
    }

    public int hashCode(int[] hs, int count) {
        int h = hs[0];
        int i = 1;
        while (i < count) {
            h = 31 * h + hs[i];
            ++i;
        }
        if ((h = (h + (h >> 16)) % this.capacity) > 0) {
            return h;
        }
        return -h;
    }

    public int hashCode(IArray key, int pos) {
        int h = key.hashCode(pos);
        if ((h = (h + (h >> 16)) % this.capacity) > 0) {
            return h;
        }
        return -h;
    }

    public int hashCode(IArray[] keys, int pos, int count) {
        int h = keys[0].hashCode(pos);
        int i = 1;
        while (i < count) {
            h = 31 * h + keys[i].hashCode(pos);
            ++i;
        }
        if ((h = (h + (h >> 16)) % this.capacity) > 0) {
            return h;
        }
        return -h;
    }

    public static int bsearch_r(ListBase1 table, Object[] keys) {
        int colCount = keys.length;
        int low = 1;
        int high = table.size();
        int cmp = 0;
        while (low <= high) {
            int mid = low + high >> 1;
            BaseRecord r = (BaseRecord)table.get(mid);
            int c = 0;
            while (c < colCount) {
                cmp = Variant.compare(r.getNormalFieldValue(c), keys[c], true);
                if (cmp != 0) break;
                ++c;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    public static int bsearch_r(ListBase1 table, Object key) {
        int low = 1;
        int high = table.size();
        int cmp = 0;
        while (low <= high) {
            int mid = low + high >> 1;
            BaseRecord r = (BaseRecord)table.get(mid);
            cmp = Variant.compare(r.getNormalFieldValue(0), key, true);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    public static int bsearch_a(ListBase1 table, Object key) {
        int low = 1;
        int high = table.size();
        int cmp = 0;
        while (low <= high) {
            int mid = low + high >> 1;
            Object[] r = (Object[])table.get(mid);
            cmp = Variant.compare(r[0], key, true);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    public static int bsearch_a(ListBase1 table, Object[] keys, int count) {
        int low = 1;
        int high = table.size();
        int cmp = 0;
        while (low <= high) {
            int mid = low + high >> 1;
            Object[] r = (Object[])table.get(mid);
            int c = 0;
            while (c < count) {
                cmp = Variant.compare(r[c], keys[c], true);
                if (cmp != 0) break;
                ++c;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    public static int bsearch_g(ListBase1 table, Object key) {
        int low = 1;
        int high = table.size();
        int cmp = 0;
        while (low <= high) {
            int mid = low + high >> 1;
            Sequence group = (Sequence)table.get(mid);
            cmp = Variant.compare(group.get(1), key, true);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -low;
    }

    public int getPrevCapacity() {
        int capacity = this.capacity;
        if (capacity < 11369) {
            return 11369;
        }
        int i = 0;
        int len = PRIMES.length;
        while (i < len) {
            if (PRIMES[i] >= capacity) {
                return PRIMES[i - 1];
            }
            ++i;
        }
        return HashUtil.getNearCapacity(capacity / 2);
    }
}

