/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.common.RQException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUpload {
    private String url;
    private Hashtable<String, String> params;
    private ArrayList<String> fileArgs;
    private ArrayList<String> filePaths;
    private ArrayList<byte[]> fileBytes;
    private String resultEncoding = "UTF-8";
    private Hashtable<String, String> headers;

    public HttpUpload(String url) {
        this.url = url;
        this.params = new Hashtable();
        this.fileArgs = new ArrayList();
        this.filePaths = new ArrayList();
        this.fileBytes = new ArrayList();
        this.headers = new Hashtable();
    }

    public void setResultEncoding(String encoding) {
        this.resultEncoding = encoding;
    }

    public void addParam(String paramName, String paramValue) {
        this.params.put(paramName, paramValue);
    }

    public void setHeader(String headerName, String headerValue) {
        this.headers.put(headerName, headerValue);
    }

    public void addFile(String fileArg, String filePath) {
        this.fileArgs.add(fileArg);
        this.filePaths.add(filePath);
        this.fileBytes.add(null);
    }

    public void addFile(String fileArg, byte[] b) {
        this.fileArgs.add(fileArg);
        this.filePaths.add("noname");
        this.fileBytes.add(b);
    }

    public String upload() {
        CloseableHttpClient httpClient = null;
        String result = null;
        try {
            try {
                HttpEntity resEntity;
                httpClient = HttpClientBuilder.create().build();
                HttpPost httpPost = new HttpPost(this.url);
                Enumeration<String> emh = this.headers.keys();
                while (emh.hasMoreElements()) {
                    String header = emh.nextElement();
                    String hv = this.headers.get(header);
                    httpPost.setHeader(header, hv);
                }
                MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                builder.setCharset(Charset.forName("UTF-8"));
                builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
                int i = 0;
                while (i < this.fileArgs.size()) {
                    byte[] b = this.fileBytes.get(i);
                    if (b == null) {
                        builder.addBinaryBody(this.fileArgs.get(i), new File(this.filePaths.get(i)));
                    } else {
                        builder.addBinaryBody(this.fileArgs.get(i), b, ContentType.create((String)"Content-Type"), "noname");
                    }
                    ++i;
                }
                Enumeration<String> em = this.params.keys();
                while (em.hasMoreElements()) {
                    String arg = em.nextElement();
                    builder.addPart(arg, (ContentBody)new StringBody(this.params.get(arg), ContentType.create((String)"text/plain", (String)"UTF-8")));
                }
                HttpEntity entity = builder.build();
                httpPost.setEntity(entity);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                if (response != null && response.getStatusLine().getStatusCode() == 200 && (resEntity = response.getEntity()) != null) {
                    result = EntityUtils.toString((HttpEntity)resEntity, (String)this.resultEncoding);
                }
            }
            catch (Throwable t) {
                throw new RQException(t);
            }
        }
        finally {
            try {
                httpClient.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

