/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.array.IArray;
import com.scudata.common.RQException;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.util.XMLNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SAXTableHandler
extends DefaultHandler {
    private XMLNode root;
    private XMLNode node;
    private boolean sopt;
    private boolean bopt;

    public SAXTableHandler(String opt) {
        if (opt != null) {
            this.sopt = opt.indexOf(115) != -1;
            this.bopt = opt.indexOf(98) != -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getResult(String[] levels) {
        if (this.root == null) {
            return null;
        }
        DataStruct ds = new DataStruct(new String[]{this.root.getName()});
        Record r = new Record(ds);
        r.setNormalFieldValue(0, this.root.getResult());
        if (levels == null) {
            return r;
        }
        Object obj = r;
        String[] stringArray = levels;
        int n = levels.length;
        int n2 = 0;
        while (n2 < n) {
            String level = stringArray[n2];
            if (obj instanceof Record) {
                Object record = obj;
                int f = ((Record)record).getFieldIndex(level);
                if (f == -1) return null;
                obj = ((Record)record).getNormalFieldValue(f);
            } else {
                if (!(obj instanceof Sequence)) return null;
                obj = this.fieldValues((Sequence)obj, level);
            }
            ++n2;
        }
        return obj;
    }

    private Sequence fieldValues(Sequence seq, String fieldName) {
        IArray mems = seq.getMems();
        int size = mems.size();
        Sequence result = new Sequence(size);
        int col = -1;
        Record prevRecord = null;
        int i = 1;
        while (i <= size) {
            block6: {
                Object obj;
                block4: {
                    Record cur;
                    block5: {
                        obj = mems.get(i);
                        if (!(obj instanceof Record)) break block4;
                        cur = (Record)obj;
                        if (prevRecord != null && prevRecord.isSameDataStruct(cur)) break block5;
                        col = cur.getFieldIndex(fieldName);
                        if (col < 0) break block6;
                        prevRecord = cur;
                    }
                    result.add(cur.getFieldValue(col));
                    break block6;
                }
                if (obj instanceof Sequence) {
                    Sequence tmp = this.fieldValues((Sequence)obj, fieldName);
                    result.addAll(tmp);
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        int i = 0;
        while (i < length) {
            if (!Character.isWhitespace(ch[start + i])) {
                if (this.node == null) {
                    throw new RQException();
                }
                String str = new String(ch, start, length);
                this.node.addCharacters(str);
                break;
            }
            ++i;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        XMLNode newNode = new XMLNode(qName, this.node, this.bopt);
        if (this.sopt) {
            newNode.setAttributes(attributes);
        }
        if (this.node == null) {
            if (this.root != null) {
                throw new RQException(qName);
            }
            this.root = this.node = newNode;
        } else {
            this.node.addSub(newNode);
            this.node = newNode;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.node == null || !this.node.euqalName(qName)) {
            throw new RQException(qName);
        }
        this.node = this.node.getParent();
    }
}

