/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.ibm.icu.text.DecimalFormat;
import com.scudata.common.DateFactory;
import com.scudata.common.DateFormatFactory;
import com.scudata.common.Escape;
import com.scudata.common.MessageManager;
import com.scudata.common.ObjectCache;
import com.scudata.common.RQException;
import com.scudata.common.Sentence;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.Sequence;
import com.scudata.dm.SerialBytes;
import com.scudata.expression.fn.datetime.TimeInterval;
import com.scudata.resources.EngineMessage;
import com.scudata.util.FloatingDecimal;
import com.scudata.util.JSONUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Comparator;

public class Variant {
    public static Double INFINITY = new Double(Double.POSITIVE_INFINITY);
    public static final int Divide_Scale = 16;
    public static final int Divide_Round = 4;
    public static final int DT_INT = 1;
    public static final int DT_LONG = 2;
    public static final int DT_DOUBLE = 3;
    public static final int DT_DECIMAL = 4;
    private static final int[] DAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final int[] LEEPYEARDAYS = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final long BASEDATE;

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        BASEDATE = calendar.getTimeInMillis();
    }

    public static long getBaseDate() {
        return BASEDATE;
    }

    public static boolean isTrue(Object o) {
        return o != null && (!(o instanceof Boolean) || (Boolean)o != false);
    }

    public static boolean isFalse(Object o) {
        return o == null || o instanceof Boolean && (Boolean)o == false;
    }

    public static java.util.Date add(java.util.Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        java.util.Date result = (java.util.Date)date.clone();
        result.setTime(calendar.getTimeInMillis());
        return result;
    }

    public static Object add(Object o1, Object o2) {
        if (o1 == null) {
            return o2;
        }
        if (o2 == null) {
            return o1;
        }
        if (o1 instanceof Number) {
            if (o2 instanceof Number) {
                return Variant.addNum((Number)o1, (Number)o2);
            }
            if (o2 instanceof String) {
                Number n2 = Variant.parseNumber((String)o2);
                if (n2 == null) {
                    return o1;
                }
                return Variant.addNum((Number)o1, n2);
            }
            if (o2 instanceof java.util.Date) {
                java.util.Date date1 = (java.util.Date)o2;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date1);
                calendar.add(5, ((Number)o1).intValue());
                java.util.Date date = (java.util.Date)date1.clone();
                date.setTime(calendar.getTimeInMillis());
                return date;
            }
        } else if (o1 instanceof java.util.Date) {
            if (o2 instanceof Number) {
                java.util.Date date1 = (java.util.Date)o1;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date1);
                calendar.add(5, ((Number)o2).intValue());
                java.util.Date date = (java.util.Date)date1.clone();
                date.setTime(calendar.getTimeInMillis());
                return date;
            }
        } else if (o1 instanceof String) {
            if (o2 instanceof String) {
                return String.valueOf((String)o1) + o2;
            }
            if (o2 instanceof Number) {
                Number n1 = Variant.parseNumber((String)o1);
                if (n1 == null) {
                    return o2;
                }
                return Variant.addNum(n1, (Number)o2);
            }
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(o1)) + mm.getMessage("Variant2.with") + Variant.getDataType(o2) + mm.getMessage("Variant2.illAdd"));
    }

    public static Number addNum(Number n1, Number n2) {
        int type = Variant.getMaxNumberType(n1, n2);
        switch (type) {
            case 1: 
            case 2: {
                return new Long(n1.longValue() + n2.longValue());
            }
            case 3: {
                return new Double(n1.doubleValue() + n2.doubleValue());
            }
            case 4: {
                return Variant.toBigDecimal(n1).add(Variant.toBigDecimal(n2));
            }
        }
        throw new RQException();
    }

    public static Object add1(Object o1) {
        if (o1 == null) {
            return new Integer(1);
        }
        int type = Variant.getNumberType(o1);
        switch (type) {
            case 1: 
            case 2: {
                return new Long(((Number)o1).longValue() + 1L);
            }
            case 3: {
                return new Double(((Number)o1).doubleValue() + 1.0);
            }
            case 4: {
                return Variant.toBigDecimal((Number)o1).add(new BigDecimal(1));
            }
        }
        throw new RQException();
    }

    public static Object subtract(Object o1, Object o2) {
        if (o2 == null) {
            return o1;
        }
        if (o1 == null) {
            return Variant.negate(o2);
        }
        if (o1 instanceof Number) {
            if (o2 instanceof Number) {
                int type = Variant.getMaxNumberType(o1, o2);
                switch (type) {
                    case 1: {
                        return new Integer(((Number)o1).intValue() - ((Number)o2).intValue());
                    }
                    case 2: {
                        return new Long(((Number)o1).longValue() - ((Number)o2).longValue());
                    }
                    case 3: {
                        return new Double(((Number)o1).doubleValue() - ((Number)o2).doubleValue());
                    }
                    case 4: {
                        return Variant.toBigDecimal((Number)o1).subtract(Variant.toBigDecimal((Number)o2));
                    }
                }
                throw new RQException();
            }
        } else if (o1 instanceof java.util.Date) {
            if (o2 instanceof java.util.Date) {
                return new Long(Variant.interval((java.util.Date)o2, (java.util.Date)o1, null));
            }
            if (o2 instanceof Number) {
                java.util.Date date1 = (java.util.Date)o1;
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date1);
                calendar.add(5, -((Number)o2).intValue());
                java.util.Date date = (java.util.Date)date1.clone();
                date.setTime(calendar.getTimeInMillis());
                return date;
            }
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(o1)) + mm.getMessage("Variant2.with") + Variant.getDataType(o2) + mm.getMessage("Variant2.illSubtract"));
    }

    public static Object square(Object obj) {
        if (obj == null) {
            return null;
        }
        int type = Variant.getNumberType(obj);
        switch (type) {
            case 1: {
                int i = ((Number)obj).intValue();
                return new Integer(i * i);
            }
            case 2: {
                long l = ((Number)obj).longValue();
                return new Long(l * l);
            }
            case 3: {
                double d = ((Number)obj).doubleValue();
                return new Double(d * d);
            }
            case 4: {
                BigDecimal bd = Variant.toBigDecimal((Number)obj);
                return bd.multiply(bd);
            }
        }
        throw new RQException();
    }

    public static Object multiply(Object o1, Object o2) {
        if (o1 instanceof Number) {
            if (o2 instanceof Number) {
                int type = Variant.getMaxNumberType(o1, o2);
                switch (type) {
                    case 1: 
                    case 2: {
                        return new Long(((Number)o1).longValue() * ((Number)o2).longValue());
                    }
                    case 3: {
                        return new Double(((Number)o1).doubleValue() * ((Number)o2).doubleValue());
                    }
                    case 4: {
                        return Variant.toBigDecimal((Number)o1).multiply(Variant.toBigDecimal((Number)o2));
                    }
                }
                throw new RQException();
            }
            if (o2 instanceof Sequence) {
                return ((Sequence)o2).multiply(((Number)o1).intValue());
            }
            if (o2 == null) {
                return null;
            }
        } else if (o1 instanceof Sequence) {
            if (o2 instanceof Number) {
                return ((Sequence)o1).multiply(((Number)o2).intValue());
            }
            if (o2 == null) {
                return null;
            }
        } else if (o1 == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(o1)) + mm.getMessage("Variant2.with") + Variant.getDataType(o2) + mm.getMessage("Variant2.illMultiply"));
    }

    public static Object mod(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return null;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            int type = Variant.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    return new Integer(((Number)o1).intValue() % ((Number)o2).intValue());
                }
                case 2: {
                    return new Long(((Number)o1).longValue() % ((Number)o2).longValue());
                }
                case 3: {
                    return new Double(((Number)o1).doubleValue() % ((Number)o2).doubleValue());
                }
            }
            return new BigDecimal(Variant.toBigInteger((Number)o1).mod(Variant.toBigInteger((Number)o2)));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(o1)) + mm.getMessage("Variant2.with") + Variant.getDataType(o2) + mm.getMessage("Variant2.illMod"));
    }

    public static Number mod(Number n1, Number n2) {
        int type = Variant.getMaxNumberType(n1, n2);
        switch (type) {
            case 1: {
                return ObjectCache.getInteger(n1.intValue() % n2.intValue());
            }
            case 2: {
                return new Long(n1.longValue() % n2.longValue());
            }
            case 3: {
                return new Double(n1.doubleValue() % n2.doubleValue());
            }
        }
        return new BigDecimal(Variant.toBigInteger(n1).mod(Variant.toBigInteger(n2)));
    }

    public static Number remainder(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return null;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            int type = Variant.getMaxNumberType(o1, o2);
            if (type == 1) {
                int left = ((Number)o1).intValue();
                int right = ((Number)o2).intValue();
                if (right > 0) {
                    if (left > 0) {
                        return left % right;
                    }
                    int x = left % right;
                    return x == 0 ? 0 : x + right;
                }
                if (left >= 0) {
                    int x = left % (right * 2);
                    return x < -right ? x : x + right * 2;
                }
                int x = left % (right * 2);
                return x < right ? x - right * 2 : x;
            }
            if (type == 2) {
                long left = ((Number)o1).longValue();
                long right = ((Number)o2).longValue();
                if (right > 0L) {
                    if (left > 0L) {
                        return left % right;
                    }
                    long x = left % right;
                    return x == 0L ? 0L : x + right;
                }
                if (left >= 0L) {
                    long x = left % (right * 2L);
                    return x < -right ? x : x + right * 2L;
                }
                long x = left % (right * 2L);
                return x < right ? x - right * 2L : x;
            }
            double left = ((Number)o1).doubleValue();
            double right = ((Number)o2).doubleValue();
            if (right > 0.0) {
                if (left > 0.0) {
                    return left % right;
                }
                double x = left % right;
                return Variant.isRoughlyEquals(x, 0.0) ? 0.0 : x + right;
            }
            if (left >= 0.0) {
                double x = left % (right * 2.0);
                return x > -right || Variant.isRoughlyEquals(x, -right) ? x + right * 2.0 : x;
            }
            double x = left % (right * 2.0);
            return x < right && !Variant.isRoughlyEquals(x, right) ? x - right * 2.0 : x;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(o1)) + mm.getMessage("Variant2.with") + Variant.getDataType(o2) + mm.getMessage("Variant2.illMod"));
    }

    private static boolean isRoughlyEquals(double d1, double d2) {
        return (d1 -= d2) > -1.0E-7 && d1 < 1.0E-7;
    }

    public static Object divide(Object o1, Object o2) {
        if (o1 instanceof Number && o2 instanceof Number) {
            int type = Variant.getMaxNumberType(o1, o2);
            try {
                if (type == 4) {
                    return Variant.toBigDecimal((Number)o1).divide(Variant.toBigDecimal((Number)o2), 16, 4);
                }
                return new Double(((Number)o1).doubleValue() / ((Number)o2).doubleValue());
            }
            catch (ArithmeticException e) {
                throw new RQException(e.getMessage());
            }
        }
        if (o1 instanceof String) {
            if (o2 == null) {
                return o1;
            }
            return String.valueOf((String)o1) + o2;
        }
        if (o2 instanceof String) {
            if (o1 == null) {
                return o2;
            }
            return o1 + (String)o2;
        }
        if (o1 == null || o2 == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(o1)) + mm.getMessage("Variant2.with") + Variant.getDataType(o2) + mm.getMessage("Variant2.illDivide"));
    }

    public static Object avg(Object sum, int count) {
        if (sum instanceof BigDecimal) {
            return ((BigDecimal)sum).divide(new BigDecimal(count), 16, 4);
        }
        if (sum instanceof BigInteger) {
            BigDecimal decimal = new BigDecimal((BigInteger)sum);
            return decimal.divide(new BigDecimal(count), 16, 4);
        }
        if (sum instanceof Number) {
            return new Double(((Number)sum).doubleValue() / (double)count);
        }
        if (sum == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(sum)) + mm.getMessage("engine.illEverage"));
    }

    public static Number intDivide(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return null;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            int type = Variant.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    return new Integer(((Number)o1).intValue() / ((Number)o2).intValue());
                }
                case 2: 
                case 3: {
                    return new Long(((Number)o1).longValue() / ((Number)o2).longValue());
                }
            }
            return new BigDecimal(Variant.toBigInteger((Number)o1).divide(Variant.toBigInteger((Number)o2)));
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(Variant.getDataType(o1)) + mm.getMessage("Variant2.with") + Variant.getDataType(o2) + mm.getMessage("Variant2.illDivide"));
    }

    public static Number intDivide(Number n1, Number n2) {
        int type = Variant.getMaxNumberType(n1, n2);
        switch (type) {
            case 1: {
                return ObjectCache.getInteger(n1.intValue() / n2.intValue());
            }
            case 2: 
            case 3: {
                return new Long(n1.longValue() / n2.longValue());
            }
        }
        return new BigDecimal(Variant.toBigInteger(n1).divide(Variant.toBigInteger(n2)));
    }

    public static Object abs(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RuntimeException(String.valueOf(Variant.getDataType(o)) + mm.getMessage("Variant2.illAbs"));
        }
        int type = Variant.getNumberType(o);
        switch (type) {
            case 1: {
                return new Integer(Math.abs(((Number)o).intValue()));
            }
            case 2: {
                return new Long(Math.abs(((Number)o).longValue()));
            }
            case 3: {
                return new Double(Math.abs(((Number)o).doubleValue()));
            }
            case 4: {
                return Variant.toBigDecimal((Number)o).abs();
            }
        }
        throw new RQException();
    }

    public static Number abs(Number o) {
        int type = Variant.getNumberType(o);
        switch (type) {
            case 1: {
                return new Integer(Math.abs(o.intValue()));
            }
            case 2: {
                return new Long(Math.abs(o.longValue()));
            }
            case 3: {
                return new Double(Math.abs(o.doubleValue()));
            }
            case 4: {
                return Variant.toBigDecimal(o).abs();
            }
        }
        throw new RQException();
    }

    public static int compare(Object o1, Object o2) {
        return Variant.compare(o1, o2, true);
    }

    public static int compareArrays(Object[] o1, Object[] o2) {
        int i = 0;
        int len = o1.length;
        while (i < len) {
            int cmp = Variant.compare(o1[i], o2[i], true);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public static int compareArrays_0(Object[] o1, Object[] o2) {
        int i = 0;
        int len = o1.length;
        while (i < len) {
            int cmp = Variant.compare_0(o1[i], o2[i]);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public static int compareArrays_0(Object[] o1, Object[] o2, int len) {
        int i = 0;
        while (i < len) {
            int cmp = Variant.compare_0(o1[i], o2[i]);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public static int compareArrays_0(Object[] o1, Object[] o2, int len, Comparator<Object> locCmp) {
        int i = 0;
        while (i < len) {
            int cmp = Variant.compare_0(o1[i], o2[i], locCmp);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public static int compareArrays(Object[] o1, Object[] o2, int len, Comparator<Object> locCmp) {
        int i = 0;
        while (i < len) {
            int cmp = Variant.compare(o1[i], o2[i], locCmp, true);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public static int compareArrays(Object[] o1, Object[] o2, int len) {
        int i = 0;
        while (i < len) {
            int cmp = Variant.compare(o1[i], o2[i], true);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return 0;
    }

    public static int compare(Object o1, Object o2, boolean throwExcept) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            int type = Variant.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    int num1 = ((Number)o1).intValue();
                    int num2 = ((Number)o2).intValue();
                    return num1 < num2 ? -1 : (num1 == num2 ? 0 : 1);
                }
                case 2: {
                    long long1 = ((Number)o1).longValue();
                    long long2 = ((Number)o2).longValue();
                    return long1 < long2 ? -1 : (long1 == long2 ? 0 : 1);
                }
                case 3: {
                    return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
                }
                case 4: {
                    return Variant.toBigDecimal((Number)o1).compareTo(Variant.toBigDecimal((Number)o2));
                }
            }
            throw new RQException();
        }
        if (o1 instanceof String && o2 instanceof String) {
            int cmp = ((String)o1).compareTo((String)o2);
            return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
        }
        if (o1 instanceof java.util.Date && o2 instanceof java.util.Date) {
            long anotherTime;
            long thisTime = ((java.util.Date)o1).getTime();
            return thisTime < (anotherTime = ((java.util.Date)o2).getTime()) ? -1 : (thisTime == anotherTime ? 0 : 1);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return Variant.compare((Boolean)o1, (Boolean)o2);
        }
        if (o1 instanceof Sequence && o2 instanceof Sequence) {
            return ((Sequence)o1).compareTo((Sequence)o2);
        }
        if (o1 instanceof BaseRecord && o2 instanceof BaseRecord) {
            return ((BaseRecord)o1).compareTo((BaseRecord)o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Variant.compareArrays((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof SerialBytes && o2 instanceof SerialBytes) {
            return ((SerialBytes)o1).compareTo((SerialBytes)o2);
        }
        if (o1 instanceof Comparable) {
            return ((Comparable)o1).compareTo(o2);
        }
        if (throwExcept) {
            String s1 = Variant.renderText(o1);
            String s2 = Variant.renderText(o2);
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", s1, s2, Variant.getDataType(o1), Variant.getDataType(o2)));
        }
        return Variant.getType(o1) < Variant.getType(o2) ? -1 : 1;
    }

    private static String renderText(Object val) {
        if (val == null) {
            return "null";
        }
        if (val instanceof Sequence) {
            Sequence seq = (Sequence)val;
            int len = seq.length();
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            int min = len > 3 ? 3 : len;
            int i = 1;
            while (i <= min) {
                if (i > 1) {
                    sb.append(",");
                }
                Object v = seq.get(i);
                sb.append(Variant.renderText(v));
                ++i;
            }
            if (len > 3) {
                sb.append(", ...");
            }
            sb.append("]");
            return sb.toString();
        }
        return val.toString();
    }

    public static int compare_0(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            int type = Variant.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    int num1 = ((Number)o1).intValue();
                    int num2 = ((Number)o2).intValue();
                    return num1 < num2 ? -1 : (num1 == num2 ? 0 : 1);
                }
                case 2: {
                    long long1 = ((Number)o1).longValue();
                    long long2 = ((Number)o2).longValue();
                    return long1 < long2 ? -1 : (long1 == long2 ? 0 : 1);
                }
                case 3: {
                    return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
                }
                case 4: {
                    return Variant.toBigDecimal((Number)o1).compareTo(Variant.toBigDecimal((Number)o2));
                }
            }
            throw new RQException();
        }
        if (o1 instanceof String && o2 instanceof String) {
            int cmp = ((String)o1).compareTo((String)o2);
            return cmp < 0 ? -1 : (cmp > 0 ? 1 : 0);
        }
        if (o1 instanceof java.util.Date && o2 instanceof java.util.Date) {
            long anotherTime;
            long thisTime = ((java.util.Date)o1).getTime();
            return thisTime < (anotherTime = ((java.util.Date)o2).getTime()) ? -1 : (thisTime == anotherTime ? 0 : 1);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return Variant.compare((Boolean)o1, (Boolean)o2);
        }
        if (o1 instanceof Sequence && o2 instanceof Sequence) {
            return ((Sequence)o1).compareTo((Sequence)o2);
        }
        if (o1 instanceof BaseRecord && o2 instanceof BaseRecord) {
            int h2;
            int h1 = o1.hashCode();
            if (h1 < (h2 = o2.hashCode())) {
                return -1;
            }
            if (h1 > h2) {
                return 1;
            }
            return Variant.compare_0(((BaseRecord)o1).value(), ((BaseRecord)o2).value());
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Variant.compareArrays((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof SerialBytes && o2 instanceof SerialBytes) {
            return ((SerialBytes)o1).compareTo((SerialBytes)o2);
        }
        String s1 = Variant.renderText(o1);
        String s2 = Variant.renderText(o2);
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", s1, s2, Variant.getDataType(o1), Variant.getDataType(o2)));
    }

    private static int getType(Object o) {
        if (o instanceof Number) {
            return 1;
        }
        if (o instanceof String) {
            return 2;
        }
        if (o instanceof java.util.Date) {
            return 3;
        }
        if (o instanceof Boolean) {
            return 4;
        }
        if (o == null) {
            return 0;
        }
        return 5;
    }

    public static int compare(Object o1, Object o2, Comparator<Object> locCmp, boolean throwExcept) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return locCmp.compare(o1, o2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            int type = Variant.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    int num1 = ((Number)o1).intValue();
                    int num2 = ((Number)o2).intValue();
                    return num1 < num2 ? -1 : (num1 == num2 ? 0 : 1);
                }
                case 2: {
                    long long1 = ((Number)o1).longValue();
                    long long2 = ((Number)o2).longValue();
                    return long1 < long2 ? -1 : (long1 == long2 ? 0 : 1);
                }
                case 3: {
                    return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
                }
                case 4: {
                    return Variant.toBigDecimal((Number)o1).compareTo(Variant.toBigDecimal((Number)o2));
                }
            }
            throw new RQException();
        }
        if (o1 instanceof java.util.Date && o2 instanceof java.util.Date) {
            long anotherTime;
            long thisTime = ((java.util.Date)o1).getTime();
            return thisTime < (anotherTime = ((java.util.Date)o2).getTime()) ? -1 : (thisTime == anotherTime ? 0 : 1);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return Variant.compare((Boolean)o1, (Boolean)o2);
        }
        if (o1 instanceof Sequence && o2 instanceof Sequence) {
            return ((Sequence)o1).compareTo((Sequence)o2, locCmp);
        }
        if (o1 instanceof BaseRecord && o2 instanceof BaseRecord) {
            return ((BaseRecord)o1).compareTo((BaseRecord)o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Variant.compareArrays((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof SerialBytes && o2 instanceof SerialBytes) {
            return ((SerialBytes)o1).compareTo((SerialBytes)o2);
        }
        if (throwExcept) {
            String s1 = Variant.renderText(o1);
            String s2 = Variant.renderText(o2);
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("Variant2.illCompare", s1, s2, Variant.getDataType(o1), Variant.getDataType(o2)));
        }
        return Variant.getType(o1) < Variant.getType(o2) ? -1 : 1;
    }

    public static int compare_0(Object o1, Object o2, Comparator<Object> locCmp) {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        if (o1 instanceof String && o2 instanceof String) {
            return locCmp.compare(o1, o2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            int type = Variant.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    int num1 = ((Number)o1).intValue();
                    int num2 = ((Number)o2).intValue();
                    return num1 < num2 ? -1 : (num1 == num2 ? 0 : 1);
                }
                case 2: {
                    long long1 = ((Number)o1).longValue();
                    long long2 = ((Number)o2).longValue();
                    return long1 < long2 ? -1 : (long1 == long2 ? 0 : 1);
                }
                case 3: {
                    return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
                }
                case 4: {
                    return Variant.toBigDecimal((Number)o1).compareTo(Variant.toBigDecimal((Number)o2));
                }
            }
            throw new RQException();
        }
        if (o1 instanceof java.util.Date && o2 instanceof java.util.Date) {
            long anotherTime;
            long thisTime = ((java.util.Date)o1).getTime();
            return thisTime < (anotherTime = ((java.util.Date)o2).getTime()) ? -1 : (thisTime == anotherTime ? 0 : 1);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return Variant.compare((Boolean)o1, (Boolean)o2);
        }
        if (o1 instanceof Sequence && o2 instanceof Sequence) {
            return ((Sequence)o1).compareTo((Sequence)o2, locCmp);
        }
        if (o1 instanceof BaseRecord && o2 instanceof BaseRecord) {
            int h2;
            int h1 = o1.hashCode();
            if (h1 < (h2 = o2.hashCode())) {
                return -1;
            }
            if (h1 > h2) {
                return 1;
            }
            return Variant.compare_0(((BaseRecord)o1).value(), ((BaseRecord)o2).value(), locCmp);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Variant.compareArrays((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof SerialBytes && o2 instanceof SerialBytes) {
            return ((SerialBytes)o1).compareTo((SerialBytes)o2);
        }
        String s1 = Variant.renderText(o1);
        String s2 = Variant.renderText(o2);
        MessageManager mm = EngineMessage.get();
        throw new RQException(mm.getMessage("Variant2.illCompare", s1, s2, Variant.getDataType(o1), Variant.getDataType(o2)));
    }

    public static boolean isEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            int type = Variant.getMaxNumberType(o1, o2);
            switch (type) {
                case 1: {
                    return ((Number)o1).intValue() == ((Number)o2).intValue();
                }
                case 2: {
                    return ((Number)o1).longValue() == ((Number)o2).longValue();
                }
                case 3: {
                    return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue()) == 0;
                }
                case 4: {
                    return Variant.toBigDecimal((Number)o1).compareTo(Variant.toBigDecimal((Number)o2)) == 0;
                }
            }
            throw new RQException();
        }
        if (o1 instanceof String && o2 instanceof String) {
            return ((String)o1).equals(o2);
        }
        if (o1 instanceof java.util.Date && o2 instanceof java.util.Date) {
            return ((java.util.Date)o1).getTime() == ((java.util.Date)o2).getTime();
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            return ((Boolean)o1).booleanValue() == ((Boolean)o2).booleanValue();
        }
        if (o1 instanceof Sequence && o2 instanceof Sequence) {
            return ((Sequence)o1).isEquals((Sequence)o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Variant.isEquals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof SerialBytes && o2 instanceof SerialBytes) {
            return ((SerialBytes)o1).equals((SerialBytes)o2);
        }
        if (o1 instanceof TimeInterval) {
            return ((TimeInterval)o1).equals(o2);
        }
        return false;
    }

    public static Object round(Object o) {
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).setScale(0, 4);
        }
        if (o instanceof Double || o instanceof Float) {
            double d = ((Number)o).doubleValue();
            if (d > -9.223372036854776E18 && d < 9.223372036854776E18) {
                return new Double(Math.round(d));
            }
            return o;
        }
        if (o instanceof Number) {
            return o;
        }
        if (o == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("round" + mm.getMessage("function.paramTypeError"));
    }

    public static Object round(Object o, int scale) {
        if (o instanceof BigDecimal) {
            if (scale < 0) {
                return ((BigDecimal)o).setScale(scale, 4).setScale(0);
            }
            return ((BigDecimal)o).setScale(scale, 4);
        }
        if (o instanceof Double || o instanceof Float) {
            double s = Math.pow(10.0, scale);
            double d = ((Number)o).doubleValue() * s;
            if (d > -9.223372036854776E18 && d < 9.223372036854776E18) {
                return new Double((double)Math.round(d) / s);
            }
            return new Double(d / s);
        }
        if (o instanceof Number) {
            double s = Math.pow(10.0, scale);
            double d = (double)((Number)o).longValue() * s;
            if (o instanceof Integer) {
                return new Integer((int)((double)Math.round(d) / s));
            }
            return new Long((long)((double)Math.round(d) / s));
        }
        if (o == null) {
            return null;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException("round" + mm.getMessage("function.paramTypeError"));
    }

    public static Object negate(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof Number)) {
            MessageManager mm = EngineMessage.get();
            throw new RuntimeException(String.valueOf(Variant.getDataType(o)) + mm.getMessage("Variant2.illNegate"));
        }
        int type = Variant.getNumberType(o);
        switch (type) {
            case 1: {
                return new Integer(-((Number)o).intValue());
            }
            case 2: {
                return new Long(-((Number)o).longValue());
            }
            case 3: {
                return new Double(-((Number)o).doubleValue());
            }
            case 4: {
                return Variant.toBigDecimal((Number)o).negate();
            }
        }
        throw new RQException();
    }

    public static Number negate(Number o) {
        int type = Variant.getNumberType(o);
        switch (type) {
            case 1: {
                return new Integer(-o.intValue());
            }
            case 2: {
                return new Long(-o.longValue());
            }
            case 3: {
                return new Double(-o.doubleValue());
            }
            case 4: {
                return Variant.toBigDecimal(o).negate();
            }
        }
        throw new RQException();
    }

    public static String negate(String str) {
        char[] chars = str.toCharArray();
        int last = chars.length - 1;
        if (last >= 0) {
            int i = 0;
            while (i < last) {
                chars[i] = (char)(65535 - chars[i]);
                ++i;
            }
            chars[last] = (char)(65536 - chars[last]);
        }
        return new String(chars);
    }

    public static java.util.Date negate(java.util.Date date) {
        java.util.Date result = (java.util.Date)date.clone();
        result.setTime(-date.getTime());
        return result;
    }

    public static int compare(boolean b1, boolean b2) {
        if (b1) {
            return b2 ? 0 : 1;
        }
        return b2 ? -1 : 0;
    }

    private static int getNumberType(Object o) {
        if (o instanceof Integer) {
            return 1;
        }
        if (o instanceof Double) {
            return 3;
        }
        if (o instanceof BigDecimal) {
            return 4;
        }
        if (o instanceof Long) {
            return 2;
        }
        if (o instanceof BigInteger) {
            return 4;
        }
        if (o instanceof Float) {
            return 3;
        }
        if (o instanceof Number) {
            return 1;
        }
        MessageManager mm = EngineMessage.get();
        throw new RQException(String.valueOf(o.getClass().getName()) + ": " + mm.getMessage("DataType.UnknownNum"));
    }

    public static int getMaxNumberType(Object o1, Object o2) {
        int type2;
        int type1 = Variant.getNumberType(o1);
        return type1 > (type2 = Variant.getNumberType(o2)) ? type1 : type2;
    }

    private static BigDecimal toBigDecimal(Number o) {
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof BigInteger) {
            return new BigDecimal((BigInteger)o);
        }
        if (o instanceof Long) {
            return new BigDecimal((Long)o);
        }
        return new BigDecimal(o.doubleValue());
    }

    public static BigInteger toBigInteger(Number o) {
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toBigInteger();
        }
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        return BigInteger.valueOf(o.longValue());
    }

    public static String toString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return DateFormatFactory.get().getDateFormat().format((java.util.Date)o);
        }
        if (o instanceof Time) {
            return DateFormatFactory.get().getTimeFormat().format((java.util.Date)o);
        }
        if (o instanceof Timestamp) {
            return DateFormatFactory.get().getDateTimeFormat().format((java.util.Date)o);
        }
        if (o instanceof java.util.Date) {
            return DateFormatFactory.get().getDateTimeFormat().format((java.util.Date)o);
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        return o.toString();
    }

    public static String toExportString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return DateFormatFactory.get().getDateFormat().format((java.util.Date)o);
        }
        if (o instanceof Timestamp) {
            return DateFormatFactory.get().getDateTimeFormat().format((java.util.Date)o);
        }
        if (o instanceof Time) {
            return DateFormatFactory.get().getTimeFormat().format((java.util.Date)o);
        }
        if (o instanceof Sequence) {
            return JSONUtil.toJSON((Sequence)o);
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o instanceof BaseRecord) {
            return JSONUtil.toJSON((BaseRecord)o);
        }
        return o.toString();
    }

    public static String toExportString(Object o, char escapeChar) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return DateFormatFactory.get().getDateFormat().format((java.util.Date)o);
        }
        if (o instanceof Timestamp) {
            return DateFormatFactory.get().getDateTimeFormat().format((java.util.Date)o);
        }
        if (o instanceof Time) {
            return DateFormatFactory.get().getTimeFormat().format((java.util.Date)o);
        }
        if (o instanceof String) {
            if (escapeChar == '\"') {
                return Escape.addExcelQuote((String)o);
            }
            return Escape.addEscAndQuote((String)o, escapeChar);
        }
        if (o instanceof Sequence) {
            return JSONUtil.toJSON((Sequence)o);
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o instanceof BaseRecord) {
            return JSONUtil.toJSON((BaseRecord)o);
        }
        return o.toString();
    }

    public static boolean canConvertToString(Object obj) {
        if (obj instanceof BaseRecord) {
            return false;
        }
        return !(obj instanceof Sequence) || !((Sequence)obj).hasRecord();
    }

    public static String format(Object o, String format) {
        if (o instanceof java.util.Date) {
            if (format == null) {
                if (o instanceof Date) {
                    return DateFormatFactory.get().getDateFormat().format((java.util.Date)o);
                }
                if (o instanceof Time) {
                    return DateFormatFactory.get().getTimeFormat().format((java.util.Date)o);
                }
                return DateFormatFactory.get().getDateTimeFormat().format((java.util.Date)o);
            }
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            return sdf.format(o);
        }
        if (o instanceof Number) {
            DecimalFormat nf = new DecimalFormat(format);
            nf.setRoundingMode(4);
            return nf.format(o);
        }
        if (o instanceof Sequence) {
            Sequence series = (Sequence)o;
            StringBuffer sb = new StringBuffer();
            int i = 1;
            int size = series.length();
            while (i <= size) {
                if (i > 1) {
                    sb.append(',');
                }
                sb.append(Variant.format(series.getMem(i), format));
                ++i;
            }
            return sb.toString();
        }
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            try {
                return new String((byte[])o, format);
            }
            catch (UnsupportedEncodingException e) {
                throw new RQException(e.getMessage(), e);
            }
        }
        return o.toString();
    }

    public static String format(Object o, String format, String locale) {
        if (o instanceof java.util.Date) {
            return DateFormatFactory.get().getFormat(format, locale).format((java.util.Date)o);
        }
        if (o instanceof Number) {
            DecimalFormat nf = new DecimalFormat(format);
            nf.setRoundingMode(4);
            return nf.format(o);
        }
        if (o instanceof Sequence) {
            Sequence series = (Sequence)o;
            StringBuffer sb = new StringBuffer();
            int i = 1;
            int size = series.length();
            while (i <= size) {
                if (i > 1) {
                    sb.append(',');
                }
                sb.append(Variant.format(series.getMem(i), format, locale));
                ++i;
            }
            return sb.toString();
        }
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            String str = new String((byte[])o);
            return Variant.format(str, format, locale);
        }
        return o.toString();
    }

    public static long longValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(o + mm.getMessage("Variant2.longValue"));
    }

    public static double doubleValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(o + mm.getMessage("Variant2.doubleValue"));
    }

    public static BigDecimal toBigDecimal(Object o) {
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof BigInteger) {
            return new BigDecimal((BigInteger)o);
        }
        if (o instanceof Long) {
            return new BigDecimal((Long)o);
        }
        if (o instanceof Number) {
            return new BigDecimal(((Number)o).doubleValue());
        }
        MessageManager mm = EngineMessage.get();
        throw new RuntimeException(o + mm.getMessage("Variant2.doubleValue"));
    }

    public static byte getObjectType(Object obj) {
        if (obj instanceof String) {
            return 11;
        }
        if (obj instanceof Integer) {
            return 1;
        }
        if (obj instanceof Double) {
            return 6;
        }
        if (obj instanceof Date) {
            return 8;
        }
        if (obj instanceof BigDecimal) {
            return 7;
        }
        if (obj instanceof Long) {
            return 2;
        }
        if (obj instanceof Timestamp) {
            return 10;
        }
        if (obj instanceof Time) {
            return 9;
        }
        if (obj instanceof Boolean) {
            return 12;
        }
        return 0;
    }

    public static Object convert(Object val, byte type) {
        if (val instanceof String) {
            return Variant.parseCellValue((String)val, type);
        }
        if (val == null) {
            return null;
        }
        switch (type) {
            case 11: {
                return Variant.toString(val);
            }
            case 1: {
                if (val instanceof Integer) {
                    return val;
                }
                if (!(val instanceof Number)) break;
                return new Integer(((Number)val).intValue());
            }
            case 6: {
                if (val instanceof Double) {
                    return val;
                }
                if (!(val instanceof Number)) break;
                return new Double(((Number)val).doubleValue());
            }
            case 8: {
                if (val instanceof Date) {
                    return val;
                }
                if (val instanceof java.util.Date) {
                    return new Date(((java.util.Date)val).getTime());
                }
                if (!(val instanceof Number)) break;
                return new Date(((Number)val).longValue());
            }
            case 7: {
                if (!(val instanceof Number)) break;
                return Variant.toBigDecimal((Number)val);
            }
            case 2: {
                if (val instanceof Long) {
                    return val;
                }
                if (!(val instanceof Number)) break;
                return new Long(((Number)val).longValue());
            }
            case 10: {
                if (val instanceof Timestamp) {
                    return val;
                }
                if (val instanceof java.util.Date) {
                    return new Timestamp(((java.util.Date)val).getTime());
                }
                if (!(val instanceof Number)) break;
                return new Timestamp(((Number)val).longValue());
            }
            case 9: {
                if (val instanceof Time) {
                    return val;
                }
                if (val instanceof java.util.Date) {
                    return new Time(((java.util.Date)val).getTime());
                }
                if (!(val instanceof Number)) break;
                return new Time(((Number)val).longValue());
            }
        }
        return val;
    }

    public static Object parse(String text) {
        return Variant.parse(text, true);
    }

    public static Object parse(String text, boolean removeEscAndQuote) {
        FloatingDecimal fd3;
        if (text == null || text.length() == 0) {
            return null;
        }
        String s = text.trim();
        int len = s.length();
        if (len == 0) {
            return text;
        }
        char ch0 = s.charAt(0);
        if (ch0 == '\"' || ch0 == '\'') {
            int match;
            if (removeEscAndQuote && (match = Sentence.scanQuotation(s, 0)) == len - 1) {
                return Escape.remove(s.substring(1, match));
            }
            return text;
        }
        Number numObj = Variant.parseInt(s);
        if (numObj != null) {
            return numObj;
        }
        numObj = Variant.parseLong(s);
        if (numObj != null) {
            return numObj;
        }
        if (s.endsWith("%")) {
            try {
                fd3 = FloatingDecimal.readJavaFormatString(s.substring(0, s.length() - 1));
                if (fd3 != null) {
                    return new Double(fd3.doubleValue() / 100.0);
                }
            }
            catch (RuntimeException fd2) {}
        } else {
            try {
                fd3 = FloatingDecimal.readJavaFormatString(s);
                if (fd3 != null) {
                    return new Double(fd3.doubleValue());
                }
            }
            catch (RuntimeException fd3) {
                // empty catch block
            }
        }
        if (len > 2 && ch0 == '0' && (s.charAt(1) == 'X' || s.charAt(1) == 'x') && (numObj = Variant.parseLong(s.substring(2), 16)) != null) {
            return numObj;
        }
        if (s.equals("null")) {
            return null;
        }
        if (s.equals("true")) {
            return Boolean.TRUE;
        }
        if (s.equals("false")) {
            return Boolean.FALSE;
        }
        if (ch0 == '[' || ch0 == '{') {
            char[] chars = s.toCharArray();
            Object obj = JSONUtil.parseJSON(chars, 0, chars.length - 1);
            if (obj != null) {
                return obj;
            }
            return text;
        }
        return Variant.parseDate(text);
    }

    public static Object parseDirect(String s) {
        FloatingDecimal fd3;
        if (s == null || s.length() == 0) {
            return null;
        }
        char ch0 = s.charAt(0);
        if (ch0 == '\"' || ch0 == '\'') {
            return s;
        }
        Number numObj = Variant.parseInt(s);
        if (numObj != null) {
            return numObj;
        }
        numObj = Variant.parseLong(s);
        if (numObj != null) {
            return numObj;
        }
        if (s.endsWith("%")) {
            try {
                fd3 = FloatingDecimal.readJavaFormatString(s.substring(0, s.length() - 1));
                if (fd3 != null) {
                    return new Double(fd3.doubleValue() / 100.0);
                }
            }
            catch (RuntimeException fd2) {}
        } else {
            try {
                fd3 = FloatingDecimal.readJavaFormatString(s);
                if (fd3 != null) {
                    return new Double(fd3.doubleValue());
                }
            }
            catch (RuntimeException fd3) {
                // empty catch block
            }
        }
        int len = s.length();
        if (len > 2 && ch0 == '0' && (s.charAt(1) == 'X' || s.charAt(1) == 'x') && (numObj = Variant.parseLong(s.substring(2), 16)) != null) {
            return numObj;
        }
        if (s.equals("null")) {
            return null;
        }
        if (s.equals("true")) {
            return Boolean.TRUE;
        }
        if (s.equals("false")) {
            return Boolean.FALSE;
        }
        if (ch0 == '[' || ch0 == '{') {
            char[] chars = s.toCharArray();
            Object obj = JSONUtil.parseJSON(chars, 0, chars.length - 1);
            if (obj != null) {
                return obj;
            }
            return s;
        }
        return Variant.parseDate(s);
    }

    public static Object parse(String text, byte[] types, int col) {
        if (text == null) {
            return null;
        }
        int len = text.length();
        if (len == 0) {
            return null;
        }
        switch (types[col]) {
            case 11: {
                return text;
            }
            case 1: {
                Number numObj = Variant.parseInt(text);
                if (numObj != null) {
                    return numObj;
                }
                numObj = Variant.parseLong(text);
                if (numObj != null) {
                    types[col] = 2;
                    return numObj;
                }
                try {
                    FloatingDecimal fd = FloatingDecimal.readJavaFormatString(text);
                    if (fd != null) {
                        types[col] = 6;
                        return new Double(fd.doubleValue());
                    }
                }
                catch (RuntimeException fd) {}
                break;
            }
            case 6: {
                if (text.endsWith("%")) {
                    try {
                        FloatingDecimal fd = FloatingDecimal.readJavaFormatString(text.substring(0, text.length() - 1));
                        if (fd != null) {
                            return new Double(fd.doubleValue() / 100.0);
                        }
                    }
                    catch (RuntimeException fd) {}
                    break;
                }
                try {
                    FloatingDecimal fd = FloatingDecimal.readJavaFormatString(text);
                    if (fd != null) {
                        return new Double(fd.doubleValue());
                    }
                }
                catch (RuntimeException fd) {}
                break;
            }
            case 8: {
                java.util.Date date = DateFormatFactory.get().getDateFormatX().parse(text);
                if (date == null) break;
                return new Date(date.getTime());
            }
            case 7: {
                try {
                    return new BigDecimal(text);
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            case 2: {
                Number numObj;
                if (len > 2 && text.charAt(0) == '0' && (text.charAt(1) == 'X' || text.charAt(1) == 'x') ? (numObj = Variant.parseLong(text.substring(2), 16)) != null : (numObj = Variant.parseLong(text)) != null) {
                    return numObj;
                }
                try {
                    FloatingDecimal fd = FloatingDecimal.readJavaFormatString(text);
                    if (fd != null) {
                        types[col] = 6;
                        return new Double(fd.doubleValue());
                    }
                }
                catch (RuntimeException fd) {}
                break;
            }
            case 10: {
                java.util.Date date = DateFormatFactory.get().getDateTimeFormatX().parse(text);
                if (date == null) break;
                return new Timestamp(date.getTime());
            }
            case 9: {
                java.util.Date date = DateFormatFactory.get().getTimeFormatX().parse(text);
                if (date == null) break;
                return new Time(date.getTime());
            }
            case 12: {
                if (text.equals("true")) {
                    return Boolean.TRUE;
                }
                if (!text.equals("false")) break;
                return Boolean.FALSE;
            }
            default: {
                Object val = Variant.parse(text, false);
                types[col] = Variant.getObjectType(val);
                return val;
            }
        }
        if (text.equals("null")) {
            return null;
        }
        Object val = Variant.parse(text, false);
        return val;
    }

    public static Object parseCellValue(String text) {
        FloatingDecimal fd3;
        if (text == null || text.length() == 0) {
            return null;
        }
        String s = text.trim();
        int len = s.length();
        if (len == 0) {
            return text;
        }
        char ch0 = s.charAt(0);
        if (ch0 == '\"' || ch0 == '\'') {
            return text;
        }
        Number numObj = Variant.parseInt(s);
        if (numObj != null) {
            return numObj;
        }
        numObj = Variant.parseLong(s);
        if (numObj != null) {
            return numObj;
        }
        if (s.endsWith("%")) {
            try {
                fd3 = FloatingDecimal.readJavaFormatString(s.substring(0, s.length() - 1));
                if (fd3 != null) {
                    return new Double(fd3.doubleValue() / 100.0);
                }
            }
            catch (RuntimeException fd2) {}
        } else {
            try {
                fd3 = FloatingDecimal.readJavaFormatString(s);
                if (fd3 != null) {
                    return new Double(fd3.doubleValue());
                }
            }
            catch (RuntimeException fd3) {
                // empty catch block
            }
        }
        if (len > 2 && ch0 == '0' && (s.charAt(1) == 'X' || s.charAt(1) == 'x') && (numObj = Variant.parseLong(s.substring(2), 16)) != null) {
            return numObj;
        }
        if (s.equals("null")) {
            return null;
        }
        if (s.equals("true")) {
            return Boolean.TRUE;
        }
        if (s.equals("false")) {
            return Boolean.FALSE;
        }
        if (ch0 == '[' || ch0 == '{') {
            char[] chars = s.toCharArray();
            Object obj = JSONUtil.parseJSON(chars, 0, chars.length - 1);
            if (obj != null) {
                return obj;
            }
            return text;
        }
        return Variant.parseCellDate(text);
    }

    private static Object parseCellDate(String text) {
        DateFormatFactory dff = DateFormatFactory.get();
        java.util.Date date = dff.getDateTimeFormatX().parse(text);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        date = dff.getFormatX("yyyy/MM/dd HH:mm:ss").parse(text);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        date = dff.getFormatX("yyyy-MM-dd HH:mm:ss").parse(text);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        date = dff.getFormatX("yyyy/MM/dd HH:mm").parse(text);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        date = dff.getFormatX("yyyy-MM-dd HH:mm").parse(text);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        date = dff.getDateFormatX().parse(text);
        if (date != null) {
            return new Date(date.getTime());
        }
        date = dff.getFormatX("yyyy/MM/dd").parse(text);
        if (date != null) {
            return new Date(date.getTime());
        }
        date = dff.getFormatX("yyyy-MM-dd").parse(text);
        if (date != null) {
            return new Date(date.getTime());
        }
        date = dff.getTimeFormatX().parse(text);
        if (date != null) {
            return new Time(date.getTime());
        }
        date = dff.getFormatX("HH:mm").parse(text);
        if (date != null) {
            return new Time(date.getTime());
        }
        int index = text.indexOf(45);
        if (index != -1 || (index = text.indexOf(47)) != -1) {
            int month = Variant.parseUnsignedInt(text.substring(0, index));
            if (month < 1 || month > 12) {
                return text;
            }
            int day = Variant.parseUnsignedInt(text.substring(index + 1));
            if (day < 1 || day > 31) {
                return text;
            }
            long cur = System.currentTimeMillis();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(cur);
            calendar.set(calendar.get(1), month - 1, 1, 0, 0, 0);
            if (calendar.getActualMaximum(5) < day) {
                return text;
            }
            calendar.set(14, 0);
            calendar.set(5, day);
            return new Date(calendar.getTimeInMillis());
        }
        return text;
    }

    public static Number parseNumber(String s) {
        if (s == null) {
            return null;
        }
        int len = (s = s.trim()).length();
        if (len == 0) {
            return null;
        }
        Number numObj = Variant.parseInt(s);
        if (numObj != null) {
            return numObj;
        }
        numObj = Variant.parseLong(s);
        if (numObj != null) {
            return numObj;
        }
        if (s.endsWith("%")) {
            try {
                FloatingDecimal fd = FloatingDecimal.readJavaFormatString(s.substring(0, s.length() - 1));
                if (fd != null) {
                    return new Double(fd.doubleValue() / 100.0);
                }
            }
            catch (RuntimeException fd) {}
        } else {
            try {
                FloatingDecimal fd = FloatingDecimal.readJavaFormatString(s);
                if (fd != null) {
                    return new Double(fd.doubleValue());
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if (len > 2 && s.charAt(0) == '0' && (s.charAt(1) == 'X' || s.charAt(1) == 'x') && (numObj = Variant.parseLong(s.substring(2), 16)) != null) {
            return numObj;
        }
        return null;
    }

    public static Double parseDouble(String s) {
        if (s.endsWith("%")) {
            try {
                FloatingDecimal fd = FloatingDecimal.readJavaFormatString(s.substring(0, s.length() - 1));
                if (fd != null) {
                    return new Double(fd.doubleValue() / 100.0);
                }
            }
            catch (RuntimeException fd) {}
        } else {
            try {
                FloatingDecimal fd = FloatingDecimal.readJavaFormatString(s);
                if (fd != null) {
                    return new Double(fd.doubleValue());
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Object parseDate(String text) {
        java.util.Date date = DateFormatFactory.get().getDateTimeFormatX().parse(text);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        date = DateFormatFactory.get().getDateFormatX().parse(text);
        if (date != null) {
            return new Date(date.getTime());
        }
        date = DateFormatFactory.get().getTimeFormatX().parse(text);
        if (date != null) {
            return new Time(date.getTime());
        }
        return text;
    }

    public static String getDataType(Object o) {
        MessageManager mm = EngineMessage.get();
        if (o == null) {
            return mm.getMessage("DataType.Null");
        }
        if (o instanceof String) {
            return mm.getMessage("DataType.String");
        }
        if (o instanceof Integer) {
            return mm.getMessage("DataType.Integer");
        }
        if (o instanceof Long) {
            return mm.getMessage("DataType.Long");
        }
        if (o instanceof Double) {
            return mm.getMessage("DataType.Double");
        }
        if (o instanceof Boolean) {
            return mm.getMessage("DataType.Boolean");
        }
        if (o instanceof BigDecimal) {
            return mm.getMessage("DataType.BigDecimal");
        }
        if (o instanceof Sequence) {
            return mm.getMessage("DataType.Series");
        }
        if (o instanceof BaseRecord) {
            return mm.getMessage("DataType.Record");
        }
        if (o instanceof byte[]) {
            return mm.getMessage("DataType.ByteArray");
        }
        if (o instanceof Date) {
            return mm.getMessage("DataType.Date");
        }
        if (o instanceof Time) {
            return mm.getMessage("DataType.Time");
        }
        if (o instanceof Timestamp) {
            return mm.getMessage("DataType.Timestamp");
        }
        if (o instanceof Byte) {
            return mm.getMessage("DataType.Byte");
        }
        if (o instanceof Short) {
            return mm.getMessage("DataType.Short");
        }
        return o.getClass().getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object parseCellValue(String text, byte type) {
        if (type == 0) {
            return Variant.parseCellValue(text);
        }
        if (text == null || text.length() == 0) {
            return null;
        }
        String s = text.trim();
        int len = s.length();
        if (len == 0) {
            return text;
        }
        switch (type) {
            case 11: {
                return text;
            }
            case 1: {
                Integer numObj = Variant.parseInt(s);
                if (numObj == null) return text;
                return numObj;
            }
            case 2: {
                if (len > 2 && s.charAt(0) == '0' && (s.charAt(1) == 'X' || s.charAt(1) == 'x')) {
                    Long numObj = Variant.parseLong(s.substring(2), 16);
                    if (numObj == null) return text;
                    return numObj;
                }
                Long numObj = Variant.parseLong(s);
                if (numObj == null) return text;
                return numObj;
            }
            case 6: {
                if (s.endsWith("%")) {
                    try {
                        FloatingDecimal fd = FloatingDecimal.readJavaFormatString(s.substring(0, s.length() - 1));
                        if (fd == null) return text;
                        return new Double(fd.doubleValue() / 100.0);
                    }
                    catch (RuntimeException fd) {}
                    return text;
                }
                try {
                    FloatingDecimal fd = FloatingDecimal.readJavaFormatString(s);
                    if (fd == null) return text;
                    return new Double(fd.doubleValue());
                }
                catch (RuntimeException fd) {}
                return text;
            }
            case 8: {
                java.util.Date date = DateFormatFactory.get().getDateFormatX().parse(s);
                if (date == null) return Variant.parseCellDate(s);
                return new Date(date.getTime());
            }
            case 9: {
                java.util.Date date = DateFormatFactory.get().getTimeFormatX().parse(s);
                if (date == null) return Variant.parseCellDate(s);
                return new Time(date.getTime());
            }
            case 10: {
                java.util.Date date = DateFormatFactory.get().getDateTimeFormatX().parse(s);
                if (date == null) return Variant.parseCellDate(s);
                return new Timestamp(date.getTime());
            }
        }
        return text;
    }

    private static boolean isEquals(byte[] b1, byte[] b2) {
        int len1 = b1.length;
        if (b2.length != len1) {
            return false;
        }
        int i = 0;
        while (i < len1) {
            if (b1[i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int compareArrays(byte[] b1, byte[] b2) {
        int len1 = b1.length;
        int len2 = b2.length;
        if (len1 == len2) {
            int i = 0;
            while (i < len1) {
                if (b1[i] < b2[i]) {
                    return -1;
                }
                if (b1[i] > b2[i]) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
        if (len1 < len2) {
            int i = 0;
            while (i < len1) {
                if (b1[i] < b2[i]) {
                    return -1;
                }
                if (b1[i] > b2[i]) {
                    return 1;
                }
                ++i;
            }
            return -1;
        }
        int i = 0;
        while (i < len2) {
            if (b1[i] < b2[i]) {
                return -1;
            }
            if (b1[i] > b2[i]) {
                return 1;
            }
            ++i;
        }
        return 1;
    }

    private static int parseUnsignedInt(String s) {
        int digit;
        if (s == null || s.length() == 0) {
            return -1;
        }
        int result = 0;
        int i = 0;
        int max = s.length();
        int limit = -2147483647;
        int multmin = limit / 10;
        if (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            result = -digit;
        }
        while (i < max) {
            if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                return -1;
            }
            if (result < multmin) {
                return -1;
            }
            if ((result *= 10) < limit + digit) {
                return -1;
            }
            result -= digit;
        }
        return -result;
    }

    public static Integer parseInt(String s) {
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            int limit;
            if (s.charAt(0) == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / 10;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                    return null;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                    return null;
                }
                if (result < multmin) {
                    return null;
                }
                if ((result *= 10) < limit + digit) {
                    return null;
                }
                result -= digit;
            }
        } else {
            return null;
        }
        if (negative) {
            if (i > 1) {
                return new Integer(result);
            }
            return null;
        }
        return new Integer(-result);
    }

    public static Long parseLong(String s) {
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            long limit;
            if (max > 1 && s.charAt(max - 1) == 'L') {
                --max;
            }
            if (s.charAt(0) == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / 10L;
            if (i < max) {
                if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                    return null;
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(s.charAt(i++), 10)) < 0) {
                    return null;
                }
                if (result < multmin) {
                    return null;
                }
                if ((result *= 10L) < limit + (long)digit) {
                    return null;
                }
                result -= (long)digit;
            }
        } else {
            return null;
        }
        if (negative) {
            if (i > 1) {
                return new Long(result);
            }
            return null;
        }
        return new Long(-result);
    }

    public static Long parseLong(String s, int radix) {
        int len = s.length();
        if (len == 0) {
            return null;
        }
        if (s.charAt(0) == '-') {
            if (len == 1) {
                return null;
            }
            long result = 0L;
            int digit = Character.digit(s.charAt(1), radix);
            if (digit < 0) {
                return null;
            }
            result = -digit;
            long limit = Long.MIN_VALUE;
            long multmin = limit / (long)radix;
            int i = 2;
            while (i < len) {
                digit = Character.digit(s.charAt(i), radix);
                if (digit < 0) {
                    return null;
                }
                if (result < multmin) {
                    return null;
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    return null;
                }
                result -= (long)digit;
                ++i;
            }
            return result;
        }
        long result = Character.digit(s.charAt(0), radix);
        if (result < 0L) {
            return null;
        }
        int i = 1;
        while (i < len) {
            int digit = Character.digit(s.charAt(i), radix);
            if (digit < 0) {
                return null;
            }
            result = result * (long)radix + (long)digit;
            ++i;
        }
        return result;
    }

    public static long parseLongValue(String s, int radix) {
        int len = s.length();
        if (len == 0) {
            throw new NumberFormatException("null");
        }
        if (s.charAt(0) == '-') {
            if (len == 1) {
                throw new NumberFormatException(s);
            }
            long result = 0L;
            int digit = Character.digit(s.charAt(1), radix);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            result = -digit;
            long limit = Long.MIN_VALUE;
            long multmin = limit / (long)radix;
            int i = 2;
            while (i < len) {
                digit = Character.digit(s.charAt(i), radix);
                if (digit < 0) {
                    throw new NumberFormatException(s);
                }
                if (result < multmin) {
                    throw new NumberFormatException(s);
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw new NumberFormatException(s);
                }
                result -= (long)digit;
                ++i;
            }
            return result;
        }
        long result = Character.digit(s.charAt(0), radix);
        if (result < 0L) {
            throw new NumberFormatException(s);
        }
        int i = 1;
        while (i < len) {
            int digit = Character.digit(s.charAt(i), radix);
            if (digit < 0) {
                throw new NumberFormatException(s);
            }
            result = result * (long)radix + (long)digit;
            ++i;
        }
        return result;
    }

    public static java.util.Date dayElapse(Calendar calendar, java.util.Date date, int n) {
        calendar.setTime(date);
        calendar.add(5, n);
        date = (java.util.Date)date.clone();
        date.setTime(calendar.getTimeInMillis());
        return date;
    }

    public static java.util.Date elapse(java.util.Date date, int diff, String opt) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (opt == null) {
            c.add(5, diff);
        } else if (opt.indexOf(121) != -1) {
            if (opt.indexOf(101) != -1 || c.get(5) != c.getActualMaximum(5)) {
                c.add(1, diff);
            } else {
                c.add(1, diff);
                c.set(5, c.getActualMaximum(5));
            }
        } else if (opt.indexOf(113) != -1) {
            if (opt.indexOf(101) != -1 || c.get(5) != c.getActualMaximum(5)) {
                c.add(2, diff * 3);
            } else {
                c.add(2, diff * 3);
                c.set(5, c.getActualMaximum(5));
            }
        } else if (opt.indexOf("ms") != -1) {
            c.add(14, diff);
        } else if (opt.indexOf(109) != -1) {
            if (opt.indexOf(101) != -1 || c.get(5) != c.getActualMaximum(5)) {
                c.add(2, diff);
            } else {
                c.add(2, diff);
                c.set(5, c.getActualMaximum(5));
            }
        } else if (opt.indexOf(115) != -1) {
            c.add(13, diff);
        } else {
            c.add(5, diff);
        }
        date = (java.util.Date)date.clone();
        date.setTime(c.getTimeInMillis());
        return date;
    }

    private static int dayElapse(int date, int diff) {
        int d;
        int m;
        int y;
        block9: {
            if (date < 0) {
                y = date / 384 + 1969;
                m = date / 32 % 12 + 11;
                d = date % 32 + 32;
            } else {
                y = date / 384 + 1970;
                m = date / 32 % 12;
                d = date % 32;
            }
            if (diff > 0) {
                while (true) {
                    int maxDay;
                    int n;
                    if ((n = d + diff) <= (maxDay = y % 400 == 0 || y % 4 == 0 && y % 100 != 0 ? LEEPYEARDAYS[m] : DAYS[m])) {
                        d = n;
                        break block9;
                    }
                    diff -= maxDay - d + 1;
                    d = 1;
                    if (++m != 12) continue;
                    m = 0;
                    ++y;
                }
            }
            diff = -diff;
            while (true) {
                if (d > diff) {
                    d -= diff;
                    break;
                }
                diff -= d;
                if (--m < 0) {
                    m = 11;
                    --y;
                }
                if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
                    d = LEEPYEARDAYS[m];
                    continue;
                }
                d = DAYS[m];
            }
        }
        return DateFactory.toDays(y, m, d);
    }

    private static int yearElapse(int date, int diff, boolean adjustEnd) {
        int d;
        int m;
        int y;
        if (date < 0) {
            y = date / 384 + 1969;
            m = date / 32 % 12 + 11;
            d = date % 32 + 32;
        } else {
            y = date / 384 + 1970;
            m = date / 32 % 12;
            d = date % 32;
        }
        y += diff;
        if (adjustEnd) {
            d = y % 400 == 0 || y % 4 == 0 && y % 100 != 0 ? LEEPYEARDAYS[m] : DAYS[m];
        } else if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            if (d > LEEPYEARDAYS[m]) {
                d = LEEPYEARDAYS[m];
            }
        } else if (d > DAYS[m]) {
            d = DAYS[m];
        }
        return DateFactory.toDays(y, m, d);
    }

    private static int monthElapse(int date, int diff, boolean adjustEnd) {
        int d;
        int m;
        int y;
        block13: {
            if (date < 0) {
                y = date / 384 + 1969;
                m = date / 32 % 12 + 11;
                d = date % 32 + 32;
            } else {
                y = date / 384 + 1970;
                m = date / 32 % 12;
                d = date % 32;
            }
            if (diff > 0) {
                while (true) {
                    int n;
                    if ((n = m + diff) < 12) {
                        m = n;
                        break block13;
                    }
                    diff -= 12 - m;
                    m = 0;
                    ++y;
                }
            }
            diff = -diff;
            while (true) {
                if (m >= diff) {
                    m -= diff;
                    break;
                }
                diff -= m + 1;
                m = 11;
                --y;
            }
        }
        if (adjustEnd) {
            d = y % 400 == 0 || y % 4 == 0 && y % 100 != 0 ? LEEPYEARDAYS[m] : DAYS[m];
        } else if (y % 400 == 0 || y % 4 == 0 && y % 100 != 0) {
            if (d > LEEPYEARDAYS[m]) {
                d = LEEPYEARDAYS[m];
            }
        } else if (d > DAYS[m]) {
            d = DAYS[m];
        }
        return DateFactory.toDays(y, m, d);
    }

    public static int elapse(int date, int diff, String opt) {
        if (diff == 0) {
            return date;
        }
        if (opt == null) {
            return Variant.dayElapse(date, diff);
        }
        if (opt.indexOf(121) != -1) {
            return Variant.yearElapse(date, diff, opt.indexOf(101) == -1);
        }
        if (opt.indexOf(113) != -1) {
            return Variant.monthElapse(date, diff * 3, opt.indexOf(101) == -1);
        }
        if (opt.indexOf(109) != -1) {
            return Variant.monthElapse(date, diff, opt.indexOf(101) == -1);
        }
        return Variant.dayElapse(date, diff);
    }

    private static long yearInterval(java.util.Date date1, java.util.Date date2) {
        DateFactory df = DateFactory.get();
        return df.year(date2) - df.year(date1);
    }

    private static long quaterInterval(java.util.Date date1, java.util.Date date2) {
        DateFactory df = DateFactory.get();
        Calendar calendar = df.getCalendar();
        calendar.setTime(date1);
        int y1 = calendar.get(1);
        int m1 = calendar.get(2);
        calendar.setTime(date2);
        int y2 = calendar.get(1);
        int m2 = calendar.get(2);
        m1 = m1 < 3 ? 1 : (m1 < 6 ? 2 : (m1 < 9 ? 3 : 4));
        m2 = m2 < 3 ? 1 : (m2 < 6 ? 2 : (m2 < 9 ? 3 : 4));
        return (y2 - y1) * 4 + (m2 - m1);
    }

    private static long monthInterval(java.util.Date date1, java.util.Date date2) {
        DateFactory df = DateFactory.get();
        int yearDiff = df.year(date2) - df.year(date1);
        int monthDiff = df.month(date2) - df.month(date1);
        return yearDiff * 12 + monthDiff;
    }

    private static long weekInterval(java.util.Date date1, java.util.Date date2) {
        long day = Variant.dayInterval(date1, date2);
        return day / 7L;
    }

    private static long weekInterval_7(java.util.Date date1, java.util.Date date2) {
        int week;
        long day = Variant.dayInterval(date1, date2);
        if (day < 0L) {
            day = -day;
            java.util.Date tmp = date1;
            date1 = date2;
            date2 = tmp;
        }
        if ((week = DateFactory.get().week(date1)) != 1) {
            int n = 7 - week + 1;
            if ((day -= (long)n) >= 0L) {
                return day / 7L + 1L;
            }
            return 0L;
        }
        return day / 7L;
    }

    private static long weekInterval_1(java.util.Date date1, java.util.Date date2) {
        int week;
        long day = Variant.dayInterval(date1, date2);
        if (day < 0L) {
            day = -day;
            java.util.Date tmp = date1;
            date1 = date2;
            date2 = tmp;
        }
        if ((week = DateFactory.get().week(date1)) != 2) {
            int n;
            int n2 = n = week == 1 ? 1 : 7 - week + 2;
            if ((day -= (long)n) >= 0L) {
                return day / 7L + 1L;
            }
            return 0L;
        }
        return day / 7L;
    }

    public static long dayInterval(java.util.Date date1, java.util.Date date2) {
        return (date2.getTime() - BASEDATE) / 86400000L - (date1.getTime() - BASEDATE) / 86400000L;
    }

    public static long dayInterval(long date1, long date2) {
        return (date2 - BASEDATE) / 86400000L - (date1 - BASEDATE) / 86400000L;
    }

    private static int innerDayInterval(int date1, int date2) {
        if (date1 < date2) {
            int m;
            int d2;
            int m2;
            int y2;
            int d1;
            int m1;
            int y1;
            if (date1 < 0) {
                y1 = date1 / 384 + 1969;
                m1 = date1 / 32 % 12 + 11;
                d1 = date1 % 32 + 32;
            } else {
                y1 = date1 / 384 + 1970;
                m1 = date1 / 32 % 12;
                d1 = date1 % 32;
            }
            if (date2 < 0) {
                y2 = date2 / 384 + 1969;
                m2 = date2 / 32 % 12 + 11;
                d2 = date2 % 32 + 32;
            } else {
                y2 = date2 / 384 + 1970;
                m2 = date2 / 32 % 12;
                d2 = date2 % 32;
            }
            int interval = 0;
            int y = y1;
            while (y < y2) {
                interval = y % 400 == 0 || y % 4 == 0 && y % 100 != 0 ? (interval += 366) : (interval += 365);
                ++y;
            }
            interval -= d1;
            if (y1 % 400 == 0 || y1 % 4 == 0 && y1 % 100 != 0) {
                m = 0;
                while (m < m1) {
                    interval -= LEEPYEARDAYS[m];
                    ++m;
                }
            } else {
                m = 0;
                while (m < m1) {
                    interval -= DAYS[m];
                    ++m;
                }
            }
            interval += d2;
            if (y2 % 400 == 0 || y2 % 4 == 0 && y2 % 100 != 0) {
                m = 0;
                while (m < m2) {
                    interval += LEEPYEARDAYS[m];
                    ++m;
                }
            } else {
                m = 0;
                while (m < m2) {
                    interval += DAYS[m];
                    ++m;
                }
            }
            return interval;
        }
        if (date1 == date2) {
            return 0;
        }
        return -Variant.innerDayInterval(date2, date1);
    }

    private static int innerYearInterval(int date1, int date2) {
        int y1 = date1 < 0 ? date1 / 384 + 1969 : date1 / 384 + 1970;
        int y2 = date2 < 0 ? date2 / 384 + 1969 : date2 / 384 + 1970;
        return y2 - y1;
    }

    private static int innerMonthInterval(int date1, int date2) {
        int m2;
        int y2;
        int m1;
        int y1;
        if (date1 < 0) {
            y1 = date1 / 384 + 1969;
            m1 = date1 / 32 % 12 + 11;
        } else {
            y1 = date1 / 384 + 1970;
            m1 = date1 / 32 % 12;
        }
        if (date2 < 0) {
            y2 = date2 / 384 + 1969;
            m2 = date2 / 32 % 12 + 11;
        } else {
            y2 = date2 / 384 + 1970;
            m2 = date2 / 32 % 12;
        }
        return (y2 - y1) * 12 + (m2 - m1);
    }

    private static long innerQuaterInterval(int date1, int date2) {
        int m2;
        int y2;
        int m1;
        int y1;
        if (date1 < 0) {
            y1 = date1 / 384 + 1969;
            m1 = date1 / 32 % 12 + 11;
        } else {
            y1 = date1 / 384 + 1970;
            m1 = date1 / 32 % 12;
        }
        if (date2 < 0) {
            y2 = date2 / 384 + 1969;
            m2 = date2 / 32 % 12 + 11;
        } else {
            y2 = date2 / 384 + 1970;
            m2 = date2 / 32 % 12;
        }
        m1 = m1 < 3 ? 1 : (m1 < 6 ? 2 : (m1 < 9 ? 3 : 4));
        m2 = m2 < 3 ? 1 : (m2 < 6 ? 2 : (m2 < 9 ? 3 : 4));
        return (y2 - y1) * 4 + (m2 - m1);
    }

    public static long secondInterval(java.util.Date date1, java.util.Date date2) {
        return (date2.getTime() - date1.getTime()) / 1000L;
    }

    private static long millisecondInterval(java.util.Date date1, java.util.Date date2) {
        return date2.getTime() - date1.getTime();
    }

    public static long interval(java.util.Date date1, java.util.Date date2, String opt) {
        if (opt == null) {
            return Variant.dayInterval(date1, date2);
        }
        if (opt.indexOf("ymd") != -1) {
            int dayDiff;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2) + 1;
            int d1 = calendar.get(5);
            int maxDay1 = calendar.getActualMaximum(5);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            int m2 = calendar.get(2) + 1;
            int d2 = calendar.get(5);
            int maxDay2 = calendar.getActualMaximum(5);
            int monthDiff = 0;
            if (d2 >= d1) {
                if (d1 == maxDay1) {
                    if (d2 == maxDay2) {
                        dayDiff = 0;
                    } else {
                        dayDiff = d2;
                        monthDiff = -1;
                    }
                } else {
                    dayDiff = d2 - d1;
                }
            } else if (d2 == maxDay2) {
                dayDiff = 0;
            } else {
                calendar.set(2, m2 - 2);
                calendar.set(5, d1);
                dayDiff = calendar.getActualMaximum(5) - d1;
                dayDiff = dayDiff < 0 ? d2 : (dayDiff += d2);
                monthDiff = -1;
            }
            int yearDiff = y2 - y1;
            if ((monthDiff += m2 - m1) < 0) {
                --yearDiff;
                monthDiff += 12;
            }
            return yearDiff * 10000 + monthDiff * 100 + dayDiff;
        }
        if (opt.indexOf("ym") != -1) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2) + 1;
            int d1 = calendar.get(5);
            int maxDay1 = calendar.getActualMaximum(5);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            int m2 = calendar.get(2) + 1;
            int d2 = calendar.get(5);
            int maxDay2 = calendar.getActualMaximum(5);
            int monthDiff = 0;
            if (d2 >= d1) {
                if (d1 == maxDay1 && d2 != maxDay2) {
                    monthDiff = -1;
                }
            } else if (d2 != maxDay2) {
                monthDiff = -1;
            }
            int yearDiff = y2 - y1;
            if ((monthDiff += m2 - m1) < 0) {
                --yearDiff;
                monthDiff += 12;
            }
            return yearDiff * 100 + monthDiff;
        }
        if (opt.indexOf("yd") != -1) {
            int yearDiff;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2);
            int d1 = calendar.get(5);
            int maxDay1 = calendar.getActualMaximum(5);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            if (y2 == y1) {
                return Variant.dayInterval(date1, date2);
            }
            int m2 = calendar.get(2);
            int d2 = calendar.get(5);
            if (y2 == y1 + 1) {
                if (m2 < m1) {
                    return Variant.dayInterval(date1, date2);
                }
                if (m2 == m1) {
                    if (d1 == maxDay1) {
                        int maxDay2 = calendar.getActualMaximum(5);
                        if (d2 == maxDay2) {
                            return 1000L;
                        }
                        return Variant.dayInterval(date1, date2);
                    }
                    if (d2 < d1) {
                        return Variant.dayInterval(date1, date2);
                    }
                    if (d2 == d1) {
                        return 1000L;
                    }
                    return 1000 + d2 - d1;
                }
            }
            if (m2 < m1) {
                yearDiff = y2 - y1 - 1;
                calendar.set(y2 - 1, m1, d1);
                if (d1 == maxDay1) {
                    calendar.set(5, calendar.getActualMaximum(5));
                }
            } else if (m2 == m1) {
                if (d1 == maxDay1) {
                    int maxDay2 = calendar.getActualMaximum(5);
                    if (d2 == maxDay2) {
                        return (y2 - y1) * 1000;
                    }
                    yearDiff = y2 - y1 - 1;
                    calendar.set(y2 - 1, m1, d1);
                    calendar.set(5, calendar.getActualMaximum(5));
                } else if (d1 < d2) {
                    yearDiff = y2 - y1;
                    calendar.set(y2, m1, d1);
                } else {
                    if (d1 == d2) {
                        return (y2 - y1) * 1000;
                    }
                    yearDiff = y2 - y1 - 1;
                    calendar.set(y2 - 1, m1, d1);
                }
            } else {
                yearDiff = y2 - y1;
                calendar.set(y2, m1, d1);
                if (d1 == maxDay1) {
                    calendar.set(5, calendar.getActualMaximum(5));
                }
            }
            date1 = calendar.getTime();
            return (long)(yearDiff * 1000) + Variant.dayInterval(date1, date2);
        }
        if (opt.indexOf("md") != -1) {
            int dayDiff;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date1);
            int y1 = calendar.get(1);
            int m1 = calendar.get(2) + 1;
            int d1 = calendar.get(5);
            int maxDay1 = calendar.getActualMaximum(5);
            calendar.setTime(date2);
            int y2 = calendar.get(1);
            int m2 = calendar.get(2) + 1;
            int d2 = calendar.get(5);
            int maxDay2 = calendar.getActualMaximum(5);
            int monthDiff = 0;
            if (d2 >= d1) {
                if (d1 == maxDay1) {
                    if (d2 == maxDay2) {
                        dayDiff = 0;
                    } else {
                        dayDiff = d2;
                        monthDiff = -1;
                    }
                } else {
                    dayDiff = d2 - d1;
                }
            } else if (d2 == maxDay2) {
                dayDiff = 0;
            } else {
                calendar.set(2, m2 - 2);
                calendar.set(5, d1);
                dayDiff = calendar.getActualMaximum(5) - d1;
                dayDiff = dayDiff < 0 ? d2 : (dayDiff += d2);
                monthDiff = -1;
            }
            return (monthDiff += m2 - m1 + (y2 - y1) * 12) * 100 + dayDiff;
        }
        if (opt.indexOf("ms") != -1) {
            return Variant.millisecondInterval(date1, date2);
        }
        if (opt.indexOf(121) != -1) {
            return Variant.yearInterval(date1, date2);
        }
        if (opt.indexOf(113) != -1) {
            return Variant.quaterInterval(date1, date2);
        }
        if (opt.indexOf(109) != -1) {
            return Variant.monthInterval(date1, date2);
        }
        if (opt.indexOf(115) != -1) {
            return Variant.secondInterval(date1, date2);
        }
        if (opt.indexOf(119) != -1) {
            return Variant.weekInterval(date1, date2);
        }
        if (opt.indexOf(55) != -1) {
            return Variant.weekInterval_7(date1, date2);
        }
        if (opt.indexOf(49) != -1) {
            return Variant.weekInterval_1(date1, date2);
        }
        return Variant.dayInterval(date1, date2);
    }

    public static long interval(int date1, int date2, String opt) {
        if (opt == null) {
            return Variant.innerDayInterval(date1, date2);
        }
        if (opt.indexOf(121) != -1) {
            return Variant.innerYearInterval(date1, date2);
        }
        if (opt.indexOf(113) != -1) {
            return Variant.innerQuaterInterval(date1, date2);
        }
        if (opt.indexOf(109) != -1) {
            return Variant.innerMonthInterval(date1, date2);
        }
        if (opt.indexOf(119) != -1) {
            return Variant.weekInterval(DateFactory.toDate(date1), DateFactory.toDate(date2));
        }
        if (opt.indexOf(55) != -1) {
            return Variant.weekInterval_7(DateFactory.toDate(date1), DateFactory.toDate(date2));
        }
        if (opt.indexOf(49) != -1) {
            return Variant.weekInterval_1(DateFactory.toDate(date1), DateFactory.toDate(date2));
        }
        return Variant.innerDayInterval(date1, date2);
    }

    public static double realInterval(int date1, int date2, String opt) {
        double dayDiff = Variant.innerDayInterval(date1, date2);
        if (opt == null) {
            return dayDiff;
        }
        if (opt.indexOf(121) != -1) {
            return dayDiff / 365.0;
        }
        if (opt.indexOf(113) != -1) {
            return dayDiff / 90.0;
        }
        if (opt.indexOf(109) != -1) {
            return dayDiff / 30.0;
        }
        if (opt.indexOf(119) != -1) {
            return dayDiff / 7.0;
        }
        return dayDiff;
    }

    public static double realInterval(java.util.Date date1, java.util.Date date2, String opt) {
        if (opt == null) {
            double msDiff = Variant.millisecondInterval(date1, date2);
            return msDiff / 8.64E7;
        }
        if (opt.indexOf("ms") != -1) {
            return Variant.millisecondInterval(date1, date2);
        }
        if (opt.indexOf(121) != -1) {
            double dayDiff = Variant.dayInterval(date1, date2);
            return dayDiff / 365.0;
        }
        if (opt.indexOf(113) != -1) {
            double dayDiff = Variant.dayInterval(date1, date2);
            return dayDiff / 90.0;
        }
        if (opt.indexOf(109) != -1) {
            double dayDiff = Variant.dayInterval(date1, date2);
            return dayDiff / 30.0;
        }
        if (opt.indexOf(115) != -1) {
            double msDiff = Variant.millisecondInterval(date1, date2);
            return msDiff / 1000.0;
        }
        if (opt.indexOf(119) != -1) {
            double dayDiff = Variant.dayInterval(date1, date2);
            return dayDiff / 7.0;
        }
        double msDiff = Variant.millisecondInterval(date1, date2);
        return msDiff / 8.64E7;
    }

    public static boolean isEquals(java.util.Date date1, java.util.Date date2, String opt) {
        DateFactory df = DateFactory.get();
        if (df.year(date1) != df.year(date2)) {
            return false;
        }
        if (opt == null) {
            return df.month(date1) == df.month(date2) && df.day(date1) == df.day(date2);
        }
        if (opt.indexOf(121) != -1) {
            return true;
        }
        if (opt.indexOf(113) != -1) {
            int m1 = df.month(date1);
            int m2 = df.month(date2);
            if (m1 <= 3) {
                return m2 <= 3;
            }
            if (m1 <= 6) {
                return m2 > 3 && m2 <= 6;
            }
            if (m1 <= 9) {
                return m2 > 6 && m2 <= 9;
            }
            return m2 > 9;
        }
        if (opt.indexOf(109) != -1) {
            return df.month(date1) == df.month(date2);
        }
        if (opt.indexOf(116) != -1) {
            int d2;
            if (df.month(date1) != df.month(date2)) {
                return false;
            }
            int d1 = df.day(date1);
            if (d1 == (d2 = df.day(date2))) {
                return true;
            }
            if (d1 <= 10) {
                return d2 <= 10;
            }
            if (d1 <= 20) {
                return d2 > 10 && d2 <= 20;
            }
            return d2 > 20;
        }
        if (opt.indexOf(119) != -1) {
            int dayDiff = (int)Variant.dayInterval(date1, date2);
            if (dayDiff == 0) {
                return true;
            }
            if (dayDiff > 6 || dayDiff < -6) {
                return false;
            }
            if (opt.indexOf(49) == -1) {
                int week2 = df.week(date1) + dayDiff;
                return week2 >= 1 && week2 <= 7;
            }
            int week = df.week(date1);
            if (week == 1) {
                return dayDiff < 0 && dayDiff > -7;
            }
            return (week += dayDiff) >= 2 && week <= 8;
        }
        return df.month(date1) == df.month(date2) && df.day(date1) == df.day(date2);
    }

    public static Number and(Number n1, Number n2) {
        if (n1 instanceof Integer && n2 instanceof Integer) {
            return n1.intValue() & n2.intValue();
        }
        if (n1 instanceof BigInteger) {
            BigInteger b1 = (BigInteger)n1;
            BigInteger b2 = Variant.toBigInteger(n2);
            return b1.and(b2);
        }
        if (n1 instanceof BigDecimal) {
            BigInteger b1 = ((BigDecimal)n1).toBigInteger();
            BigInteger b2 = Variant.toBigInteger(n2);
            return b1.and(b2);
        }
        if (n2 instanceof BigInteger) {
            BigInteger b1 = Variant.toBigInteger(n1);
            BigInteger b2 = (BigInteger)n2;
            return b1.and(b2);
        }
        if (n2 instanceof BigDecimal) {
            BigInteger b1 = Variant.toBigInteger(n1);
            BigInteger b2 = ((BigDecimal)n2).toBigInteger();
            return b1.and(b2);
        }
        return n1.longValue() & n2.longValue();
    }
}

