/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.util.XMLUtil;
import java.util.ArrayList;
import org.xml.sax.Attributes;

class XMLNode {
    private String name;
    private XMLNode parent;
    private boolean bopt;
    private ArrayList<XMLNode> subList;
    private String characters;
    private String[] attrNames;
    private String[] attrValues;

    public XMLNode(String name, XMLNode parent, boolean bopt) {
        this.name = name;
        this.parent = parent;
        this.bopt = bopt;
    }

    public String getName() {
        return this.name;
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public void addCharacters(String str) {
        this.characters = this.characters == null ? str : String.valueOf(this.characters) + str;
    }

    public void addSub(XMLNode sub) {
        if (this.subList == null) {
            this.subList = new ArrayList();
        }
        this.subList.add(sub);
    }

    public boolean euqalName(String name) {
        return this.name.equals(name);
    }

    public Object getResult() {
        Object value;
        ArrayList<XMLNode> subList = this.subList;
        if (subList == null) {
            if (this.bopt) {
                if (this.characters == null) {
                    return null;
                }
                this.characters = this.characters.trim();
                if (this.characters.length() > 0) {
                    return this.characters;
                }
                return null;
            }
            value = XMLUtil.parseText(this.characters);
        } else {
            ArrayList<String> nameList = new ArrayList<String>();
            int size = subList.size();
            for (XMLNode sub : subList) {
                if (nameList.contains(sub.name)) continue;
                nameList.add(sub.name);
            }
            int count = nameList.size();
            String[] names = new String[count];
            nameList.toArray(names);
            DataStruct ds = new DataStruct(names);
            Record r = new Record(ds);
            value = r;
            if (count == size) {
                int i = 0;
                while (i < size) {
                    XMLNode sub = subList.get(i);
                    r.setNormalFieldValue(i, sub.getResult());
                    ++i;
                }
            } else if (count == 1) {
                boolean hasAttributes = true;
                Sequence seq = new Sequence(size);
                int i = 0;
                while (i < size) {
                    XMLNode sub = subList.get(i);
                    seq.add(sub.getResult());
                    if (!sub.hasAttributes()) {
                        hasAttributes = false;
                    }
                    ++i;
                }
                if (hasAttributes) {
                    value = seq;
                } else {
                    r.setNormalFieldValue(0, seq);
                }
            } else {
                int i = 0;
                while (i < count) {
                    String name = names[i];
                    Sequence seq = new Sequence();
                    for (XMLNode sub : subList) {
                        if (!sub.euqalName(name)) continue;
                        seq.add(sub.getResult());
                    }
                    if (seq.length() > 1) {
                        r.setNormalFieldValue(i, seq);
                    } else {
                        r.setNormalFieldValue(i, seq.get(1));
                    }
                    ++i;
                }
            }
        }
        if (this.attrNames == null) {
            return value;
        }
        int attrCount = this.attrNames.length;
        String[] names = new String[1 + attrCount];
        names[0] = this.name;
        System.arraycopy(this.attrNames, 0, names, 1, attrCount);
        DataStruct ds = new DataStruct(names);
        Record r = new Record(ds);
        r.setNormalFieldValue(0, value);
        r.setStart(1, this.attrValues);
        return r;
    }

    public void setAttributes(Attributes attributes) {
        int len = attributes.getLength();
        if (len > 0) {
            this.attrNames = new String[len];
            this.attrValues = new String[len];
            int i = 0;
            while (i < len) {
                this.attrNames[i] = attributes.getQName(i);
                this.attrValues[i] = attributes.getValue(i);
                ++i;
            }
        }
    }

    private boolean hasAttributes() {
        return this.attrNames != null;
    }
}

