/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.util;

import com.scudata.array.IArray;
import com.scudata.common.Escape;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.BaseRecord;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Env;
import com.scudata.dm.Sequence;
import com.scudata.resources.EngineMessage;
import com.scudata.util.SAXTableHandler;
import com.scudata.util.Variant;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public final class XMLUtil {
    private static final String ID_Table = "xml";
    private static final String ID_Row = "row";
    private static AttributesImpl attr = new AttributesImpl();

    private static String toTextNodeString(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return Escape.addEscAndQuote((String)obj);
        }
        if (obj instanceof Sequence) {
            IArray mems = ((Sequence)obj).getMems();
            StringBuffer sb = new StringBuffer(1024);
            sb.append('[');
            int i = 1;
            int len = mems.size();
            while (i <= len) {
                if (i > 1) {
                    sb.append(',');
                }
                sb.append(XMLUtil.toTextNodeString(mems.get(i)));
                ++i;
            }
            sb.append(']');
            return sb.toString();
        }
        return Variant.toString(obj);
    }

    private static String convertNumber(String text) {
        if (text == null || text.length() == 0) {
            return null;
        }
        int len = text.length();
        char[] chars = new char[len];
        int index = 0;
        boolean hasComma = false;
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c >= '0' && c <= '9') {
                chars[index++] = c;
            } else if (c == ',') {
                hasComma = true;
            } else if (c == '.' || c == '%') {
                chars[index++] = c;
            } else {
                return null;
            }
            ++i;
        }
        if (hasComma) {
            return new String(chars, 0, index);
        }
        return null;
    }

    public static Object parseText(String text) {
        Object value;
        String strNum = XMLUtil.convertNumber(text);
        if (strNum != null && (value = Variant.parse(strNum, true)) instanceof Number) {
            return value;
        }
        return Variant.parse(text, true);
    }

    public static Object parseXml(String src, String levels) {
        return XMLUtil.parseXml(src, levels, null);
    }

    public static Object parseXml(String src, String levels, String opt) {
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            SAXTableHandler handler = new SAXTableHandler(opt);
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(handler);
            StringReader reader = new StringReader(src);
            xmlReader.parse(new InputSource(reader));
            Object table = handler.getResult(XMLUtil.parseLevels(levels));
            return table;
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public static String toXml(Sequence sequence, String charset, String levels) {
        DataStruct ds;
        if (charset == null || charset.length() == 0) {
            charset = Env.getDefaultCharsetName();
        }
        if ((ds = sequence.dataStruct()) == null) {
            MessageManager mm = EngineMessage.get();
            throw new RQException(mm.getMessage("engine.needPurePmt"));
        }
        try {
            int i;
            int count;
            SAXTransformerFactory fac = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = fac.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("encoding", charset);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            StringWriter writer = new StringWriter(8192);
            StreamResult resultxml = new StreamResult(writer);
            handler.setResult(resultxml);
            handler.startDocument();
            String[] strs = XMLUtil.parseLevels(levels);
            String idTable = ID_Row;
            int n = count = strs == null ? 0 : strs.length;
            if (count > 1) {
                idTable = strs[count - 1];
                i = 0;
                while (i < count - 1) {
                    handler.startElement("", "", strs[i], attr);
                    ++i;
                }
            } else if (count == 1) {
                handler.startElement("", "", strs[0], attr);
            } else {
                handler.startElement("", "", ID_Table, attr);
            }
            XMLUtil.toXml(handler, sequence, 0, idTable);
            if (count > 1) {
                i = count - 2;
                while (i >= 0) {
                    handler.endElement("", "", strs[i]);
                    --i;
                }
            } else if (count == 1) {
                handler.endElement("", "", strs[0]);
            } else {
                handler.endElement("", "", ID_Table);
            }
            handler.endDocument();
            return writer.toString();
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    public static String toXml(BaseRecord r, String charset, String levels) {
        if (charset == null || charset.length() == 0) {
            charset = Env.getDefaultCharsetName();
        }
        try {
            SAXTransformerFactory fac = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = fac.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("encoding", charset);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            StringWriter writer = new StringWriter(8192);
            StreamResult resultxml = new StreamResult(writer);
            handler.setResult(resultxml);
            handler.startDocument();
            String[] strs = XMLUtil.parseLevels(levels);
            int count = strs == null ? 0 : strs.length;
            int i = 0;
            while (i < count) {
                handler.startElement("", "", strs[i], attr);
                ++i;
            }
            XMLUtil.toXml(handler, r, count);
            i = 0;
            while (i < count) {
                handler.endElement("", "", strs[i]);
                ++i;
            }
            handler.endDocument();
            return writer.toString();
        }
        catch (Exception e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    private static void appendTab(TransformerHandler handler, int level) throws SAXException {
    }

    private static void toXml(TransformerHandler handler, BaseRecord r, int level) throws SAXException {
        Object[] vals = r.getFieldValues();
        String[] names = r.getFieldNames();
        int f = 0;
        int fcount = vals.length;
        while (f < fcount) {
            XMLUtil.appendTab(handler, level);
            Object val = vals[f];
            if (val instanceof BaseRecord) {
                handler.startElement("", "", names[f], attr);
                XMLUtil.toXml(handler, (BaseRecord)val, level + 1);
                handler.endElement("", "", names[f]);
            } else if (val instanceof Sequence && ((Sequence)val).isPurePmt()) {
                XMLUtil.toXml(handler, (Sequence)val, level + 1, names[f]);
            } else {
                handler.startElement("", "", names[f], attr);
                String valStr = XMLUtil.toTextNodeString(val);
                handler.characters(valStr.toCharArray(), 0, valStr.length());
                handler.endElement("", "", names[f]);
            }
            ++f;
        }
    }

    private static void toXml(TransformerHandler handler, Sequence table, int level, String idTable) throws SAXException {
        if (level > 0) {
            XMLUtil.appendTab(handler, level);
        }
        IArray mems = table.getMems();
        int i = 1;
        int len = mems.size();
        while (i <= len) {
            handler.startElement("", "", idTable, attr);
            BaseRecord r = (BaseRecord)mems.get(i);
            XMLUtil.toXml(handler, r, level + 1);
            handler.endElement("", "", idTable);
            ++i;
        }
    }

    private static String[] parseLevels(String levels) {
        if (levels == null || levels.length() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int s = 0;
        int len = levels.length();
        while (s < len) {
            int i = levels.indexOf(47, s);
            if (i < 0) {
                list.add(levels.substring(s));
                break;
            }
            list.add(levels.substring(s, i));
            s = i + 1;
        }
        String[] strs = new String[list.size()];
        list.toArray(strs);
        return strs;
    }
}

