/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.common.RQException;
import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.vdb.ArchiveSection;
import com.scudata.vdb.IDir;
import com.scudata.vdb.ISection;
import com.scudata.vdb.Library;
import com.scudata.vdb.VDB;
import java.io.IOException;

class ArchiveDir
extends IDir {
    private int header = -1;
    private int fileIndex = -1;
    private long commitTime;
    private ArchiveSection parent;
    private ArchiveSection section;

    public ArchiveDir(ArchiveDir src) {
        this.value = src.value;
        this.name = src.name;
        this.header = src.header;
        this.fileIndex = src.fileIndex;
        this.commitTime = src.commitTime;
    }

    public ArchiveDir(ArchiveSection parent) {
        this.parent = parent;
    }

    public ArchiveDir(Object value, String name, long commitTime, ArchiveSection parent) {
        this.value = value;
        this.name = name;
        this.commitTime = commitTime;
        this.parent = parent;
    }

    public ArchiveSection getParentSection() {
        return this.parent;
    }

    @Override
    public ISection getParent() {
        return this.parent;
    }

    public void setHeader(int header) {
        this.header = header;
    }

    public int getHeader() {
        return this.header;
    }

    public void setFileIndex(int i) {
        this.fileIndex = i;
    }

    public long getCommitTime() {
        return this.commitTime;
    }

    public Object getFileData(VDB vdb) throws IOException {
        return this.parent.getSubFileData(vdb, this.fileIndex);
    }

    public boolean isFile() {
        return this.fileIndex >= 0;
    }

    public boolean isDir() {
        return this.header > 0;
    }

    public ArchiveSection getSection(Library library) {
        if (this.section == null) {
            if (this.header > 0) {
                try {
                    byte[] bytes = library.readBlocks(this.header);
                    this.section = new ArchiveSection(this, this.header, bytes);
                }
                catch (IOException e) {
                    throw new RQException(e.getMessage(), e);
                }
            } else {
                this.section = new ArchiveSection(this);
            }
        }
        return this.section;
    }

    public void setSection(ArchiveSection section) {
        this.section = section;
    }

    @Override
    public void releaseSubSection() {
        this.section = null;
    }

    public void read(ObjectReader reader) throws IOException {
        this.value = reader.readObject();
        this.name = (String)reader.readObject();
        this.header = reader.readInt();
        this.fileIndex = reader.readInt();
        this.commitTime = reader.readLong();
    }

    public void write(ObjectWriter writer) throws IOException {
        writer.writeObject(this.value);
        writer.writeObject(this.name);
        writer.writeInt(this.header);
        writer.writeInt(this.fileIndex);
        writer.writeLong(this.commitTime);
    }
}

