/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.dm.ObjectReader;
import com.scudata.dm.ObjectWriter;
import com.scudata.vdb.BlockManager;
import com.scudata.vdb.DirZone;
import com.scudata.vdb.IDir;
import com.scudata.vdb.ISection;
import com.scudata.vdb.Library;
import com.scudata.vdb.Section;
import com.scudata.vdb.VDB;
import java.io.IOException;
import java.util.ArrayList;

class Dir
extends IDir {
    public static final int S_NORMAL = 0;
    public static final int S_DELETE = -1;
    public static final int S_MOVE = -2;
    private ArrayList<DirZone> zones;
    private transient Section parent;

    public Dir(Section parent) {
        this.parent = parent;
    }

    public Dir(Object value, String name, Section parent) {
        this.value = value;
        this.name = name;
        this.parent = parent;
        this.zones = new ArrayList(1);
        DirZone zone = new DirZone();
        this.zones.add(zone);
    }

    public void read(ObjectReader reader) throws IOException {
        this.value = reader.readObject();
        this.name = (String)reader.readObject();
        int count = reader.readInt();
        this.zones = new ArrayList(count);
        int i = 0;
        while (i < count) {
            DirZone zone = new DirZone();
            zone.read(reader);
            this.zones.add(zone);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ObjectWriter writer, Library library, int outerSeq, long innerSeq) throws IOException {
        writer.writeObject(this.value);
        writer.writeObject(this.name);
        int count = this.zones.size();
        writer.writeInt(count);
        DirZone lastZone = this.zones.get(count - 1);
        if (!lastZone.isCommitted()) {
            Dir dir = this;
            synchronized (dir) {
                lastZone.applySubHeader(library, outerSeq, innerSeq, this);
            }
        }
        for (DirZone zone : this.zones) {
            zone.write(writer);
        }
    }

    public void write(ObjectWriter writer) throws IOException {
        writer.writeObject(this.value);
        writer.writeObject(this.name);
        int count = this.zones.size();
        if (count > 0) {
            DirZone lastZone = this.zones.get(count - 1);
            writer.writeInt(1);
            lastZone.write(writer);
        } else {
            writer.writeInt(0);
        }
    }

    public Section getParentSection() {
        return this.parent;
    }

    @Override
    public ISection getParent() {
        return this.parent;
    }

    public synchronized DirZone addZone(int state) {
        if (this.zones == null) {
            this.zones = new ArrayList(1);
        }
        DirZone zone = new DirZone();
        zone.setBlock(state);
        this.zones.add(zone);
        return zone;
    }

    public synchronized int roolBack() {
        int i = this.zones.size() - 1;
        while (i >= 0) {
            DirZone zone = this.zones.get(i);
            if (zone.isCommitted()) {
                return i + 1;
            }
            this.zones.remove(i);
            --i;
        }
        return 0;
    }

    public synchronized DirZone getZone(VDB vdb, boolean isLockVDB) {
        ArrayList<DirZone> zones = this.zones;
        if (zones == null) {
            return null;
        }
        int i = zones.size() - 1;
        while (i >= 0) {
            DirZone zone = zones.get(i);
            if (zone.match(vdb, isLockVDB)) {
                return zone.valid() ? zone : null;
            }
            --i;
        }
        return null;
    }

    public synchronized DirZone getLastZone() {
        if (this.zones == null) {
            return null;
        }
        int size = this.zones.size();
        if (size > 0) {
            return this.zones.get(size - 1);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void deleteOutdatedZone(Library library, int outerSeq, long txSeq) {
        zones = this.zones;
        last = zones.size() - 1;
        if (last >= 1) ** GOTO lbl7
        return;
        while (!(zone = zones.get(last)).isCommitted()) {
            --last;
lbl7:
            // 2 sources

            if (last >= 0) continue;
        }
        --last;
        while (last >= 0) {
            zone = zones.get(last);
            if (zone.canDelete(outerSeq, txSeq)) {
                while (last >= 0) {
                    zones.remove(last);
                    --last;
                }
                break;
            }
            --last;
        }
    }

    public boolean scanUsedBlocks(Library library, BlockManager manager) throws IOException {
        DirZone zone;
        ArrayList<DirZone> zones = this.zones;
        int size = zones.size();
        if (size > 1) {
            zone = zones.get(size - 1);
            if (!zone.valid()) {
                return false;
            }
            zones.clear();
            zones.add(zone);
        } else {
            zone = zones.get(0);
            if (!zone.valid()) {
                return false;
            }
        }
        ISection section = zone.getSection(library, this);
        section.scanUsedBlocks(library, manager);
        zone.releaseSection();
        return true;
    }

    public void rename(String newName) {
        this.name = newName;
    }

    @Override
    public void releaseSubSection() {
        if (this.zones != null) {
            for (DirZone zone : this.zones) {
                zone.releaseSection();
            }
        }
    }
}

