/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.dm.BaseRecord;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.util.Variant;
import com.scudata.vdb.DirFilter;

class Filter {
    private String[] filterDirs;
    private DirFilter[] filters;
    private String[] selFields;
    private Expression exp;
    private Context ctx;
    private int filterCount = 0;
    private int filterIndex = 0;
    private int capacity = 16;
    private int dirIndex = 0;
    private String[] dirNames = new String[this.capacity];
    private Object[] dirValues = new Object[this.capacity];
    private int selDirCount = 0;
    private String[] resultFields;

    public Filter(String[] dirNames, Object[] dirValues, boolean[] valueSigns, String[] selFields, Expression exp, Context ctx) {
        this.filterDirs = dirNames;
        this.selFields = selFields;
        this.exp = exp;
        this.ctx = ctx;
        if (dirNames != null) {
            this.filterCount = dirNames.length;
            this.filters = new DirFilter[this.filterCount];
            int i = 0;
            while (i < this.filterCount) {
                this.filters[i] = new DirFilter(dirValues[i], valueSigns[i]);
                if (dirNames[i] != null) {
                    ++this.selDirCount;
                }
                ++i;
            }
            if (selFields != null) {
                this.resultFields = new String[this.selDirCount + selFields.length];
                i = 0;
                int j = 0;
                while (i < this.filterCount) {
                    if (dirNames[i] != null) {
                        this.resultFields[j++] = dirNames[i];
                    }
                    ++i;
                }
                System.arraycopy(selFields, 0, this.resultFields, this.selDirCount, selFields.length);
            } else if (this.selDirCount == this.filterCount) {
                this.resultFields = dirNames;
            } else {
                this.resultFields = new String[this.selDirCount];
                i = 0;
                int j = 0;
                while (i < this.filterCount) {
                    if (dirNames[i] != null) {
                        this.resultFields[j++] = dirNames[i];
                    }
                    ++i;
                }
            }
        } else {
            this.resultFields = selFields;
        }
    }

    public Filter(String[] dirNames, Object[] dirValues, boolean[] valueSigns, Expression exp, Context ctx) {
        this.filterDirs = dirNames;
        this.exp = exp;
        this.ctx = ctx;
        if (dirNames != null) {
            this.filterCount = dirNames.length;
            this.filters = new DirFilter[this.filterCount];
            int i = 0;
            while (i < this.filterCount) {
                this.filters[i] = new DirFilter(dirValues[i], valueSigns[i]);
                ++i;
            }
        }
    }

    public boolean hasExpression() {
        return this.exp != null;
    }

    private static boolean isEqualField(String filterName, String fname) {
        if (filterName == null) {
            return true;
        }
        return fname != null && fname.equals(filterName);
    }

    public boolean pushDir(String name, Object value) {
        int dirIndex;
        if (this.filterIndex < this.filterCount && Filter.isEqualField(this.filterDirs[this.filterIndex], name)) {
            if (this.filters[this.filterIndex].match(value)) {
                ++this.filterIndex;
            } else {
                return false;
            }
        }
        if ((dirIndex = this.dirIndex) == this.capacity) {
            this.capacity *= 2;
            String[] newNames = new String[this.capacity];
            Object[] newValues = new Object[this.capacity];
            System.arraycopy(this.dirNames, 0, newNames, 0, dirIndex);
            System.arraycopy(this.dirValues, 0, newValues, 0, dirIndex);
            this.dirNames = newNames;
            this.dirValues = newValues;
        }
        this.dirNames[dirIndex] = name;
        this.dirValues[dirIndex] = value;
        ++this.dirIndex;
        return true;
    }

    public void popDir() {
        --this.dirIndex;
        int f = this.filterIndex - 1;
        if (f >= 0 && Filter.isEqualField(this.filterDirs[f], this.dirNames[this.dirIndex])) {
            this.filterIndex = f;
        }
    }

    private static Table getFields(Sequence seq, DataStruct ds, String[] feilds) {
        int len = seq.length();
        int newCount = feilds.length;
        int[] index = new int[newCount];
        int i = 0;
        while (i < newCount) {
            index[i] = ds.getFieldIndex(feilds[i]);
            ++i;
        }
        Table table = new Table(feilds, len);
        int i2 = 1;
        while (i2 <= len) {
            BaseRecord nr = table.newLast();
            BaseRecord r = (BaseRecord)seq.getMem(i2);
            int f = 0;
            while (f < newCount) {
                if (index[f] != -1) {
                    nr.setNormalFieldValue(f, r.getFieldValue(index[f]));
                }
                ++f;
            }
            ++i2;
        }
        return table;
    }

    public boolean isDirMatch() {
        return this.filterIndex == this.filterCount;
    }

    public Sequence select(Object val) {
        if (this.filterIndex < this.filterCount) {
            return null;
        }
        if (!(val instanceof Sequence)) {
            return null;
        }
        Sequence seq = (Sequence)val;
        if (seq.length() == 0) {
            return null;
        }
        DataStruct ds = seq.dataStruct();
        if (ds == null) {
            return null;
        }
        if (this.exp == null && this.selDirCount == 0) {
            if (this.selFields == null) {
                return seq;
            }
            return Filter.getFields(seq, ds, this.selFields);
        }
        String[] fields = ds.getFieldNames();
        int dirCount = this.dirIndex;
        int fcount = fields.length;
        String[] totalNames = new String[dirCount + fcount];
        System.arraycopy(this.dirNames, 0, totalNames, 0, dirCount);
        System.arraycopy(fields, 0, totalNames, dirCount, fcount);
        int len = seq.length();
        Table table = new Table(totalNames, len);
        Object[] dirValues = this.dirValues;
        int i = 1;
        while (i <= len) {
            BaseRecord r = (BaseRecord)seq.getMem(i);
            BaseRecord nr = table.newLast();
            nr.setStart(0, dirValues, dirCount);
            nr.setStart(dirCount, r);
            ++i;
        }
        if (this.exp != null) {
            try {
                table.select(this.exp, "o", this.ctx);
                if (table.length() == 0) {
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.selFields == null) {
            if (this.resultFields == null) {
                return Filter.getFields(table, table.dataStruct(), fields);
            }
            if (this.selDirCount == dirCount) {
                return table;
            }
            totalNames = new String[this.selDirCount + fcount];
            System.arraycopy(this.resultFields, 0, totalNames, 0, this.selDirCount);
            System.arraycopy(fields, 0, totalNames, this.selDirCount, fcount);
            return Filter.getFields(table, table.dataStruct(), totalNames);
        }
        return Filter.getFields(table, table.dataStruct(), this.resultFields);
    }

    private static void update(Sequence seq, Object[] fvals, int[] findex) {
        int mcount = findex.length;
        int i = 1;
        int len = seq.length();
        while (i <= len) {
            BaseRecord r = (BaseRecord)seq.getMem(i);
            int f = 0;
            while (f < mcount) {
                r.setNormalFieldValue(findex[f], fvals[f]);
                ++f;
            }
            ++i;
        }
    }

    public boolean update(Object val, Object[] fvals, String[] fields) {
        if (this.filterIndex < this.filterCount) {
            return false;
        }
        if (!(val instanceof Sequence)) {
            return false;
        }
        Sequence seq = (Sequence)val;
        if (seq.length() == 0) {
            return false;
        }
        DataStruct ds = seq.dataStruct();
        if (ds == null) {
            return false;
        }
        int mcount = fields.length;
        int[] findex = new int[mcount];
        int i = 0;
        while (i < mcount) {
            findex[i] = ds.getFieldIndex(fields[i]);
            if (findex[i] == -1) {
                return false;
            }
            ++i;
        }
        Expression exp = this.exp;
        if (exp == null) {
            Filter.update(seq, fvals, findex);
            return true;
        }
        String[] srcFields = ds.getFieldNames();
        int dirCount = this.dirIndex;
        int fcount = srcFields.length;
        String[] totalNames = new String[dirCount + fcount];
        System.arraycopy(this.dirNames, 0, totalNames, 0, dirCount);
        System.arraycopy(srcFields, 0, totalNames, dirCount, fcount);
        DataStruct nds = new DataStruct(totalNames);
        Object[] dirValues = this.dirValues;
        boolean match = false;
        Context ctx = this.ctx;
        ComputeStack stack = ctx.getComputeStack();
        Record nr = new Record(nds);
        stack.push(nr);
        try {
            try {
                int i2 = 1;
                int len = seq.length();
                while (i2 <= len) {
                    BaseRecord r = (BaseRecord)seq.getMem(i2);
                    nr.setStart(0, dirValues, dirCount);
                    nr.setStart(dirCount, r);
                    if (Variant.isTrue(exp.calculate(ctx))) {
                        match = true;
                        int f = 0;
                        while (f < mcount) {
                            r.setNormalFieldValue(findex[f], fvals[f]);
                            ++f;
                        }
                    }
                    ++i2;
                }
            }
            catch (Exception e) {
                stack.pop();
                return false;
            }
        }
        finally {
            stack.pop();
        }
        return match;
    }
}

