/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.array.IArray;
import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.ComputeStack;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.expression.FieldRef;
import com.scudata.expression.Function;
import com.scudata.expression.IParam;
import com.scudata.expression.Node;
import com.scudata.expression.UnknownSymbol;
import com.scudata.resources.EngineMessage;
import com.scudata.util.EnvUtil;
import com.scudata.vdb.ArchiveSection;
import com.scudata.vdb.BlockManager;
import com.scudata.vdb.Dir;
import com.scudata.vdb.Filter;
import com.scudata.vdb.IDir;
import com.scudata.vdb.Library;
import com.scudata.vdb.Section;
import com.scudata.vdb.VDB;
import java.io.IOException;
import java.util.ArrayList;

abstract class ISection {
    protected static int SIGN_ARCHIVE = 1;
    protected static int SIGN_ARCHIVE_FILE = 2;
    protected static int SIGN_KEY_SECTION = 128;

    public abstract IDir getDir();

    public String toString() {
        IDir dir = this.getDir();
        if (dir != null) {
            Object value = dir.getValue();
            return value == null ? null : value.toString();
        }
        return "root";
    }

    public ISection getParent() {
        IDir dir = this.getDir();
        if (dir == null) {
            return null;
        }
        return dir.getParent();
    }

    public Object getValue() {
        IDir dir = this.getDir();
        if (dir != null) {
            return dir.getValue();
        }
        return null;
    }

    public String getName() {
        IDir dir = this.getDir();
        if (dir != null) {
            return dir.getName();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object path(String opt) {
        block5: {
            if (opt == null) {
                return this.getValue();
            }
            if (opt.indexOf(97) == -1) {
                if (opt.indexOf(102) == -1) {
                    return this.getValue();
                }
                return this.getName();
            }
            seq = new Sequence();
            section = this;
            parent = this.getParent();
            if (opt.indexOf(102) != -1) ** GOTO lbl20
            while (parent != null) {
                seq.add(section.getValue());
                section = parent;
                parent = parent.getParent();
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                seq.add(section.getName());
                section = parent;
                parent = parent.getParent();
lbl20:
                // 2 sources

                ** while (parent != null)
            }
        }
        return seq.rvs();
    }

    public abstract boolean isFile();

    public abstract boolean isDir();

    public ISection getSub(VDB vdb, Sequence paths) {
        ISection sub = this;
        int i = 1;
        int len = paths.length();
        while (i <= len) {
            if ((sub = sub.getSub(vdb, paths.getMem(i))) == null) {
                return null;
            }
            ++i;
        }
        return sub;
    }

    public abstract ISection getSub(VDB var1, Object var2);

    public abstract ISection getSubForMove(VDB var1, Object var2);

    public abstract ISection getSubForMove(VDB var1, Sequence var2);

    public abstract Sequence list(VDB var1, String var2);

    public abstract Object load(VDB var1, String var2) throws IOException;

    public Object load(VDB vdb, Object path, String opt) throws IOException {
        ISection sub = path instanceof Sequence ? this.getSub(vdb, (Sequence)path) : this.getSub(vdb, path);
        if (sub != null) {
            return sub.load(vdb, opt);
        }
        return null;
    }

    public Table importTable(VDB vdb, String[] fields, Expression filter, Context ctx) throws IOException {
        if (filter == null) {
            return this.importTable(vdb, fields);
        }
        String[] filterFields = ISection.getUsedFields(filter, ctx);
        int filterCount = filterFields.length;
        if (filterCount == 0) {
            Object obj = filter.calculate(ctx);
            if (!(obj instanceof Boolean)) {
                MessageManager mm = EngineMessage.get();
                throw new RQException(mm.getMessage("engine.needBoolExp"));
            }
            if (((Boolean)obj).booleanValue()) {
                return this.importTable(vdb, fields);
            }
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int[] filterIndex = new int[filterCount];
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            list.add(str);
            ++n2;
        }
        int f = 0;
        while (f < filterCount) {
            int index = list.indexOf(filterFields[f]);
            if (index < 0) {
                filterIndex[f] = list.size();
                list.add(filterFields[f]);
            } else {
                filterIndex[f] = index;
            }
            ++f;
        }
        String[] totalFields = new String[list.size()];
        list.toArray(totalFields);
        int fcount = totalFields.length;
        DataStruct ds = new DataStruct(totalFields);
        Object[] values = new Object[fcount];
        boolean[] signs = new boolean[fcount];
        IDir dir = this.getDir();
        ISection section = this;
        while (dir != null) {
            int findex = ds.getFieldIndex(dir.getName());
            if (findex != -1) {
                values[findex] = dir.getValue();
                signs[findex] = true;
            }
            section = dir.getParent();
            dir = section.getDir();
        }
        Table table = new Table(ds);
        this.importTable(vdb, table, values, signs, filter, filterIndex, ctx);
        if (table.length() == 0) {
            return null;
        }
        if (fields.length == fcount) {
            return table;
        }
        return table.fieldsValues(fields);
    }

    public Table importTable(VDB vdb, String[] fields, Expression[] filters, Context ctx) throws IOException {
        if (filters == null) {
            return this.importTable(vdb, fields);
        }
        if (filters.length == 1) {
            return this.importTable(vdb, fields, filters[0], ctx);
        }
        int expCount = filters.length;
        String[] filterFields = ISection.getUsedFields(filters[0], ctx);
        int filterCount = filterFields.length;
        ArrayList<String> list = new ArrayList<String>();
        int[] filterIndex = new int[filterCount];
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            list.add(str);
            ++n2;
        }
        int f = 0;
        while (f < filterCount) {
            int index = list.indexOf(filterFields[f]);
            if (index < 0) {
                filterIndex[f] = list.size();
                list.add(filterFields[f]);
            } else {
                filterIndex[f] = index;
            }
            ++f;
        }
        int i = 1;
        while (i < expCount) {
            String[] stringArray2 = filterFields = ISection.getUsedFields(filters[i], ctx);
            int n3 = filterFields.length;
            n = 0;
            while (n < n3) {
                String field = stringArray2[n];
                if (!list.contains(field)) {
                    list.add(field);
                }
                ++n;
            }
            ++i;
        }
        String[] totalFields = new String[list.size()];
        list.toArray(totalFields);
        int fcount = totalFields.length;
        DataStruct ds = new DataStruct(totalFields);
        Object[] values = new Object[fcount];
        boolean[] signs = new boolean[fcount];
        IDir dir = this.getDir();
        ISection section = this;
        while (dir != null) {
            int findex = ds.getFieldIndex(dir.getName());
            if (findex != -1) {
                values[findex] = dir.getValue();
                signs[findex] = true;
            }
            section = dir.getParent();
            dir = section.getDir();
        }
        Table table = new Table(ds);
        this.importTable(vdb, table, values, signs, filters[0], filterIndex, ctx);
        int i2 = 1;
        while (i2 < expCount) {
            table.select(filters[i2], "o", ctx);
            ++i2;
        }
        if (table.length() == 0) {
            return null;
        }
        if (fields.length == fcount) {
            return table;
        }
        return table.fieldsValues(fields);
    }

    static boolean addDataToTable(Table table, Object[] values, boolean[] signs, Object data) {
        if (!(data instanceof Sequence)) {
            return false;
        }
        Sequence seq = (Sequence)data;
        DataStruct srcDs = seq.dataStruct();
        if (srcDs == null) {
            return false;
        }
        DataStruct ds = table.dataStruct();
        String[] fields = ds.getFieldNames();
        int fcount = fields.length;
        int selCount = 0;
        int[] selIndex = new int[fcount];
        int[] srcIndex = new int[fcount];
        int f = 0;
        while (f < fcount) {
            if (!signs[f]) {
                srcIndex[selCount] = srcDs.getFieldIndex(fields[f]);
                if (srcIndex[selCount] != -1) {
                    selIndex[selCount] = f;
                    ++selCount;
                }
            }
            ++f;
        }
        if (selCount == 0) {
            return false;
        }
        IArray mems = seq.getMems();
        int i = 1;
        int len = seq.length();
        while (i <= len) {
            Record r = (Record)mems.get(i);
            int f2 = 0;
            while (f2 < selCount) {
                Object val;
                values[selIndex[f2]] = val = r.getFieldValue(srcIndex[f2]);
                ++f2;
            }
            table.newLast(values);
            ++i;
        }
        int f3 = 0;
        while (f3 < selCount) {
            values[selIndex[f3]] = null;
            ++f3;
        }
        return true;
    }

    static boolean addDataToTable(Table table, Object[] values, boolean[] signs, Object data, Expression filter, Context ctx) {
        if (!(data instanceof Sequence)) {
            return false;
        }
        Sequence seq = (Sequence)data;
        DataStruct srcDs = seq.dataStruct();
        if (srcDs == null) {
            return false;
        }
        DataStruct ds = table.dataStruct();
        String[] fields = ds.getFieldNames();
        int fcount = fields.length;
        int selCount = 0;
        int[] selIndex = new int[fcount];
        int[] srcIndex = new int[fcount];
        int f = 0;
        while (f < fcount) {
            if (!signs[f]) {
                srcIndex[selCount] = srcDs.getFieldIndex(fields[f]);
                if (srcIndex[selCount] != -1) {
                    selIndex[selCount] = f;
                    ++selCount;
                }
            }
            ++f;
        }
        if (selCount == 0) {
            return false;
        }
        IArray mems = seq.getMems();
        Record newRecord = new Record(table.dataStruct());
        ComputeStack stack = ctx.getComputeStack();
        stack.push(newRecord);
        try {
            int i = 1;
            int len = seq.length();
            while (i <= len) {
                Record r = (Record)mems.get(i);
                int f2 = 0;
                while (f2 < selCount) {
                    Object val;
                    values[selIndex[f2]] = val = r.getFieldValue(srcIndex[f2]);
                    ++f2;
                }
                newRecord.setStart(0, values);
                Object result = filter.calculate(ctx);
                if (!(result instanceof Boolean)) {
                    MessageManager mm = EngineMessage.get();
                    throw new RQException(mm.getMessage("engine.needBoolExp"));
                }
                if (((Boolean)result).booleanValue()) {
                    table.newLast(values);
                }
                ++i;
            }
        }
        finally {
            stack.pop();
        }
        int f3 = 0;
        while (f3 < selCount) {
            values[selIndex[f3]] = null;
            ++f3;
        }
        return true;
    }

    protected abstract void importTable(VDB var1, Table var2, Object[] var3, boolean[] var4) throws IOException;

    protected abstract void importTable(VDB var1, Table var2, Object[] var3, boolean[] var4, Expression var5, int[] var6, Context var7) throws IOException;

    public Table importTable(VDB vdb, String[] fields) throws IOException {
        DataStruct ds = new DataStruct(fields);
        int fcount = fields.length;
        Object[] values = new Object[fcount];
        boolean[] signs = new boolean[fcount];
        IDir dir = this.getDir();
        ISection section = this;
        while (dir != null) {
            int findex = ds.getFieldIndex(dir.getName());
            if (findex != -1) {
                values[findex] = dir.getValue();
                signs[findex] = true;
            }
            section = dir.getParent();
            dir = section.getDir();
        }
        Table table = new Table(ds);
        this.importTable(vdb, table, values, signs);
        return table.length() > 0 ? table : null;
    }

    private static String[] getUsedFields(Expression exp, Context ctx) {
        ArrayList<String> fieldList = new ArrayList<String>();
        ISection.getUsedFields(exp.getHome(), ctx, fieldList);
        int count = fieldList.size();
        if (count > 0) {
            String[] fields = new String[count];
            fieldList.toArray(fields);
            return fields;
        }
        return new String[0];
    }

    private static void getUsedFields(Node node, Context ctx, ArrayList<String> fields) {
        if (node == null) {
            return;
        }
        if (node instanceof UnknownSymbol) {
            ComputeStack stack = ctx.getComputeStack();
            if (stack.isStackEmpty()) {
                String name = ((UnknownSymbol)node).getName();
                if (EnvUtil.getParam(name, ctx) == null) {
                    fields.add(name);
                }
            } else {
                try {
                    node.calculate(ctx);
                }
                catch (Exception e) {
                    String name = ((UnknownSymbol)node).getName();
                    fields.add(name);
                }
            }
        } else if (node instanceof FieldRef) {
            FieldRef field = (FieldRef)node;
            fields.add(field.getName());
        } else if (node instanceof Function) {
            IParam param = ((Function)node).getParam();
            if (param != null) {
                ArrayList<Expression> list = new ArrayList<Expression>();
                param.getAllLeafExpression(list);
                for (Expression exp : list) {
                    if (exp == null) continue;
                    ISection.getUsedFields(exp.getHome(), ctx, fields);
                }
            }
        } else {
            ISection.getUsedFields(node.getLeft(), ctx, fields);
            ISection.getUsedFields(node.getRight(), ctx, fields);
        }
    }

    public Sequence retrieve(VDB vdb, String[] dirNames, Object[] dirValues, boolean[] valueSigns, String[] fields, Expression exp, boolean isRecursion, Context ctx) throws IOException {
        Filter filter = new Filter(dirNames, dirValues, valueSigns, fields, exp, ctx);
        Sequence out = new Sequence(1024);
        this.retrieve(vdb, filter, isRecursion, out);
        return out;
    }

    protected abstract void retrieve(VDB var1, Filter var2, boolean var3, Sequence var4) throws IOException;

    public abstract int lockForWrite(VDB var1);

    public abstract void unlock(VDB var1);

    public abstract void rollBack(Library var1);

    public abstract int save(VDB var1, Object var2);

    public abstract int save(VDB var1, Object var2, Object var3, Object var4);

    public abstract int makeDir(VDB var1, Object var2, Object var3);

    public abstract int createSubKeyDir(VDB var1, Object var2, int var3);

    public abstract Sequence saveBlob(VDB var1, Sequence var2, Sequence var3, String var4);

    public abstract int update(VDB var1, String[] var2, Object[] var3, boolean[] var4, Object[] var5, String[] var6, Expression var7, boolean var8, Context var9);

    public abstract int delete(VDB var1);

    public abstract boolean deleteNullSection(VDB var1);

    public abstract int move(VDB var1, Section var2, Object var3);

    public abstract void deleteOutdatedZone(Library var1, int var2, long var3);

    public abstract void commit(Library var1, int var2, long var3) throws IOException;

    public abstract long getCommitTime();

    public abstract int rename(VDB var1, Object var2, String var3);

    public abstract void scanUsedBlocks(Library var1, BlockManager var2) throws IOException;

    public abstract void releaseSubSection();

    public abstract void reset(Library var1, Library var2, int var3) throws IOException;

    public static ISection read(Library library, int header, Dir dir) {
        try {
            byte[] bytes = library.readBlocks(header);
            int dataPos = Library.getDataPos(bytes);
            if ((bytes[dataPos] & SIGN_ARCHIVE) == 0) {
                return new Section(dir, header, bytes);
            }
            return new ArchiveSection(dir, header, bytes);
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }
}

