/*
 * Decompiled with CFR 0.152.
 */
package com.scudata.vdb;

import com.scudata.common.MessageManager;
import com.scudata.common.RQException;
import com.scudata.dm.Context;
import com.scudata.dm.DataStruct;
import com.scudata.dm.FileObject;
import com.scudata.dm.Record;
import com.scudata.dm.Sequence;
import com.scudata.dm.Table;
import com.scudata.expression.Expression;
import com.scudata.resources.EngineMessage;
import com.scudata.vdb.ArchiveSection;
import com.scudata.vdb.BlockManager;
import com.scudata.vdb.Dir;
import com.scudata.vdb.DirZone;
import com.scudata.vdb.Filter;
import com.scudata.vdb.HeaderBlock;
import com.scudata.vdb.IDir;
import com.scudata.vdb.ISection;
import com.scudata.vdb.IVS;
import com.scudata.vdb.Library;
import com.scudata.vdb.VDB;
import com.scudata.vdb.VS;
import com.scudata.vdb.Zone;
import java.io.IOException;
import java.util.ArrayList;

class Section
extends ISection {
    private int header;
    private volatile HeaderBlock headerBlock;
    private Dir dir;
    private volatile VDB lockVDB;
    private boolean isModified;

    public Section(Dir dir) {
        this.headerBlock = new HeaderBlock();
        this.dir = dir;
    }

    public Section(Dir dir, int header, byte[] bytes) throws IOException {
        this.dir = dir;
        this.header = header;
        this.headerBlock = new HeaderBlock();
        this.headerBlock.read(bytes, this);
    }

    public void setHeader(int header) {
        this.header = header;
    }

    @Override
    public IDir getDir() {
        return this.dir;
    }

    @Override
    public boolean isFile() {
        return this.headerBlock.isFile();
    }

    @Override
    public boolean isDir() {
        return this.headerBlock.isDir();
    }

    private boolean isNullSection() {
        return this.headerBlock.isNullSection();
    }

    private boolean isLockVDB(VDB vdb) {
        return this.lockVDB == vdb;
    }

    public Section getParentSection() {
        if (this.dir == null) {
            return null;
        }
        return this.dir.getParentSection();
    }

    @Override
    public ISection getSub(VDB vdb, Object path) {
        if (this.headerBlock.isKeySection()) {
            Dir dir = this.headerBlock.getSubKeyDir(path);
            ISection section = dir.getLastZone().getSection(vdb.getLibrary(), dir);
            return section.getSub(vdb, path);
        }
        Dir subDir = this.headerBlock.getSubDir(path);
        if (subDir == null) {
            return null;
        }
        DirZone zone = subDir.getZone(vdb, this.isLockVDB(vdb));
        if (zone == null) {
            return null;
        }
        return zone.getSection(vdb.getLibrary(), subDir);
    }

    private Section getSubForWrite(VDB vdb, Sequence paths, Sequence names) {
        int pcount;
        int diff = pcount = paths.length();
        if (names != null) {
            diff -= names.length();
        }
        Section sub = this;
        int i = 1;
        while (i <= pcount) {
            int index = i - diff;
            String name = index > 0 ? (String)names.getMem(index) : null;
            if ((sub = sub.getSubForWrite(vdb, paths.getMem(i), name)) == null) {
                return null;
            }
            ++i;
        }
        return sub;
    }

    private Section getSubForWrite(VDB vdb, Object path, String name) {
        if (this.headerBlock.isKeySection()) {
            Dir dir = this.headerBlock.getSubKeyDir(path);
            Section section = dir.getLastZone().getSectionForWrite(vdb.getLibrary(), dir);
            return section.getSubForWrite(vdb, path, name);
        }
        int result = this.lock(vdb);
        if (result == 1) {
            return null;
        }
        try {
            Library library = vdb.getLibrary();
            Dir subDir = this.headerBlock.getSubDir(path);
            if (subDir == null) {
                if (result != -1) {
                    vdb.addModifySection(this);
                }
                this.isModified = true;
                subDir = this.headerBlock.createSubDir(path, name, this);
                DirZone zone = subDir.getLastZone();
                return zone.getSectionForWrite(library, subDir);
            }
            DirZone zone = subDir.getLastZone();
            if (zone == null || !zone.valid()) {
                if (result != -1) {
                    vdb.addModifySection(this);
                }
                this.isModified = true;
                zone = subDir.addZone(0);
                return zone.getSectionForWrite(library, subDir);
            }
            if (result != -1) {
                this.unlock();
            }
            return zone.getSectionForWrite(library, subDir);
        }
        catch (Exception e) {
            this.unlock();
            return null;
        }
    }

    @Override
    public Section getSubForMove(VDB vdb, Object path) {
        if (this.headerBlock.isKeySection()) {
            Dir dir = this.headerBlock.getSubKeyDir(path);
            DirZone zone = dir.getLastZone();
            Section section = zone.getSectionForWrite(vdb.getLibrary(), dir);
            return section.getSubForMove(vdb, path);
        }
        Dir subDir = this.headerBlock.getSubDir(path);
        if (subDir == null) {
            return null;
        }
        DirZone zone = subDir.getLastZone();
        if (zone == null || !zone.valid()) {
            return null;
        }
        return zone.getSectionForWrite(vdb.getLibrary(), subDir);
    }

    @Override
    public Section getSubForMove(VDB vdb, Sequence paths) {
        Section sub = this;
        int i = 1;
        int pcount = paths.length();
        while (i <= pcount) {
            if ((sub = sub.getSubForMove(vdb, paths.getMem(i))) == null) {
                return null;
            }
            ++i;
        }
        return sub;
    }

    public synchronized int lock(VDB vdb) {
        if (this.lockVDB == null) {
            this.lockVDB = vdb;
            return 0;
        }
        if (this.lockVDB != vdb) {
            block5: {
                try {
                    this.wait(8000L);
                    if (this.lockVDB == null) break block5;
                    vdb.setError(1);
                    return 1;
                }
                catch (InterruptedException e) {
                    vdb.setError(1);
                    return 1;
                }
            }
            this.lockVDB = vdb;
            return 0;
        }
        return -1;
    }

    @Override
    public synchronized int lockForWrite(VDB vdb) {
        if (this.lockVDB == null) {
            this.lockVDB = vdb;
            vdb.addModifySection(this);
            return 0;
        }
        if (this.lockVDB != vdb) {
            block5: {
                try {
                    this.wait(8000L);
                    if (this.lockVDB == null) break block5;
                    vdb.setError(1);
                    return 1;
                }
                catch (InterruptedException e) {
                    vdb.setError(1);
                    return 1;
                }
            }
            this.lockVDB = vdb;
            vdb.addModifySection(this);
            return 0;
        }
        return 0;
    }

    public synchronized void unlock() {
        this.isModified = false;
        this.lockVDB = null;
        this.notify();
    }

    @Override
    public synchronized void unlock(VDB vdb) {
        if (this.lockVDB == vdb) {
            if (this.isModified) {
                this.headerBlock.roolBack(vdb.getLibrary());
            }
            this.isModified = false;
            this.lockVDB = null;
            this.notify();
        }
    }

    @Override
    public void rollBack(Library library) {
        if (this.isModified) {
            this.headerBlock.roolBack(library);
        }
        this.unlock();
    }

    @Override
    public Sequence list(VDB vdb, String opt) {
        Dir[] dirs = this.headerBlock.getSubDirs();
        if (dirs == null) {
            return null;
        }
        int size = dirs.length;
        Sequence seq = new Sequence(size);
        boolean isLockVDB = this.isLockVDB(vdb);
        Library library = vdb.getLibrary();
        boolean listFiles = true;
        boolean listDirs = false;
        if (opt != null) {
            if (opt.indexOf(119) != -1) {
                listFiles = false;
            } else if (opt.indexOf(100) != -1) {
                listDirs = true;
                listFiles = false;
            }
            if (opt.indexOf(108) != -1) {
                this.lockForWrite(vdb);
            }
        }
        Dir[] dirArray = dirs;
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            Dir dir = dirArray[n2];
            DirZone zone = dir.getZone(vdb, isLockVDB);
            if (zone != null) {
                ISection section = zone.getSection(library, dir);
                if (listFiles) {
                    if (section.isFile()) {
                        seq.add(new VS(vdb, section));
                    }
                } else if (listDirs) {
                    if (section.isDir()) {
                        seq.add(new VS(vdb, section));
                    }
                } else {
                    seq.add(new VS(vdb, section));
                }
            }
            ++n2;
        }
        return seq;
    }

    @Override
    public Object load(VDB vdb, String opt) throws IOException {
        int result;
        if (opt != null && opt.indexOf(108) != -1 && (result = this.lockForWrite(vdb)) == 1) {
            return null;
        }
        Zone zone = this.headerBlock.getFileZone(vdb, this.isLockVDB(vdb));
        if (zone != null) {
            return zone.getData(vdb.getLibrary());
        }
        return null;
    }

    @Override
    public int save(VDB vdb, Object value) {
        int result = this.lockForWrite(vdb);
        if (result == 1) {
            return 1;
        }
        this.isModified = true;
        Library library = vdb.getLibrary();
        int block = library.writeDataBlock(this.header, value);
        this.headerBlock.createFileZone(library, block);
        return 0;
    }

    @Override
    public int save(VDB vdb, Object value, Object path, Object name) {
        Section sub;
        if (path instanceof Sequence) {
            Sequence paths = (Sequence)path;
            Sequence names = null;
            if (name instanceof Sequence) {
                names = (Sequence)name;
                int i = 1;
                int len = names.length();
                while (i <= len) {
                    Object obj = names.getMem(i);
                    if (!(obj instanceof String)) {
                        vdb.setError(5);
                        return 5;
                    }
                    ++i;
                }
            } else if (name instanceof String) {
                names = new Sequence(1);
                names.add(names);
            } else if (name != null) {
                vdb.setError(5);
                return 5;
            }
            sub = this.getSubForWrite(vdb, paths, names);
        } else {
            if (name != null && !(name instanceof String)) {
                vdb.setError(5);
                return 5;
            }
            sub = this.getSubForWrite(vdb, path, (String)name);
        }
        if (sub != null) {
            return sub.save(vdb, value);
        }
        return 1;
    }

    @Override
    public int makeDir(VDB vdb, Object path, Object name) {
        Section sub;
        if (path instanceof Sequence) {
            Sequence paths = (Sequence)path;
            Sequence names = null;
            if (name instanceof Sequence) {
                names = (Sequence)name;
                int i = 1;
                int len = names.length();
                while (i <= len) {
                    Object obj = names.getMem(i);
                    if (!(obj instanceof String)) {
                        vdb.setError(5);
                        return 5;
                    }
                    ++i;
                }
            } else if (name instanceof String) {
                names = new Sequence(1);
                names.add(name);
            } else if (name != null) {
                vdb.setError(5);
                return 5;
            }
            sub = this.getSubForWrite(vdb, paths, names);
        } else {
            if (name != null && !(name instanceof String)) {
                vdb.setError(5);
                return 5;
            }
            sub = this.getSubForWrite(vdb, path, (String)name);
        }
        if (sub != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int createSubKeyDir(VDB vdb, Object key, int len) {
        int result = this.lockForWrite(vdb);
        if (result == 1) {
            return result;
        }
        Library library = vdb.getLibrary();
        this.isModified = true;
        Dir subDir = this.headerBlock.createSubDir(key, null, this);
        DirZone zone = subDir.getLastZone();
        Section section = zone.getSectionForWrite(library, subDir);
        section.setKeySection(vdb, len);
        return 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Sequence saveBlob(VDB vdb, Sequence oldValues, Sequence newValues, String name) {
        block23: {
            block19: {
                block20: {
                    deleteList = new ArrayList<Object>();
                    addDirs = new ArrayList<Integer>();
                    addBlobs = new ArrayList<Object>();
                    result = null;
                    if (newValues != null && newValues.length() != 0) break block19;
                    if (oldValues == null || oldValues.length() <= 0) break block20;
                    len = oldValues.length();
                    i = 1;
                    if (true) ** GOTO lbl49
                }
                return new Sequence(0);
            }
            len = newValues.length();
            result = new Sequence(len);
            try {
                block21: {
                    if (oldValues != null && oldValues.length() != 0) break block21;
                    i = 1;
                    if (true) ** GOTO lbl63
                }
                max = -2147483648;
                i = 1;
                var12_17 = oldValues.length();
                while (true) {
                    block22: {
                        if (i <= var12_17) break block22;
                        i = 1;
                        if (true) ** GOTO lbl83
                    }
                    val = oldValues.getMem(i);
                    if (!(val instanceof Integer)) {
                        vdb.setError(5);
                        return null;
                    }
                    deleteList.add(val);
                    n = (Integer)val;
                    if (max < n) {
                        max = n;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                vdb.setError(4);
                return null;
            }
            do {
                if (!((val = oldValues.getMem(i)) instanceof Integer)) {
                    vdb.setError(5);
                    return null;
                }
                deleteList.add(val);
                ++i;
lbl49:
                // 2 sources

            } while (i <= len);
            break block23;
            do {
                if (!((val = newValues.getMem(i)) instanceof String)) {
                    vdb.setError(5);
                    return null;
                }
                var12_16 = new FileObject((String)val);
                val = var12_16.read(0L, -1L, "b");
                addBlobs.add(val);
                addDirs.add(i);
                result.add(i);
                ++i;
lbl63:
                // 2 sources

            } while (i <= len);
            break block23;
            do {
                if ((var12_18 = newValues.getMem(i)) instanceof String) {
                    fo = new FileObject((String)var12_18);
                    var12_19 = fo.read(0L, -1L, "b");
                    addBlobs.add(var12_19);
                    addDirs.add(++max);
                    result.add(max);
                } else {
                    if (!(var12_18 instanceof Integer)) {
                        vdb.setError(5);
                        return null;
                    }
                    if (!deleteList.remove(var12_18)) {
                        vdb.setError(6);
                        return null;
                    }
                    result.add(var12_18);
                }
                ++i;
lbl83:
                // 2 sources

            } while (i <= len);
        }
        deleteSize = deleteList.size();
        addSize = addBlobs.size();
        if (deleteSize == 0 && addSize == 0) {
            return result;
        }
        state = this.lockForWrite(vdb);
        if (state == 1) {
            return null;
        }
        for (E var12_22 : deleteList) {
            sub = this.getSub(vdb, var12_22);
            if (sub == null) continue;
            sub.delete(vdb);
        }
        var12_23 = false;
        while (var12_24 < addSize) {
            p = addDirs.get((int)var12_24);
            v = addBlobs.get((int)var12_24);
            sub = this.getSubForWrite(vdb, p, name);
            if (sub == null) {
                return null;
            }
            sub.save(vdb, v);
            ++var12_24;
        }
        return result;
    }

    private void setKeySection(VDB vdb, int len) {
        this.isModified = true;
        this.headerBlock.setKeySection(vdb, this, len);
    }

    @Override
    protected void importTable(VDB vdb, Table table, Object[] values, boolean[] signs, Expression filter, int[] filterIndex, Context ctx) throws IOException {
        Dir[] subDirs;
        boolean isLockVDB = this.isLockVDB(vdb);
        Library library = vdb.getLibrary();
        Zone zone = this.headerBlock.getFileZone(vdb, isLockVDB);
        if (zone != null) {
            Object data = zone.getData(library);
            Section.addDataToTable(table, values, signs, data, filter, ctx);
        }
        if ((subDirs = this.headerBlock.getSubDirs()) == null) {
            return;
        }
        DataStruct ds = table.dataStruct();
        Dir[] dirArray = subDirs;
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            ISection sub;
            Dir dir = dirArray[n2];
            DirZone dirZone = dir.getZone(vdb, isLockVDB);
            if (dirZone != null && (sub = dirZone.getSection(library, dir)) != null) {
                int findex = ds.getFieldIndex(dir.getName());
                if (findex != -1) {
                    values[findex] = dir.getValue();
                    signs[findex] = true;
                    boolean isAll = true;
                    int[] nArray = filterIndex;
                    int n3 = filterIndex.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        int index = nArray[n4];
                        if (!signs[index]) {
                            isAll = false;
                            break;
                        }
                        ++n4;
                    }
                    if (isAll) {
                        Record r = new Record(ds, values);
                        Object result = r.calc(filter, ctx);
                        if (!(result instanceof Boolean)) {
                            MessageManager mm = EngineMessage.get();
                            throw new RQException(mm.getMessage("engine.needBoolExp"));
                        }
                        if (((Boolean)result).booleanValue()) {
                            sub.importTable(vdb, table, values, signs);
                        }
                    } else {
                        sub.importTable(vdb, table, values, signs, filter, filterIndex, ctx);
                    }
                    values[findex] = null;
                    signs[findex] = false;
                } else {
                    sub.importTable(vdb, table, values, signs, filter, filterIndex, ctx);
                }
            }
            ++n2;
        }
    }

    @Override
    protected void importTable(VDB vdb, Table table, Object[] values, boolean[] signs) throws IOException {
        Dir[] subDirs;
        boolean isLockVDB = this.isLockVDB(vdb);
        Library library = vdb.getLibrary();
        Zone zone = this.headerBlock.getFileZone(vdb, isLockVDB);
        if (zone != null) {
            Object data = zone.getData(library);
            Section.addDataToTable(table, values, signs, data);
        }
        if ((subDirs = this.headerBlock.getSubDirs()) == null) {
            return;
        }
        DataStruct ds = table.dataStruct();
        Dir[] dirArray = subDirs;
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            ISection sub;
            Dir dir = dirArray[n2];
            DirZone dirZone = dir.getZone(vdb, isLockVDB);
            if (dirZone != null && (sub = dirZone.getSection(library, dir)) != null) {
                int findex = ds.getFieldIndex(dir.getName());
                if (findex != -1) {
                    values[findex] = dir.getValue();
                    signs[findex] = true;
                    sub.importTable(vdb, table, values, signs);
                    values[findex] = null;
                    signs[findex] = false;
                } else {
                    sub.importTable(vdb, table, values, signs);
                }
            }
            ++n2;
        }
    }

    @Override
    protected void retrieve(VDB vdb, Filter filter, boolean isRecursion, Sequence out) throws IOException {
        Dir[] subDirs;
        Library library;
        if (filter.isDirMatch()) {
            Object data;
            Sequence seq;
            boolean isLockVDB = this.isLockVDB(vdb);
            library = vdb.getLibrary();
            Zone zone = this.headerBlock.getFileZone(vdb, isLockVDB);
            if (zone != null && (seq = filter.select(data = zone.getData(library))) != null) {
                out.addAll(seq);
            }
            if (!isRecursion) {
                return;
            }
        }
        if ((subDirs = this.headerBlock.getSubDirs()) == null) {
            return;
        }
        library = vdb.getLibrary();
        boolean isLockVDB = this.isLockVDB(vdb);
        Dir[] dirArray = subDirs;
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            ISection sub;
            Dir dir = dirArray[n2];
            DirZone dirZone = dir.getZone(vdb, isLockVDB);
            if (dirZone != null && (sub = dirZone.getSection(library, dir)) != null && filter.pushDir(dir.getName(), dir.getValue())) {
                sub.retrieve(vdb, filter, isRecursion, out);
                filter.popDir();
            }
            ++n2;
        }
    }

    @Override
    public int update(VDB vdb, String[] dirNames, Object[] dirValues, boolean[] valueSigns, Object[] fvals, String[] fields, Expression exp, boolean isRecursion, Context ctx) {
        Filter filter = new Filter(dirNames, dirValues, valueSigns, exp, ctx);
        try {
            return this.update(vdb, filter, fvals, fields, isRecursion);
        }
        catch (IOException e) {
            return 4;
        }
    }

    private int update(VDB vdb, Filter filter, Object[] fvals, String[] fields, boolean isRecursion) throws IOException {
        Dir[] subDirs;
        Library library;
        if (filter.isDirMatch()) {
            Object data;
            int result = this.lockForWrite(vdb);
            if (result == 1) {
                return 1;
            }
            library = vdb.getLibrary();
            Zone zone = this.headerBlock.getFileZone(vdb, true);
            if (zone != null && filter.update(data = zone.getData(library), fvals, fields)) {
                int block = library.writeDataBlock(this.header, data);
                this.headerBlock.createFileZone(library, block);
                this.isModified = true;
            }
            if (!isRecursion) {
                return 0;
            }
        }
        if ((subDirs = this.headerBlock.getSubDirs()) == null) {
            return 0;
        }
        library = vdb.getLibrary();
        boolean isLockVDB = this.isLockVDB(vdb);
        Dir[] dirArray = subDirs;
        int n = subDirs.length;
        int n2 = 0;
        while (n2 < n) {
            Section sub;
            Dir dir = dirArray[n2];
            DirZone dirZone = dir.getZone(vdb, isLockVDB);
            if (dirZone != null && (sub = dirZone.getSectionForWrite(library, dir)) != null && filter.pushDir(dir.getName(), dir.getValue())) {
                int result = sub.update(vdb, filter, fvals, fields, isRecursion);
                if (result != 0) {
                    return result;
                }
                filter.popDir();
            }
            ++n2;
        }
        return 0;
    }

    @Override
    public int delete(VDB vdb) {
        Section parent = this.getParentSection();
        if (parent != null) {
            int result = parent.lockForWrite(vdb);
            if (result == 1) {
                vdb.setError(1);
                return 1;
            }
            parent.deleteSubDir(vdb, this.dir);
            return 0;
        }
        int result = this.lockForWrite(vdb);
        if (result == 1) {
            vdb.setError(1);
            return 1;
        }
        this.deleteAllSubDirs(vdb);
        return 0;
    }

    @Override
    public boolean deleteNullSection(VDB vdb) {
        int result = this.lockForWrite(vdb);
        if (result == 1) {
            return false;
        }
        Dir[] subDirs = this.headerBlock.getSubDirs();
        boolean isSubDelete = false;
        if (subDirs != null) {
            Library library = vdb.getLibrary();
            Dir[] dirArray = subDirs;
            int n = subDirs.length;
            int n2 = 0;
            while (n2 < n) {
                Dir dir = dirArray[n2];
                DirZone zone = dir.getLastZone();
                if (zone != null && zone.valid()) {
                    ISection section = zone.getSection(library, dir);
                    if (section.deleteNullSection(vdb)) {
                        this.headerBlock.removeSubDir(dir);
                        isSubDelete = true;
                    }
                    zone.releaseSection();
                }
                ++n2;
            }
        }
        if (this.isNullSection()) {
            if (this.dir == null && isSubDelete) {
                this.isModified = true;
            } else {
                vdb.removeModifySection(this);
            }
            return true;
        }
        if (isSubDelete) {
            this.isModified = true;
        } else {
            vdb.removeModifySection(this);
        }
        return false;
    }

    @Override
    public int move(VDB vdb, Section dest, Object value) {
        Section parent = (Section)this.getParent();
        if (parent == null) {
            return 2;
        }
        if (value == null) {
            value = this.dir.getValue();
        }
        if (dest.getSub(vdb, value) != null) {
            return 3;
        }
        if (this.lockForWrite(vdb) == 1) {
            return 1;
        }
        if (parent.lockForWrite(vdb) == 1) {
            return 1;
        }
        if (dest.lockForWrite(vdb) == 1) {
            return 1;
        }
        parent.moveSubDir(vdb, this.dir, this);
        Dir subDir = dest.createSubDir(vdb, value, this.dir.getName());
        if (this.header <= 0) {
            this.header = vdb.getLibrary().applyHeaderBlock();
        }
        this.dir = subDir;
        DirZone zone = subDir.getLastZone();
        zone.setSection(this.header, this);
        return 0;
    }

    private Dir createSubDir(VDB vdb, Object path, String name) {
        this.isModified = true;
        return this.headerBlock.createSubDir(path, name, this);
    }

    private void deleteSubDir(VDB vdb, Dir dir) {
        this.isModified = true;
        this.headerBlock.deleteSubDir(dir);
    }

    private void moveSubDir(VDB vdb, Dir dir, ISection section) {
        this.isModified = true;
        this.headerBlock.moveSubDir(dir, section);
    }

    private void deleteAllSubDirs(VDB vdb) {
        this.isModified = true;
        this.headerBlock.deleteAllSubDirs();
    }

    @Override
    public void deleteOutdatedZone(Library library, int outerSeq, long txSeq) {
        this.headerBlock.deleteOutdatedZone(library, outerSeq, txSeq);
    }

    @Override
    public void commit(Library library, int outerSeq, long innerSeq) throws IOException {
        if (this.isModified && this.header > 0) {
            this.headerBlock.commit(library, this.header, outerSeq, innerSeq);
        }
        this.unlock();
    }

    @Override
    public void scanUsedBlocks(Library library, BlockManager manager) throws IOException {
        manager.setBlockUsed(this.header);
        this.headerBlock.scanUsedBlocks(library, manager);
    }

    @Override
    public long getCommitTime() {
        return this.headerBlock.getCommitTime();
    }

    @Override
    public int rename(VDB vdb, Object path, String name) {
        Section section;
        ISection sub;
        if (path instanceof Sequence) {
            sub = this.getSub(vdb, (Sequence)path);
            if (sub instanceof ArchiveSection) {
                throw ArchiveSection.getModifyException();
            }
            section = (Section)sub;
        } else if (path != null) {
            sub = this.getSub(vdb, path);
            if (sub instanceof ArchiveSection) {
                throw ArchiveSection.getModifyException();
            }
            section = (Section)sub;
        } else {
            section = this;
        }
        if (section == null) {
            return 0;
        }
        Dir dir = section.dir;
        if (dir.isEqualName(name)) {
            return 0;
        }
        Section parent = dir.getParentSection();
        int result = parent.lockForWrite(vdb);
        if (result == 1) {
            return result;
        }
        parent.isModified = true;
        dir.rename(name);
        return 0;
    }

    public boolean isKeySection() {
        return this.headerBlock.isKeySection();
    }

    public ArrayList<ISection> getSubList(Library library) {
        return this.headerBlock.getSubList(library);
    }

    public int archive(VDB vdb, Object path) {
        if (path instanceof Sequence) {
            Sequence seq = (Sequence)path;
            int len = seq.length();
            if (len == 0) {
                return 6;
            }
            Section section = this;
            int i = 1;
            while (i < len) {
                ISection tmp = section.getSub(vdb, seq.getMem(i));
                if (!(tmp instanceof Section)) {
                    return 7;
                }
                section = (Section)tmp;
                ++i;
            }
            return section.archive(vdb, seq.getMem(len));
        }
        this.lockForWrite(vdb);
        Dir subDir = this.headerBlock.getSubDir(path);
        if (subDir == null) {
            return 2;
        }
        DirZone zone = subDir.getLastZone();
        if (zone == null || !zone.valid()) {
            return 2;
        }
        Library library = vdb.getLibrary();
        ISection sub = zone.getSection(library, subDir);
        if (!(sub instanceof Section)) {
            return 7;
        }
        try {
            int subHeader = ArchiveSection.archive(vdb, (Section)sub);
            subDir.addZone(subHeader);
            this.isModified = true;
            return 0;
        }
        catch (IOException e) {
            throw new RQException(e.getMessage(), e);
        }
    }

    @Override
    public void releaseSubSection() {
        this.headerBlock.releaseSubSection();
    }

    @Override
    public void reset(Library srcLib, Library destLib, int destHeader) throws IOException {
        this.headerBlock.reset(srcLib, destLib, destHeader);
    }

    public int copy(VDB vdb, VDB srcVdb, ISection srcSection) {
        Sequence subs;
        IDir dir = srcSection.getDir();
        Section destSection = this.getSubForWrite(vdb, dir.getValue(), dir.getName());
        if (srcSection.isFile()) {
            try {
                Object value = srcSection.load(srcVdb, null);
                int state = destSection.save(vdb, value);
                if (state != 0) {
                    return state;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                vdb.setError(4);
                return 4;
            }
        }
        if ((subs = srcSection.list(srcVdb, "w")) != null) {
            int i = 1;
            int size = subs.length();
            while (i <= size) {
                IVS sub = (IVS)subs.getMem(i);
                int state = destSection.copy(vdb, srcVdb, sub.getHome());
                if (state != 0) {
                    return state;
                }
                ++i;
            }
        }
        return 0;
    }
}

